/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.docrepo.File;
import com.arsdigita.docrepo.ui.DRConstants;
import com.arsdigita.docrepo.ui.DRUtils;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.versioning.TransactionCollection;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

class FilePropertiesPanel
extends SimpleComponent
implements DRConstants {
    private static final Logger s_log = Logger.getLogger(FilePropertiesPanel.class);

    FilePropertiesPanel() {
    }

    public void generateXML(PageState state, Element parent) {
        BigDecimal id = (BigDecimal)state.getValue((ParameterModel)FILE_ID_PARAM);
        Element element = parent.newChildElement("docs:file-info", "http://www.arsdigita.com/docs-ui/1.0");
        try {
            File file = new File(id);
            file.assertPrivilege(PrivilegeDescriptor.READ);
            Element nameElement = element.newChildElement("docs:name", "http://www.arsdigita.com/docs-ui/1.0");
            nameElement.setText(file.getName());
            Element descriptionElement = element.newChildElement("docs:description", "http://www.arsdigita.com/docs-ui/1.0");
            String description = file.getDescription();
            if (description != null) {
                descriptionElement.setText(description);
            }
            Element sizeElement = element.newChildElement("docs:size", "http://www.arsdigita.com/docs-ui/1.0");
            sizeElement.setText(DRUtils.FileSize.formatFileSize(file.getSize(), state));
            Element typeElement = element.newChildElement("docs:type", "http://www.arsdigita.com/docs-ui/1.0");
            MimeType mimeType = MimeType.loadMimeType((String)file.getContentType());
            typeElement.setText(mimeType.getLabel());
            Element lastModifiedElement = element.newChildElement("docs:last-modified", "http://www.arsdigita.com/docs-ui/1.0");
            lastModifiedElement.setText(DRUtils.DateFormat.format(file.getLastModifiedDate()));
            Element revisionElement = element.newChildElement("docs:revision", "http://www.arsdigita.com/docs-ui/1.0");
            TransactionCollection tc = file.getTransactions();
            long numRevs = tc.size();
            revisionElement.setText(numRevs + "");
            Element authorElement = element.newChildElement("docs:author", "http://www.arsdigita.com/docs-ui/1.0");
            User author = file.getCreationUser();
            if (null != author) {
                authorElement.setText(author.getName());
            } else {
                authorElement.setText("Unknown");
            }
            Element uriElement = element.newChildElement("docs:uri", "http://www.arsdigita.com/docs-ui/1.0");
            uriElement.setText(FilePropertiesPanel.makeFileURL(file, state));
        }
        catch (DataObjectNotFoundException exc) {
            Element notfoundElement = element.newChildElement("docs:notfound", "http://www.arsdigita.com/docs-ui/1.0");
        }
    }

    private static String makeFileURL(File file, PageState state) {
        HttpServletRequest req = state.getRequest();
        ParameterMap params = new ParameterMap();
        params.setParameter(FILE_ID_PARAM.getName(), (Object)file.getID());
        return URL.here((HttpServletRequest)req, (String)("/download/" + file.getName()), (ParameterMap)params).toString();
    }
}

