/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.docrepo.File;
import com.arsdigita.docrepo.ui.DRConstants;
import com.arsdigita.docrepo.ui.DRUtils;
import com.arsdigita.docrepo.ui.FileInfoHistoryPane;
import com.arsdigita.kernel.User;
import com.arsdigita.versioning.Tag;
import com.arsdigita.versioning.TagCollection;
import com.arsdigita.versioning.Transaction;
import com.arsdigita.versioning.TransactionCollection;
import java.math.BigDecimal;

class FileRevisionsTableModel
implements TableModel,
DRConstants {
    private FileInfoHistoryPane m_parent;
    private File m_file;
    private PageState m_state;
    private TransactionCollection m_tc;
    private Transaction m_transaction;
    private Transaction m_lastContentChange;
    private int m_row;
    private int m_last = 2;

    FileRevisionsTableModel(File file, PageState state) {
        this.m_file = file;
        this.m_state = state;
        this.m_tc = this.m_file.getTransactions();
        this.m_last = this.m_row = (int)this.m_tc.size() + 1;
    }

    public int getColumnCount() {
        return 5;
    }

    public Object getElementAt(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return new BigDecimal(this.m_row);
            }
            case 1: {
                User user = this.m_file.getLastModifiedUser();
                if (null == user) {
                    return "Unknown";
                }
                return user.getPersonName().toString();
            }
            case 2: {
                if (this.m_row == 0) {
                    return DRUtils.DateFormat.format(this.m_file.getCreationDate());
                }
                return DRUtils.DateFormat.format(this.m_file.getLastModifiedDate());
            }
            case 3: {
                StringBuffer sb = new StringBuffer();
                TagCollection tc = this.m_transaction.getTags();
                int counter = 0;
                while (tc.next()) {
                    Tag t = tc.getTag();
                    sb.append(++counter + ") " + t.getDescription() + "  ");
                }
                return sb.toString();
            }
            case 4: {
                return "download";
            }
        }
        return null;
    }

    public Object getKeyAt(int columnIndex) {
        if (columnIndex == 4) {
            if (this.m_row == this.m_last - 1) {
                return "current";
            }
            return this.m_transaction.getID();
        }
        return this.m_file.getID() + "." + this.m_row;
    }

    public boolean nextRow() {
        --this.m_row;
        if (this.m_tc.next()) {
            this.m_transaction = this.m_tc.getTransaction();
            return true;
        }
        this.m_tc.close();
        return false;
    }
}

