/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.docrepo.File;
import com.arsdigita.docrepo.Util;
import com.arsdigita.docrepo.ui.CancelButton;
import com.arsdigita.docrepo.ui.DRConstants;
import com.arsdigita.docrepo.ui.DRUtils;
import com.arsdigita.docrepo.ui.FileInfoPropertiesPane;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.mail.Mail;
import com.arsdigita.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;

class FileSendColleagueForm
extends Form
implements FormProcessListener,
FormInitListener,
DRConstants {
    private static final char EMAIL_SEPARATOR = ';';
    private static final String EMAIL_LIST = "emailList";
    private static final String EMAIL_SUBJECT = "subject";
    private static final String DESCRIPTION = "description";
    private RequestLocal m_fileData;
    private TextField m_emailList;
    private TextField m_subject;
    private TextArea m_message;
    private FileInfoPropertiesPane m_parent;

    FileSendColleagueForm(FileInfoPropertiesPane parent) {
        super("FileSendColleagueForm", (Container)new ColumnPanel(2));
        this.m_parent = parent;
        this.m_fileData = new RequestLocal(){

            protected Object initialValue(PageState state) {
                BigDecimal id = (BigDecimal)state.getValue((ParameterModel)DRConstants.FILE_ID_PARAM);
                File file = null;
                try {
                    file = new File(id);
                }
                catch (DataObjectNotFoundException nfe) {
                    // empty catch block
                }
                return file;
            }
        };
        this.add((Component)SEND_FRIEND_FORM_EMAIL_SUBJECT);
        this.m_subject = new TextField(EMAIL_SUBJECT);
        this.m_subject.addValidationListener((ParameterListener)new NotEmptyValidationListener());
        this.add((Component)this.m_subject);
        this.add((Component)SEND_FRIEND_FORM_EMAIL_LIST);
        this.m_emailList = new TextField(EMAIL_LIST);
        this.m_emailList.addValidationListener((ParameterListener)new NotEmptyValidationListener());
        this.add((Component)this.m_emailList);
        this.add((Component)SEND_FRIEND_FORM_DESCRIPTION);
        this.m_message = new TextArea(DESCRIPTION);
        this.m_message.setRows(10);
        this.m_message.setCols(40);
        this.add((Component)this.m_message);
        SimpleContainer sc = new SimpleContainer();
        sc.add((Component)new Submit(SEND_FRIEND_FORM_SUBMIT));
        CancelButton cancel = new CancelButton(CANCEL);
        sc.add((Component)cancel);
        this.add((Component)new Label());
        this.add((Component)sc, 1);
        this.addInitListener(this);
        this.addProcessListener(this);
    }

    private File getFile(PageState s) {
        return (File)this.m_fileData.get(s);
    }

    public void init(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        if (Kernel.getContext().getParty() == null) {
            Util.redirectToLoginPage(state);
            return;
        }
        FormData data = e.getFormData();
        data.put((Object)EMAIL_SUBJECT, (Object)this.getFile(state).getName());
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        HttpServletRequest req = state.getRequest();
        String emailRecpts = (String)this.m_emailList.getValue(state);
        String[] recipient = StringUtils.split((String)emailRecpts, (char)';');
        String subject = (String)this.m_subject.getValue(state);
        String message = (String)this.m_message.getValue(state);
        String from = DRUtils.getUser(state).getPrimaryEmail().toString();
        File file = this.getFile(state);
        String filename = file.getName();
        String mimeType = file.getContentType();
        byte[] attachment = FileSendColleagueForm.getBytes(file);
        for (int i = 0; i < recipient.length; ++i) {
            FileSendColleagueForm.sendDocument(recipient[i], from, subject, message, filename, mimeType, attachment);
        }
        this.m_parent.displayPropertiesAndActions(state);
    }

    private static void sendDocument(String recipient, String sender, String subject, String message, String filename, String mimeType, byte[] attchmnt) {
        try {
            Mail mail = new Mail(recipient, sender, subject);
            mail.setBody(message);
            mail.attach(attchmnt, mimeType, filename);
            mail.send();
        }
        catch (MessagingException exc) {
            exc.printStackTrace();
        }
    }

    private static byte[] getBytes(File file) {
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            InputStream inputStream = file.getInputStream();
            byte[] buf = new byte[8192];
            int sz = 0;
            while ((sz = inputStream.read(buf, 0, 8192)) != -1) {
                outputStream.write(buf, 0, sz);
            }
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
        return outputStream.toByteArray();
    }
}

