/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormValidationException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.docrepo.Folder;
import com.arsdigita.docrepo.InvalidNameException;
import com.arsdigita.docrepo.ResourceExistsException;
import com.arsdigita.docrepo.Util;
import com.arsdigita.docrepo.ui.BrowsePane;
import com.arsdigita.docrepo.ui.CancelButton;
import com.arsdigita.docrepo.ui.DRConstants;
import com.arsdigita.docrepo.ui.DRUtils;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;

class FolderCreateForm
extends Form
implements FormInitListener,
FormValidationListener,
FormProcessListener,
DRConstants {
    private StringParameter m_FolderName;
    private StringParameter m_FolderDesc;
    private Tree m_tree;
    private BrowsePane m_parent;

    public FolderCreateForm(BrowsePane parent, Tree tree) {
        super("CreateFolderForm", (Container)new ColumnPanel(2));
        this.m_parent = parent;
        this.m_tree = tree;
        this.add((Component)FOLDER_NAME_LABEL);
        this.m_FolderName = new StringParameter("folder-name");
        this.m_FolderName.addParameterListener((ParameterListener)new StringLengthValidationListener(200));
        TextField fnameEntry = new TextField((ParameterModel)this.m_FolderName);
        fnameEntry.addValidationListener((ParameterListener)new NotEmptyValidationListener());
        this.add((Component)fnameEntry);
        this.add((Component)FOLDER_DESCRIPTION_LABEL);
        this.m_FolderDesc = new StringParameter("folder-description");
        this.m_FolderDesc.addParameterListener((ParameterListener)new StringLengthValidationListener(4000));
        TextArea textArea = new TextArea((ParameterModel)this.m_FolderDesc);
        textArea.setRows(10);
        textArea.setCols(40);
        this.add((Component)textArea);
        SimpleContainer sc = new SimpleContainer();
        Submit submit = new Submit("submit");
        submit.setButtonLabel(FOLDER_SAVE);
        sc.add((Component)submit);
        CancelButton cancel = new CancelButton(CANCEL);
        sc.add((Component)cancel);
        this.add((Component)new Label());
        this.add((Component)sc, 1);
        this.addInitListener(this);
        this.addProcessListener(this);
        this.addValidationListener(this);
    }

    public void init(FormSectionEvent e) {
        PageState state = e.getPageState();
        if (Kernel.getContext().getParty() == null) {
            Util.redirectToLoginPage(state);
        }
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        String fname = (String)data.get((Object)"folder-name");
        String fdesc = (String)data.get((Object)"folder-description");
        String selKey = (String)this.m_tree.getSelectedKey(state);
        Folder parent = null;
        if (selKey == null) {
            parent = DRUtils.getRootFolder(state);
        } else {
            BigDecimal folderID = new BigDecimal(selKey);
            try {
                parent = new Folder(folderID);
            }
            catch (DataObjectNotFoundException nf) {
                throw new RuntimeException("Could not find folder");
            }
        }
        final Folder folder = new Folder(fname, fdesc, parent);
        try {
            folder.save();
        }
        catch (ResourceExistsException ree) {
            throw new FormValidationException("A folder with this name already exists.");
        }
        new KernelExcursion(){

            protected void excurse() {
                Party currentParty = Kernel.getContext().getParty();
                this.setParty(Kernel.getSystemParty());
                PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)folder, currentParty));
            }
        }.run();
        if (this.m_parent != null) {
            this.m_parent.displayFolderContentPanel(state);
        }
    }

    public void validate(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        FormData data = event.getFormData();
        HttpServletRequest req = state.getRequest();
        String fname = (String)data.get((Object)"folder-name");
        Folder parent = null;
        String selKey = (String)this.m_tree.getSelectedKey(state);
        if (selKey == null) {
            parent = DRUtils.getRootFolder(state);
            if (parent == null) {
                data.addError("folder-name", (String)FOLDER_PARENTNOTFOUND_ERROR.localize(req));
            }
        } else {
            BigDecimal folderID = new BigDecimal(selKey);
            try {
                parent = new Folder(folderID);
            }
            catch (DataObjectNotFoundException nf) {
                data.addError("folder-name", (String)FOLDER_PARENTNOTFOUND_ERROR.localize(req));
            }
        }
        try {
            if (parent != null) {
                parent.retrieveFolder(fname);
                data.addError("folder-name", (String)RESOURCE_EXISTS_ERROR.localize(req));
            }
        }
        catch (DataObjectNotFoundException e) {
        }
        catch (InvalidNameException ex) {
            data.addError("folder-name", ex.getMessage());
        }
    }
}

