/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.docrepo.ResourceImpl;
import com.arsdigita.docrepo.ui.DRConstants;
import com.arsdigita.docrepo.ui.FolderContentsTableForm;
import com.arsdigita.docrepo.ui.FolderTableModelBuilder;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.URL;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;

class FolderTable
extends Table
implements TableActionListener,
DRConstants {
    private static final String FOLDER_LIST_CONTENT_IDS = "folder-listing-ids";
    static String[] s_tableHeaders = new String[]{"", "Name", "Size", "Type", "Modified", ""};
    private CheckboxGroup m_checkboxGroup;
    private ArrayParameter m_sources;
    private FolderContentsTableForm m_parent;
    private Tree m_tree;

    public FolderTable(Tree tree, FolderContentsTableForm parent) {
        super((TableModelBuilder)new FolderTableModelBuilder(tree, parent), (Object[])s_tableHeaders);
        this.m_parent = parent;
        this.m_tree = tree;
        this.m_sources = new ArrayParameter((ParameterModel)new BigDecimalParameter(FOLDER_LIST_CONTENT_IDS));
        this.m_checkboxGroup = new CheckboxGroup(FOLDER_LIST_CONTENT_IDS);
        this.m_parent.add((Component)this.m_checkboxGroup);
        this.setWidth("100%");
        this.setCellRenderers();
        this.addTableActionListener(this);
    }

    public void register(Page p) {
        super.register(p);
        p.addComponentStateParam((Component)this, (ParameterModel)this.m_sources);
    }

    public CheckboxGroup getCheckboxGroup() {
        return this.m_checkboxGroup;
    }

    public void cellSelected(TableActionEvent e) {
        PageState state = e.getPageState();
        int col = e.getColumn();
        String rowkey = (String)e.getRowKey();
        int j = rowkey.indexOf(".");
        String id = rowkey.substring(0, j);
        char isFolder = rowkey.charAt(j + 1);
        if (isFolder != 't') {
            ParameterMap params = new ParameterMap();
            params.setParameter(FILE_ID_PARAM.getName(), id);
            URL url = URL.here((HttpServletRequest)state.getRequest(), (String)"/file", (ParameterMap)params);
            throw new RedirectSignal(url, true);
        }
        String oldKey = (String)this.m_tree.getSelectedKey(state);
        this.m_tree.setSelectedKey(state, (Object)id);
        this.m_tree.expand(oldKey, state);
        state.setValue((ParameterModel)FILE_ID_PARAM, null);
    }

    public void headSelected(TableActionEvent e) {
        throw new UnsupportedOperationException();
    }

    private void setCellRenderers() {
        this.getColumn(0).setCellRenderer((TableCellRenderer)new CheckBoxRenderer());
        this.getColumn(1).setCellRenderer((TableCellRenderer)new LinkRenderer());
        this.getColumn(5).setCellRenderer((TableCellRenderer)new DownloadLinkRenderer());
    }

    private final class CheckBoxRenderer
    implements TableCellRenderer {
        private CheckBoxRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            String encodedKey = (String)key;
            int j = encodedKey.indexOf(".");
            BigDecimal id = new BigDecimal(encodedKey.substring(0, j));
            Option result = new Option(FolderTable.this.m_sources.marshalElement((Object)id.abs()), "");
            result.setGroup((OptionGroup)FolderTable.this.m_checkboxGroup);
            return result;
        }
    }

    private final class LinkRenderer
    implements TableCellRenderer {
        private LinkRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            ResourceImpl resource = (ResourceImpl)value;
            String classAttr = resource.isFolder() ? "isFolder" : "isFile";
            Label iconLabel = new Label();
            if (classAttr != null) {
                iconLabel.setClassAttr(classAttr);
            }
            SimpleContainer link = new SimpleContainer();
            link.add((Component)iconLabel);
            link.add((Component)new ControlLink(resource.getName()));
            return link;
        }
    }

    private final class DownloadLinkRenderer
    implements TableCellRenderer {
        private DownloadLinkRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            if (value == null) {
                return new Label();
            }
            Link link = new Link("Download", "download/" + value + "?" + DRConstants.FILE_ID_PARAM.getName() + "=" + key);
            link.setClassAttr("downloadLink");
            return link;
        }
    }
}

