/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.docrepo.File;
import com.arsdigita.docrepo.Folder;
import com.arsdigita.docrepo.ui.DRConstants;
import com.arsdigita.docrepo.ui.DRUtils;
import com.arsdigita.docrepo.ui.FolderContentsTableForm;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;

class FolderTableModelBuilder
extends LockableImpl
implements TableModelBuilder {
    private Tree m_tree;
    private FolderContentsTableForm m_parent;

    FolderTableModelBuilder(Tree tree, FolderContentsTableForm parent) {
        this.m_tree = tree;
        this.m_parent = parent;
    }

    public TableModel makeModel(Table t, PageState state) {
        BigDecimal fid = DRUtils.getSelectedFolderID(state, this.m_tree);
        return new FolderTableModel(fid, state);
    }

    class FolderTableModel
    implements TableModel,
    DRConstants {
        private BigDecimal m_parentFolderID;
        private PageState m_state;
        private boolean m_more;
        private DataQuery m_query;

        FolderTableModel(BigDecimal folderID, PageState state) {
            this.m_parentFolderID = folderID;
            this.m_state = state;
            Session session = SessionManager.getSession();
            this.m_query = session.retrieveQuery("com.arsdigita.docrepo.getChildren");
            this.m_query.setParameter("folderID", (Object)this.m_parentFolderID);
            if (this.m_query.size() == 0L) {
                FolderTableModelBuilder.this.m_parent.hideActionLinks(state);
            } else {
                FolderTableModelBuilder.this.m_parent.hideEmptyLabel(state);
            }
        }

        public int getColumnCount() {
            return 6;
        }

        public Object getElementAt(int columnIndex) {
            boolean isFolder = (Boolean)this.m_query.get("isFolder");
            switch (columnIndex) {
                case 0: {
                    return Boolean.FALSE;
                }
                case 1: {
                    String name = (String)this.m_query.get("name");
                    String type = (String)this.m_query.get("mimeType");
                    if (isFolder) {
                        Folder folder = new Folder((BigDecimal)this.m_query.get("id"));
                        return folder;
                    }
                    File file = new File((BigDecimal)this.m_query.get("id"));
                    return file;
                }
                case 2: {
                    if (isFolder) {
                        return null;
                    }
                    File file = new File((BigDecimal)this.m_query.get("id"));
                    long size = file.getSize().longValue();
                    return DRUtils.FileSize.formatFileSize(size, this.m_state);
                }
                case 3: {
                    if (isFolder) {
                        return "Folder";
                    }
                    return this.m_query.get("mimeTypeDescription");
                }
                case 4: {
                    return this.m_query.get("lastModified");
                }
                case 5: {
                    if (isFolder) {
                        return null;
                    }
                    return this.m_query.get("name");
                }
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            if (columnIndex == 5) {
                return this.m_query.get("id");
            }
            return this.m_query.get("id") + "." + this.m_query.get("isFolder");
        }

        public boolean nextRow() {
            return this.m_query.next();
        }
    }
}

