/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.docrepo.File;
import com.arsdigita.docrepo.Repository;
import com.arsdigita.docrepo.ResourceImplCollection;
import com.arsdigita.docrepo.ui.DRConstants;
import com.arsdigita.docrepo.ui.DRUtils;
import com.arsdigita.docrepo.ui.RecentUpdatedDocsPortlet;
import com.arsdigita.kernel.User;
import com.arsdigita.web.Application;
import com.arsdigita.xml.Element;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;

class RecentUpdatedDocsPortletRenderer
extends AbstractPortletRenderer
implements DRConstants {
    private RecentUpdatedDocsPortlet m_portlet;

    public RecentUpdatedDocsPortletRenderer(RecentUpdatedDocsPortlet docsPortlet) {
        this.m_portlet = docsPortlet;
    }

    protected void generateBodyXML(PageState pageState, Element parentElement) {
        Application application = this.m_portlet.getParentApplication();
        String fileURL = application.getPath();
        Repository rep = (Repository)application;
        HttpServletRequest req = pageState.getRequest();
        ResourceImplCollection files = Repository.getRecentlyModifiedDocuments(rep);
        Object[] tableHeaders = new String[]{"File", "Type", "Size", "Author", "Date", ""};
        int size = 0;
        int maxCount = 10;
        int maxDocs = (int)files.size();
        size = maxCount < maxDocs ? maxCount : maxDocs;
        if (size == 0) {
            GridPanel panel = new GridPanel(1);
            this.addResourceLink(panel);
            panel.add((Component)new Label(REPOSITORY_RECENTDOCS_EMPTY.localize(req).toString()));
            panel.generateXML(pageState, parentElement);
            return;
        }
        GridPanel panel = new GridPanel(1);
        this.addResourceLink(panel);
        Object[][] tableData = new Object[size][6];
        for (int i = 0; i < size && files.next(); ++i) {
            File resource = (File)files.getDomainObject();
            tableData[i][0] = new Link(resource.getName(), fileURL + "/file?" + FILE_ID_PARAM.getName() + "=" + resource.getResourceID());
            tableData[i][1] = new Label(resource.getPrettyContentType());
            long fileSize = resource.getSize().longValue();
            tableData[i][2] = new Label(DRUtils.FileSize.formatFileSize(fileSize, pageState));
            User user = resource.getLastModifiedUser();
            String author = null;
            if (null != user) {
                author = user.getPersonName().toString();
            }
            if (null == author) {
                author = "Unknown";
            }
            tableData[i][3] = new Label(author);
            Date date = resource.getLastModifiedDate();
            SimpleDateFormat dft = new SimpleDateFormat();
            String textdate = dft.format(date);
            tableData[i][4] = new Label(textdate);
            Link link = new Link("Download", fileURL + "/download/" + resource.getName() + "?" + FILE_ID_PARAM.getName() + "=" + resource.getResourceID());
            link.setClassAttr("downloadLink");
            tableData[i][5] = link;
        }
        files.close();
        Table table = new Table(tableData, tableHeaders);
        panel.add((Component)table, 64);
        panel.generateXML(pageState, parentElement);
    }

    private void addResourceLink(GridPanel panel) {
        Link addResourceLink = new Link((Component)new Label(ROOT_ADD_RESOURCE_LINK), this.m_portlet.getParentApplication().getPath() + "?" + ROOT_ADD_DOC_PARAM.getName() + "=" + "t");
        addResourceLink.setClassAttr("actionLink");
        panel.add((Component)addResourceLink, 100);
    }
}

