/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.importer;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.london.importer.RemoteOidMapping;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;

public class DomainObjectMapper {
    private static final Logger s_log = Logger.getLogger(DomainObjectMapper.class);
    private String m_systemID;

    public boolean objectExists(OID src) {
        boolean exists = RemoteOidMapping.exists(this.getSystemID(), src);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Checking existance of " + src + " from " + this.getSystemID() + ": " + exists));
        }
        return exists;
    }

    public DomainObject getObject(OID src) {
        String oid = RemoteOidMapping.retrieveDstOid(this.getSystemID(), src);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Object " + src + " from " + this.getSystemID() + " is " + oid));
        }
        if (oid == null) {
            return null;
        }
        return DomainObjectFactory.newInstance((OID)OID.valueOf((String)oid));
    }

    public void setObject(OID src, DomainObject dst) {
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Mapping " + src + " from " + this.getSystemID() + " to " + dst));
        }
        RemoteOidMapping mapping = new RemoteOidMapping(this.getSystemID(), src.toString(), dst.getOID().toString());
        mapping.save();
    }

    public String getSystemID() {
        Assert.exists((Object)this.m_systemID, String.class);
        return this.m_systemID;
    }

    void setSystemID(String systemID) {
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Setting system id to " + systemID));
        }
        this.m_systemID = systemID;
    }
}

