/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.importer;

import com.arsdigita.london.importer.AbstractTagParser;
import com.arsdigita.london.importer.DomainObjectMapper;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;

public class ImportParser
extends AbstractTagParser {
    private static final Logger s_log = Logger.getLogger(ImportParser.class);
    public static final String TAG_NAME = "import";
    public static final String SOURCE_ATTR = "source";
    private DomainObjectMapper m_mapper;

    public ImportParser(DomainObjectMapper mapper) {
        this(TAG_NAME, "http://xmlns.redhat.com/waf/london/importer/1.0", mapper);
    }

    public ImportParser(String tagName, String tagURI, DomainObjectMapper mapper) {
        super(tagName, tagURI);
        this.m_mapper = mapper;
    }

    @Override
    protected void startTag(String name, String uri, Attributes atts) {
        if (!TAG_NAME.equals(name)) {
            s_log.warn((Object)("Unexpected tag " + name + " " + uri));
            return;
        }
        String sourceID = atts.getValue(SOURCE_ATTR);
        s_log.debug((Object)("Setting source system ID to: " + sourceID));
        this.m_mapper.setSystemID(sourceID);
    }

    @Override
    protected void endTag(String name, String uri) {
        if (!TAG_NAME.equals(name)) {
            s_log.warn((Object)("Unexpected tag " + name + " " + uri));
            return;
        }
    }
}

