/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.importer;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import java.util.Iterator;

public class RemoteOidMapping
extends DomainObject {
    public static final String SYSTEM_ID = "systemId";
    public static final String SRC_OID = "srcOid";
    public static final String DST_OID = "dstOid";
    public static final String BASE_DATA_OBJECT_TYPE = RemoteOidMapping.class.getName();

    public RemoteOidMapping() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public RemoteOidMapping(DataObject dobj) {
        super(dobj);
    }

    public RemoteOidMapping(OID mappingOID) throws DataObjectNotFoundException {
        super(mappingOID);
    }

    public RemoteOidMapping(String systemId, String srcOid, String dstOid) {
        this();
        this.setSystemId(systemId);
        this.setSrcOid(srcOid);
        this.setDstOid(dstOid);
    }

    public static RemoteOidMapping retrieve(String systemId, String srcOid) {
        OID oid = new OID(BASE_DATA_OBJECT_TYPE);
        oid.set(SYSTEM_ID, (Object)systemId);
        oid.set(SRC_OID, (Object)srcOid);
        RemoteOidMapping mapping = null;
        try {
            mapping = new RemoteOidMapping(oid);
        }
        catch (DataObjectNotFoundException nfe) {
            // empty catch block
        }
        return mapping;
    }

    public static String retrieveDstOid(String systemId, String srcOid) {
        RemoteOidMapping mapping = RemoteOidMapping.retrieve(systemId, srcOid);
        if (mapping == null) {
            return null;
        }
        return mapping.getDstOid();
    }

    public static String retrieveDstOid(String systemId, OID srcOid) {
        return RemoteOidMapping.retrieveDstOid(systemId, srcOid.toString());
    }

    public static boolean exists(String systemId, String srcOid) {
        return RemoteOidMapping.retrieve(systemId, srcOid) != null;
    }

    public static boolean exists(String systemId, OID srcOid) {
        return RemoteOidMapping.retrieve(systemId, srcOid.toString()) != null;
    }

    public static String retrieveSrcOid(String systemId, String dstOid) {
        RemoteOidMapping map = RemoteOidMapping.retrieveByDstOid(systemId, dstOid);
        if (map == null) {
            return null;
        }
        return map.getSrcOid();
    }

    public static RemoteOidMapping retrieveByDstOid(String systemId, OID dstOid) {
        return RemoteOidMapping.retrieveByDstOid(systemId, dstOid.toString());
    }

    public static RemoteOidMapping retrieveByDstOid(String systemId, String dstOid) {
        DataCollection dc = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        dc.addEqualsFilter(SYSTEM_ID, (Object)systemId);
        dc.addEqualsFilter(DST_OID, (Object)dstOid);
        if (dc.next()) {
            RemoteOidMapping map = new RemoteOidMapping(dc.getDataObject());
            dc.close();
            return map;
        }
        return null;
    }

    public String getSystemId() {
        return (String)this.get(SYSTEM_ID);
    }

    public String getSrcOid() {
        return (String)this.get(SRC_OID);
    }

    public String getDstOid() {
        return (String)this.get(DST_OID);
    }

    public void setSystemId(String systemId) {
        this.set(SYSTEM_ID, systemId);
    }

    public void setSrcOid(String srcOid) {
        this.set(SRC_OID, srcOid);
    }

    public void setDstOid(String dstOid) {
        this.set(DST_OID, dstOid);
    }

    protected void beforeDelete() {
        super.beforeDelete();
        DataObject dobj = SessionManager.getSession().retrieve(OID.valueOf((String)this.getDstOid()));
        if (dobj == null) {
            return;
        }
        ObjectType type = dobj.getObjectType();
        Iterator i = type.getProperties();
        while (i.hasNext()) {
            Property prop = (Property)i.next();
            String propName = prop.getName();
            Object propValue = dobj.get(propName);
            if (propValue == null) continue;
            if (prop.isCollection()) {
                DataAssociationCursor daCursor = ((DataAssociation)propValue).getDataAssociationCursor();
                while (daCursor.next()) {
                    OID oid = daCursor.getDataObject().getOID();
                    RemoteOidMapping associatedMapping = RemoteOidMapping.retrieveByDstOid(this.getSystemId(), oid);
                    if (associatedMapping == null) continue;
                    associatedMapping.delete();
                }
                continue;
            }
            if (!prop.isRole()) continue;
            OID oid = ((DataObject)propValue).getOID();
            RemoteOidMapping associatedMapping = RemoteOidMapping.retrieveByDstOid(this.getSystemId(), oid);
            if (associatedMapping == null) continue;
            associatedMapping.delete();
        }
    }
}

