/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.importer.cms;

import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.PersonName;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserAuthentication;
import com.arsdigita.london.importer.AbstractTagParser;
import com.arsdigita.london.importer.TagParser;
import com.arsdigita.london.importer.cms.ItemParser;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.workflow.simple.TaskCollection;
import com.arsdigita.workflow.simple.UserTask;
import com.arsdigita.workflow.simple.Workflow;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import java.util.Iterator;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;

public class FolderParser
extends AbstractTagParser {
    private static Logger s_log = Logger.getLogger(FolderParser.class);
    public static final String FOLDER_NAME = "name";
    public static final String FOLDER_LABEL = "label";
    private Stack m_folders = new Stack();
    private ContentSection m_section;
    private WorkflowTemplate m_workflowTemplate;

    public FolderParser(ContentSection section) {
        this("folder", "http://www.arsdigita.com/cms/1.0", section);
    }

    public FolderParser(String tagName, String tagURI, ContentSection section) {
        super(tagName, tagURI);
        this.m_section = section;
        TaskCollection tc = section.getWorkflowTemplates();
        if (tc.next()) {
            this.m_workflowTemplate = (WorkflowTemplate)tc.getTask();
            tc.close();
        }
    }

    @Override
    protected void startTag(String tagName, String uri, Attributes atts) {
        if (!"folder".equals(tagName)) {
            s_log.warn((Object)("Unexpected tag " + tagName + " " + uri));
            return;
        }
        String name = atts.getValue(FOLDER_NAME);
        String label = atts.getValue(FOLDER_LABEL);
        if (label == null) {
            label = name;
        }
        Folder folder = this.getFolderByName(this.getFolder(), name, label);
        this.m_folders.push(folder);
    }

    @Override
    protected void endTag(String name, String uri) {
        if (!"folder".equals(name)) {
            s_log.warn((Object)("Unexpected tag " + name + " " + uri));
            return;
        }
    }

    @Override
    public void endBlock() {
        this.m_folders.pop();
    }

    @Override
    public void endSubBlock(TagParser parser) {
        if (parser instanceof ItemParser) {
            ItemParser itemParser = (ItemParser)parser;
            ContentItem item = (ContentItem)itemParser.getDomainObject();
            s_log.info((Object)("Item is " + item));
            if (item != null) {
                ContentBundle bundle = new ContentBundle(item);
                Folder folder = this.getFolder();
                bundle.setParent((ACSObject)folder);
                if (itemParser.isIndexItem()) {
                    folder.setIndexItem(bundle);
                }
                if (itemParser.relabelFolder() && item instanceof ContentPage) {
                    folder.setLabel(((ContentPage)item).getTitle());
                }
                s_log.info((Object)("Set bundle " + bundle));
                if (itemParser.getAuthor() != null && this.m_workflowTemplate != null) {
                    String email = itemParser.getAuthor().trim();
                    User author = this.retrieveUserByEmail(email);
                    Workflow workflow = this.m_workflowTemplate.instantiateNewWorkflow();
                    workflow.setObject((ACSObject)item);
                    workflow.start(author);
                    s_log.info((Object)("Starting workflow on item by user: " + author.getPrimaryEmail().getEmailAddress()));
                    Iterator tasks = workflow.getTasks();
                    while (tasks.hasNext()) {
                        UserTask task = (UserTask)tasks.next();
                        if (!task.isActive()) continue;
                        task.lock(author);
                    }
                }
            }
        }
    }

    protected Folder getFolder() {
        if (this.m_folders.empty()) {
            return this.m_section.getRootFolder();
        }
        return (Folder)this.m_folders.peek();
    }

    private Folder getFolderByName(Folder parent, String name, String label) {
        if ("/".equals(name) && parent.getParent() == null) {
            return parent;
        }
        Folder.ItemCollection items = parent.getItems();
        items.addFolderFilter(true);
        items.addVersionFilter(false);
        items.addNameFilter(name);
        if (items.next()) {
            Folder f = (Folder)items.getContentItem();
            items.close();
            return f;
        }
        Folder f = new Folder();
        f.setName(name);
        f.setLabel(label);
        f.setParent((ACSObject)parent);
        return f;
    }

    private User retrieveUserByEmail(String email) {
        email = email.toLowerCase().trim();
        DataCollection dc = SessionManager.getSession().retrieve("com.arsdigita.kernel.User");
        dc.addEqualsFilter("lower(primaryEmail)", (Object)email);
        if (dc.next()) {
            User user = User.retrieve((DataObject)dc.getDataObject());
            dc.close();
            return user;
        }
        User newUser = new User();
        PersonName name = newUser.getPersonName();
        name.setGivenName(email);
        name.setFamilyName("CCM user");
        newUser.setPrimaryEmail(new EmailAddress(email));
        UserAuthentication ua = UserAuthentication.createForUser((User)newUser);
        ua.setPasswordQuestion("Please type your email again (all in lowercase, with no whitespace)");
        ua.setPasswordAnswer(email);
        ua.setPassword("" + newUser.hashCode() + ":" + name.hashCode());
        s_log.info((Object)("New user created, email: " + email + ", ID: " + newUser.getID()));
        return newUser;
    }
}

