/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.importer.cms;

import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.london.importer.DomainObjectMapper;
import com.arsdigita.london.importer.ImportParser;
import com.arsdigita.london.importer.ParserDispatcher;
import com.arsdigita.london.importer.cms.FolderItemParser;
import com.arsdigita.london.importer.cms.ItemParser;
import com.arsdigita.london.util.Transaction;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.cmd.Program;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.cli.CommandLine;
import org.apache.log4j.Logger;

public class ItemImportTool
extends Program {
    private static final Logger s_log = Logger.getLogger(ItemImportTool.class);

    public ItemImportTool() {
        super("Item Import Tool", "1.0.0", "INDEX-FILE ITEM-DIR ASSET-DIR CONTENT-SECTION");
    }

    public ItemImportTool(boolean startup) {
        super("Item Import Tool", "1.0.0", "INDEX-FILE ITEM-DIR ASSET-DIR CONTENT-SECTION", startup);
    }

    protected void doRun(CommandLine cmdLine) {
        try {
            String[] args = cmdLine.getArgs();
            if (args.length != 4) {
                this.help(System.err);
                System.exit(1);
            }
            final String masterFile = args[0];
            final File itemDir = new File(args[1]);
            final File assetDir = new File(args[2]);
            final ContentSection section = this.getContentSection(args[3]);
            final DomainObjectMapper mapper = new DomainObjectMapper();
            final ArrayList items = new ArrayList();
            Transaction session = new Transaction(){

                public void doRun() {
                    ParserDispatcher parser = new ParserDispatcher();
                    parser.addParser(new ImportParser(mapper));
                    parser.addParser(new FolderItemParser(section, items));
                    parser.addParser(new ItemParser(assetDir, mapper));
                    parser.execute(masterFile);
                }
            };
            session.run();
            Iterator lazyItems = items.iterator();
            final HashMap bundles = new HashMap();
            while (lazyItems.hasNext()) {
                Object[] entry = (Object[])lazyItems.next();
                final Folder folder = (Folder)entry[0];
                final String file = (String)entry[1];
                Transaction itemTransaction = new Transaction(){

                    public void doRun() {
                        String bundleName;
                        ItemParser itemParser = new ItemParser(assetDir, mapper);
                        File itemFile = new File(itemDir, file);
                        if (s_log.isInfoEnabled()) {
                            s_log.info((Object)("Loading " + file + " into " + folder.getPath()));
                        }
                        ParserDispatcher parser = new ParserDispatcher();
                        parser.addParser(itemParser);
                        try {
                            parser.execute(itemFile.getCanonicalPath());
                        }
                        catch (IOException ex) {
                            throw new UncheckedWrapperException("cannot process file" + file, (Throwable)ex);
                        }
                        ContentItem item = (ContentItem)itemParser.getDomainObject();
                        if (item == null) {
                            s_log.warn((Object)"item is null. Igoring...");
                            return;
                        }
                        s_log.debug((Object)String.format("Got item from ItemParser:", new Object[0]));
                        s_log.debug((Object)String.format("OID  : %s", item.getOID()));
                        s_log.debug((Object)String.format("Name : %s", item.getName()));
                        s_log.debug((Object)String.format("Item file name : %s", itemFile.getName()));
                        s_log.debug((Object)String.format("Title: %s", item.get("title")));
                        if (item instanceof ContentPage) {
                            s_log.debug((Object)"Item is a content page...");
                        }
                        String itemName = itemFile.getName().substring(0, itemFile.getName().length() - 4);
                        s_log.debug((Object)String.format("Using item name '%s'...", item.getName()));
                        if (itemName.lastIndexOf(45) == -1) {
                            s_log.debug((Object)"No '-' in name, using name as bundle name");
                            bundleName = itemName;
                        } else {
                            s_log.debug((Object)"Found a '-' in the, name, using part before '-' as bundle name.");
                            if (itemName.substring(itemName.lastIndexOf(45) + 1).equals("de") || itemName.substring(itemName.lastIndexOf(45) + 1).equals("en")) {
                                bundleName = itemName.substring(0, itemName.lastIndexOf(45));
                                s_log.debug((Object)String.format("Created bundle name: '%s'", bundleName));
                            } else {
                                s_log.debug((Object)"Part behind the last '-' is not 'de' or 'en', using item name as bundle name");
                                bundleName = itemName;
                            }
                        }
                        if (s_log.isDebugEnabled()) {
                            s_log.debug((Object)("Item is " + item));
                        }
                        if (item != null) {
                            ContentBundle bundle;
                            s_log.debug((Object)String.format("Bundle name: %s", bundleName));
                            if (itemName.lastIndexOf(45) == -1) {
                                s_log.debug((Object)"Item is not localized...");
                                bundle = new ContentBundle(item);
                                bundle.setParent((ACSObject)folder);
                                bundle.setName(bundleName);
                                bundles.put(bundleName, bundle);
                            } else {
                                s_log.debug((Object)"Item is localized...");
                                bundle = (ContentBundle)bundles.get(bundleName);
                                if (bundle == null) {
                                    s_log.debug((Object)"No content bundle found for item, creating new.");
                                    bundle = new ContentBundle(item);
                                    bundle.setParent((ACSObject)folder);
                                    bundle.setName(bundleName);
                                    bundles.put(bundleName, bundle);
                                } else {
                                    s_log.debug((Object)"Found content bundle for item, adding item as instance.");
                                    bundle.addInstance(item);
                                }
                            }
                            System.out.println("Set bundle " + bundle);
                            if (s_log.isDebugEnabled()) {
                                s_log.debug((Object)("Set bundle " + bundle));
                            }
                        }
                    }
                };
                itemTransaction.run();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static final void main(String[] args) {
        try {
            new ItemImportTool().run(args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private ContentSection getContentSection(String rawPath) {
        ContentSection section;
        StringBuilder path = new StringBuilder();
        if (!rawPath.startsWith("/")) {
            path.append("/");
        }
        path.append(rawPath);
        if (!rawPath.endsWith("/")) {
            path.append("/");
        }
        if ((section = (ContentSection)ContentSection.retrieveApplicationForPath((String)path.toString())) == null) {
            throw new DataObjectNotFoundException("Content section not found with path " + path);
        }
        return section;
    }
}

