/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.contenttypes;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentType;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.london.contenttypes.ContactAddress;
import com.arsdigita.london.contenttypes.ContactPhone;
import com.arsdigita.london.contenttypes.ContactPhonesCollection;
import com.arsdigita.london.contenttypes.ContactType;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class Contact
extends ContentPage {
    public static final String GIVEN_NAME = "givenName";
    public static final String FAMILY_NAME = "familyName";
    public static final String SUFFIX = "suffix";
    public static final String EMAILS = "emails";
    public static final String DESCRIPTION = "description";
    public static final String ORG_NAME = "orgName";
    public static final String DEPT_NAME = "deptName";
    public static final String ROLE = "role";
    public static final String CONTACT_TYPE = "contactType";
    public static final String CONTACT_ADDRESS = "contactAddress";
    public static final String PHONES = "phones";
    public static final String ITEMS = "associatedContentItemsForContact";
    private static final Logger s_log = Logger.getLogger(Contact.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.london.contenttypes.Contact";

    public Contact() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public void addContentItem(ContentItem item) {
        s_log.debug((Object)("item is " + item));
        item.addToAssociation(this.getItemsForContact());
    }

    public void removeContentItem(ContentItem item) {
        s_log.debug((Object)("item is " + item));
        DataOperation operation = SessionManager.getSession().retrieveDataOperation("com.arsdigita.london.contenttypes.removeContactFromContentItemAssociation");
        operation.setParameter("itemID", (Object)new Integer(item.getID().intValue()));
        operation.execute();
    }

    private void removeItemMappings() {
        DataOperation operation = SessionManager.getSession().retrieveDataOperation("com.arsdigita.london.contenttypes.removeContactFromAllAssociations");
        operation.setParameter("contactID", (Object)new Integer(this.getID().intValue()));
        operation.execute();
    }

    public DataAssociation getItemsForContact() {
        return (DataAssociation)this.get(ITEMS);
    }

    public static Contact getContactForItem(ContentItem item) {
        s_log.debug((Object)("getting contact for item " + item));
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.london.contenttypes.getContactForItem");
        query.setParameter("itemID", (Object)item.getID());
        Contact contact = null;
        while (query.next()) {
            BigDecimal contactID = (BigDecimal)query.get("contactID");
            contact = new Contact(contactID);
        }
        s_log.debug((Object)("returning contact " + contact));
        return contact;
    }

    public Contact(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public Contact(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Contact(DataObject obj) {
        super(obj);
    }

    public Contact(String type) {
        super(type);
    }

    public void beforeSave() {
        super.beforeSave();
        Assert.exists((Object)this.getContentType(), ContentType.class);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public String getGivenName() {
        return (String)this.get(GIVEN_NAME);
    }

    public void setGivenName(String gn) {
        this.set(GIVEN_NAME, gn);
    }

    public String getFamilyName() {
        return (String)this.get(FAMILY_NAME);
    }

    public void setFamilyName(String fn) {
        this.set(FAMILY_NAME, fn);
    }

    public String getSuffix() {
        return (String)this.get(SUFFIX);
    }

    public void setSuffix(String suf) {
        this.set(SUFFIX, suf);
    }

    public String getEmails() {
        return (String)this.get(EMAILS);
    }

    public void setEmails(String ems) {
        this.set(EMAILS, ems);
    }

    public String getContactTypeName() {
        String ctTypeName = "";
        if (this.getContactType() != null) {
            ctTypeName = this.getContactType().getTypeName();
        }
        return ctTypeName;
    }

    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public void setDescription(String desc) {
        this.set(DESCRIPTION, desc);
    }

    public String getOrganisationName() {
        return (String)this.get(ORG_NAME);
    }

    public void setOrganisationName(String orgName) {
        this.set(ORG_NAME, orgName);
    }

    public String getDeptName() {
        return (String)this.get(DEPT_NAME);
    }

    public void setDeptName(String deptName) {
        this.set(DEPT_NAME, deptName);
    }

    public String getRole() {
        return (String)this.get(ROLE);
    }

    public void setRole(String role) {
        this.set(ROLE, role);
    }

    public ContactType getContactType() {
        DataObject obj = this.retrieveDataobject(CONTACT_TYPE);
        if (obj != null) {
            return new ContactType(obj);
        }
        return null;
    }

    public void setContactType(ContactType ct) {
        this.setAssociation(CONTACT_TYPE, (DomainObject)ct);
    }

    public void setContactAddress(ContactAddress caddr) {
        this.setAssociation(CONTACT_ADDRESS, (DomainObject)caddr);
    }

    public ContactAddress getContactAddress() {
        DataObject obj = this.retrieveDataobject(CONTACT_ADDRESS);
        if (obj != null) {
            return new ContactAddress(obj);
        }
        return null;
    }

    public void addPhone(ContactPhone ph) {
        this.add(PHONES, (DomainObject)ph);
        this.save();
    }

    public void removePhone(ContactPhone ph) {
        ph.delete();
        this.save();
    }

    public ContactPhonesCollection getPhones() {
        DataAssociationCursor dac = ((DataAssociation)this.get(PHONES)).cursor();
        return new ContactPhonesCollection((DataCollection)dac);
    }

    private DataObject retrieveDataobject(String attr) {
        return (DataObject)this.get(attr);
    }
}

