/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.BasicItemForm;
import com.arsdigita.london.contenttypes.Contact;
import com.arsdigita.london.contenttypes.ContactAddress;
import com.arsdigita.london.contenttypes.util.ContactGlobalizationUtil;
import org.apache.log4j.Logger;

public class ContactAddressPropertyForm
extends BasicItemForm {
    private static final Logger s_log = Logger.getLogger(ContactAddressPropertyForm.class);
    private static final String ID = "Contact_address_edit";

    public ContactAddressPropertyForm(ItemSelectionModel itemModel) {
        super(ID, itemModel);
    }

    protected void addWidgets() {
        this.addSAON();
        this.addPAON();
        this.addStreetDesc();
        this.addStreetRefNo();
        this.addLocality();
        this.addTown();
        this.addArea();
        this.addPostTown();
        this.addPostCode();
        this.addPropRefNo();
    }

    protected void addSAON() {
        this.add((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.address.saon")));
        StringParameter saonParam = new StringParameter("saon");
        TextField saon = new TextField((ParameterModel)saonParam);
        this.add((Component)saon);
    }

    protected void addPAON() {
        this.add((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.address.paon")));
        StringParameter paonParam = new StringParameter("paon");
        TextField paon = new TextField((ParameterModel)paonParam);
        paon.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)paon);
    }

    protected void addStreetDesc() {
        this.add((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.address.streetdesc")));
        StringParameter streetDescParam = new StringParameter("streetDesc");
        TextField streetDesc = new TextField((ParameterModel)streetDescParam);
        streetDesc.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)streetDesc);
    }

    protected void addStreetRefNo() {
        this.add((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.address.streetrefno")));
        StringParameter streetRefNoParam = new StringParameter("streetRefNo");
        TextField streetRefNo = new TextField((ParameterModel)streetRefNoParam);
        this.add((Component)streetRefNo);
    }

    protected void addLocality() {
        this.add((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.address.locality")));
        StringParameter localityParam = new StringParameter("locality");
        TextField locality = new TextField((ParameterModel)localityParam);
        this.add((Component)locality);
    }

    protected void addTown() {
        this.add((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.address.town")));
        StringParameter townParam = new StringParameter("town");
        TextField town = new TextField((ParameterModel)townParam);
        this.add((Component)town);
    }

    protected void addArea() {
        this.add((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.address.administrative_area")));
        StringParameter adAreaParam = new StringParameter("administrativeArea");
        TextField adArea = new TextField((ParameterModel)adAreaParam);
        this.add((Component)adArea);
    }

    protected void addPostTown() {
        this.add((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.address.posttown")));
        StringParameter postTownParam = new StringParameter("postTown");
        TextField postTown = new TextField((ParameterModel)postTownParam);
        this.add((Component)postTown);
    }

    protected void addPostCode() {
        this.add((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.address.postcode")));
        StringParameter postCodeParam = new StringParameter("postCode");
        TextField postCode = new TextField((ParameterModel)postCodeParam);
        this.add((Component)postCode);
    }

    protected void addPropRefNo() {
        this.add((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.address.proprefno")));
        StringParameter propRefNoParam = new StringParameter("referenceNo");
        TextField propRefNo = new TextField((ParameterModel)propRefNoParam);
        this.add((Component)propRefNo);
    }

    public void init(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        Contact contact = (Contact)this.getItemSelectionModel().getSelectedObject(fse.getPageState());
        ContactAddress ctAddress = contact.getContactAddress();
        if (ctAddress != null) {
            data.put((Object)"paon", (Object)ctAddress.getPaon());
            data.put((Object)"saon", (Object)ctAddress.getSaon());
            data.put((Object)"streetDesc", (Object)ctAddress.getStreetDesc());
            data.put((Object)"streetRefNo", (Object)ctAddress.getStreetRefNo());
            data.put((Object)"locality", (Object)ctAddress.getLocality());
            data.put((Object)"town", (Object)ctAddress.getTown());
            data.put((Object)"administrativeArea", (Object)ctAddress.getAdministrativeArea());
            data.put((Object)"postTown", (Object)ctAddress.getPostTown());
            data.put((Object)"postCode", (Object)ctAddress.getPostCode());
            data.put((Object)"referenceNo", (Object)ctAddress.getReferenceNo());
        }
    }

    public void process(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        Contact contact = (Contact)this.getItemSelectionModel().getSelectedObject(fse.getPageState());
        s_log.debug((Object)("Process Event Object :" + (Object)((Object)contact)));
        if (contact != null && this.getSaveCancelSection().getSaveButton().isSelected(fse.getPageState())) {
            ContactAddress ctAddress = contact.getContactAddress();
            if (ctAddress == null) {
                ctAddress = new ContactAddress();
                ctAddress.setName("address-for-contact-" + contact.getID());
            }
            ctAddress.setPaon((String)data.get((Object)"paon"));
            ctAddress.setSaon((String)data.get((Object)"saon"));
            ctAddress.setStreetDesc((String)data.get((Object)"streetDesc"));
            ctAddress.setStreetRefNo((String)data.get((Object)"streetRefNo"));
            ctAddress.setLocality((String)data.get((Object)"locality"));
            ctAddress.setTown((String)data.get((Object)"town"));
            ctAddress.setAdministrativeArea((String)data.get((Object)"administrativeArea"));
            ctAddress.setPostTown((String)data.get((Object)"postTown"));
            ctAddress.setPostCode((String)data.get((Object)"postCode"));
            ctAddress.setReferenceNo((String)data.get((Object)"referenceNo"));
            ctAddress.save();
            if (contact.getContactAddress() == null) {
                contact.setContactAddress(ctAddress);
                contact.save();
            }
        }
    }
}

