/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.CreationSelector;
import com.arsdigita.cms.ui.authoring.PageCreate;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.london.contenttypes.Contact;
import com.arsdigita.london.contenttypes.util.ContactGlobalizationUtil;

public class ContactCreate
extends PageCreate {
    private CreationSelector m_parent;

    public ContactCreate(ItemSelectionModel itemModel, CreationSelector parent) {
        super(itemModel, parent);
        this.m_parent = parent;
    }

    protected void addWidgets() {
        super.addWidgets();
        TextField givenName = new TextField("givenName");
        this.add((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.givenname")));
        givenName.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)givenName);
        TextField familyName = new TextField("familyName");
        this.add((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.familyname")));
        familyName.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)familyName);
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        Folder f = this.m_parent.getFolder(state);
        ContentSection sec = this.m_parent.getContentSection(state);
        Contact contact = (Contact)this.createContentPage(state);
        contact.setLanguage((String)data.get((Object)"language"));
        contact.setName((String)data.get((Object)"name"));
        contact.setTitle((String)data.get((Object)"title"));
        contact.setGivenName((String)data.get((Object)"givenName"));
        contact.setFamilyName((String)data.get((Object)"familyName"));
        contact.save();
        ContentBundle bundle = new ContentBundle((ContentItem)contact);
        bundle.setParent((ACSObject)f);
        bundle.setContentSection(this.m_parent.getContentSection(state));
        bundle.save();
        this.getWorkflowSection().applyWorkflow(state, (ContentItem)contact);
        this.m_parent.editItem(state, (ContentItem)contact);
    }
}

