/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.BasicItemForm;
import com.arsdigita.london.contenttypes.Contact;
import com.arsdigita.london.contenttypes.ContactInitializer;
import com.arsdigita.london.contenttypes.ContactPhone;
import com.arsdigita.london.contenttypes.util.ContactGlobalizationUtil;
import java.util.ArrayList;

class ContactCreatePhone
extends BasicItemForm {
    private ItemSelectionModel m_model;

    public ContactCreatePhone(ItemSelectionModel itemModel) {
        super("Contact_phone_create", itemModel);
        this.m_model = itemModel;
    }

    protected void addWidgets() {
        this.add((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.phone_number")));
        StringParameter phoneNoParam = new StringParameter("phoneNumber");
        TextField phoneNo = new TextField((ParameterModel)phoneNoParam);
        phoneNo.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)phoneNo);
        this.add((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.phone_type")));
        StringParameter phoneTypeParam = new StringParameter("phoneType");
        SingleSelect phoneType = new SingleSelect((ParameterModel)phoneTypeParam);
        this.add((Component)phoneType);
        ArrayList phTypes = ContactInitializer.getPhoneTypes();
        for (int i = 0; i < phTypes.size(); ++i) {
            phoneType.addOption(new Option(phTypes.get(i).toString(), phTypes.get(i).toString()));
        }
    }

    public void init(FormSectionEvent e) {
    }

    public void process(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        Contact contact = (Contact)this.m_model.getSelectedObject(fse.getPageState());
        if (contact != null && this.getSaveCancelSection().getSaveButton().isSelected(fse.getPageState())) {
            ContactPhone cph = new ContactPhone();
            cph.setName("phone-for-contact-" + contact.getID());
            cph.setPhoneType((String)data.get((Object)"phoneType"));
            cph.setPhoneNumber((String)data.get((Object)"phoneNumber"));
            cph.save();
            contact.addPhone(cph);
        }
    }
}

