/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.london.contenttypes.Contact;
import com.arsdigita.london.contenttypes.ContactPhone;
import com.arsdigita.london.contenttypes.ContactPhonesCollection;
import com.arsdigita.london.contenttypes.util.ContactGlobalizationUtil;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

class ContactPhonesTable
extends Table
implements TableActionListener {
    private static final Logger log = Logger.getLogger((String)ContactPhonesTable.class.getName());
    private static final int COL_INDEX_PHONE_TYPE = 0;
    private static final int COL_INDEX_PHONE_NUM = 1;
    private static final int COL_INDEX_DELETE = 2;
    private ItemSelectionModel m_selContact;

    public ContactPhonesTable(ItemSelectionModel selContact) {
        this.m_selContact = selContact;
        TableColumnModel model = this.getColumnModel();
        model.add(new TableColumn(0, (Object)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.phonetable.header_type"))));
        model.add(new TableColumn(1, (Object)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.phonetable.header_num"))));
        model.add(new TableColumn(2, (Object)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.phonetable.header_delete"))));
        this.setEmptyView((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.phonetable.no_entries_msg")));
        model.get(2).setCellRenderer((TableCellRenderer)new DeleteCellRenderer());
        this.setModelBuilder(new PhonesTableModelBuilder(selContact));
        this.addTableActionListener(this);
    }

    public void cellSelected(TableActionEvent evt) {
        PageState state = evt.getPageState();
        TableColumn col = this.getColumnModel().get(evt.getColumn().intValue());
        int columnIndex = col.getModelIndex();
        if (columnIndex == 2) {
            BigDecimal phoneID = new BigDecimal(evt.getRowKey().toString());
            Contact contact = (Contact)this.m_selContact.getSelectedObject(state);
            ContactPhone ph = new ContactPhone(phoneID);
            contact.removePhone(ph);
        }
    }

    public void headSelected(TableActionEvent e) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    private class DeleteCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private DeleteCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            Component ret = null;
            SecurityManager sm = CMS.getSecurityManager((PageState)state);
            Contact item = (Contact)ContactPhonesTable.this.m_selContact.getSelectedObject(state);
            boolean canDelete = sm.canAccess(state.getRequest(), "delete_item", (ContentItem)item);
            if (value instanceof Label) {
                if (canDelete) {
                    ControlLink link = new ControlLink((Component)value);
                    link.setConfirmation(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.phonetable.confirm_delete"));
                    ret = link;
                } else {
                    ret = (Component)value;
                }
            } else {
                ret = (Component)value;
            }
            return ret;
        }
    }

    private class PhonesTableModel
    implements TableModel {
        private Table m_table;
        private ContactPhonesCollection m_phones;
        private ContactPhone m_phone;

        private PhonesTableModel(Table t, PageState ps, Contact c) {
            this.m_table = t;
            this.m_phones = c.getPhones();
        }

        public int getColumnCount() {
            return this.m_table.getColumnModel().size();
        }

        public boolean nextRow() {
            if (this.m_phones != null && this.m_phones.next()) {
                this.m_phone = this.m_phones.getPhone();
                return true;
            }
            return false;
        }

        public Object getElementAt(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.m_phone.getPhoneType();
                }
                case 1: {
                    return this.m_phone.getPhoneNumber();
                }
                case 2: {
                    return new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.phonetable.link_delete"));
                }
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_phone.getID();
        }
    }

    private class PhonesTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        private ItemSelectionModel m_sel;

        private PhonesTableModelBuilder(ItemSelectionModel sel) {
            this.m_sel = sel;
        }

        public TableModel makeModel(Table table, PageState state) {
            table.getRowSelectionModel().clearSelection(state);
            Contact contact = (Contact)this.m_sel.getSelectedObject(state);
            return new PhonesTableModel(table, state, contact);
        }
    }
}

