/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.util.GlobalizationUtil;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.ui.ResettableContainer;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.workflow.WorkflowLockedContainer;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.london.contenttypes.Contact;
import com.arsdigita.london.contenttypes.ui.ContactToItemAddForm;
import com.arsdigita.london.contenttypes.util.ContactGlobalizationUtil;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;

public class ContactPropertiesAddStep
extends ResettableContainer {
    private static final Logger s_log = Logger.getLogger(ContactPropertiesAddStep.class);
    public static final String EDIT_SHEET_NAME = "edit";
    public Form m_form;
    private ItemSelectionModel m_itemSelectionModel;
    public ContactSelectionModel m_contactSelectionModel;
    private AuthoringKitWizard m_parent;
    protected Component m_contactPropertySheet;
    private ContactDisplay m_display;

    public ContactPropertiesAddStep(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        this.m_parent = parent;
        this.m_itemSelectionModel = itemModel;
        this.m_contactSelectionModel = new ContactSelectionModel(this.m_itemSelectionModel);
        Form display = new Form("display");
        display.add(this.getContactDisplay());
        this.add((Component)display);
        this.m_form = new Form("contactSearchForm");
        this.m_form.add(this.getFindContactSheet());
        WorkflowLockedContainer edit = new WorkflowLockedContainer(itemModel);
        edit.add((Component)this.m_form);
        this.add((Component)edit);
    }

    protected Component getContactDisplay() {
        this.m_display = new ContactDisplay();
        return this.m_display;
    }

    public void toggleDisplay(PageState state) throws FormProcessException {
        this.m_display.toggle(state);
    }

    private Component getFindContactSheet() {
        return new ContactToItemAddForm(this);
    }

    public ItemSelectionModel getItemSelectionModel() {
        return this.m_itemSelectionModel;
    }

    public ItemSelectionModel getContactSelectionModel() {
        return this.m_contactSelectionModel;
    }

    public AuthoringKitWizard getParent() {
        return this.m_parent;
    }

    public ContentItem getItem(PageState state) {
        return this.m_itemSelectionModel.getSelectedItem(state);
    }

    public Contact getContact(PageState state) {
        return (Contact)this.m_contactSelectionModel.getSelectedItem(state);
    }

    private class ContactDisplay
    extends FormSection
    implements FormInitListener {
        private Label m_noContact;

        public ContactDisplay() {
            this.addInitListener(this);
            this.addWidgets();
        }

        public void toggle(PageState state) {
            s_log.debug((Object)"toggle");
            ContactPropertiesAddStep.this.m_contactPropertySheet.setVisible(state, false);
            this.m_noContact.setVisible(state, true);
        }

        private void addWidgets() {
            ContactPropertiesAddStep.this.m_contactPropertySheet = this.getContactPropertySheet(ContactPropertiesAddStep.this.m_contactSelectionModel);
            this.m_noContact = new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.no_contacts_yet"));
            this.m_noContact.setFontWeight("i");
            this.add(ContactPropertiesAddStep.this.m_contactPropertySheet);
            this.add((Component)this.m_noContact);
        }

        public void init(FormSectionEvent e) throws FormProcessException {
            s_log.debug((Object)"init");
            PageState state = e.getPageState();
            if (ContactPropertiesAddStep.this.m_contactSelectionModel.getSelectedItem(state) != null) {
                ContactPropertiesAddStep.this.m_contactPropertySheet.setVisible(state, true);
                this.m_noContact.setVisible(state, false);
            } else {
                this.m_noContact.setVisible(state, true);
                ContactPropertiesAddStep.this.m_contactPropertySheet.setVisible(state, false);
            }
        }

        private Component getContactPropertySheet(ItemSelectionModel itemModel) {
            DomainObjectPropertySheet sheet = new DomainObjectPropertySheet((DomainObjectSelectionModel)itemModel);
            sheet.add(ContactGlobalizationUtil.globalize("com.arsdigita.london.contenttypes.ui.name"), "name");
            sheet.add(ContactGlobalizationUtil.globalize("com.arsdigita.london.contenttypes.ui.title"), "title");
            sheet.add(ContactGlobalizationUtil.globalize("com.arsdigita.london.contenttypes.ui.contact_givenname"), "givenName");
            sheet.add(ContactGlobalizationUtil.globalize("com.arsdigita.london.contenttypes.ui.contact_familyname"), "familyName");
            sheet.add(ContactGlobalizationUtil.globalize("com.arsdigita.london.contenttypes.ui.contact_type"), "contactType", new DomainObjectPropertySheet.AttributeFormatter(){

                public String format(DomainObject item, String attribute, PageState state) {
                    Contact contact = (Contact)item;
                    if (contact != null && contact.getContactType() != null) {
                        return contact.getContactTypeName();
                    }
                    return (String)GlobalizationUtil.globalize((String)"cms.ui.unknown").localize();
                }
            });
            sheet.add(ContactGlobalizationUtil.globalize("com.arsdigita.london.contenttypes.ui.description"), "description");
            sheet.add(ContactGlobalizationUtil.globalize("com.arsdigita.london.contenttypes.ui.contact_emails"), "emails");
            sheet.add(ContactGlobalizationUtil.globalize("com.arsdigita.london.contenttypes.ui.contact_suffix"), "suffix");
            sheet.add(ContactGlobalizationUtil.globalize("com.arsdigita.london.contenttypes.ui.contact_orgname"), "orgName");
            sheet.add(ContactGlobalizationUtil.globalize("com.arsdigita.london.contenttypes.ui.contact_deptname"), "deptName");
            sheet.add(ContactGlobalizationUtil.globalize("com.arsdigita.london.contenttypes.ui.contact_role"), "role");
            return sheet;
        }
    }

    protected class ContactSelectionModel
    extends ItemSelectionModel {
        private RequestLocal m_contact;

        public ContactSelectionModel(ItemSelectionModel m) {
            super((SingleSelectionModel)m);
            this.m_contact = new RequestLocal(){

                protected Object initialValue(PageState s) {
                    ContentItem item = (ContentItem)((ItemSelectionModel)ContactSelectionModel.this.getSingleSelectionModel()).getSelectedObject(s);
                    Assert.exists((Object)item);
                    return Contact.getContactForItem(item);
                }
            };
        }

        public Object getSelectedKey(PageState s) {
            Contact contact = (Contact)this.getSelectedObject(s);
            return contact == null ? null : contact.getID();
        }

        public DomainObject getSelectedObject(PageState s) {
            return (DomainObject)this.m_contact.get(s);
        }

        public void setSelectedObject(PageState s, DomainObject o) {
            this.m_contact.set(s, (Object)o);
        }

        public void setSelectedKey(PageState s, Object key) {
            throw new UnsupportedOperationException((String)GlobalizationUtil.globalize((String)"cms.ui.authoring.not_implemented").localize());
        }

        public boolean isSelected(PageState s) {
            return this.getSelectedObject(s) != null;
        }
    }
}

