/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.london.contenttypes.Contact;
import com.arsdigita.london.contenttypes.ui.ContactPropertyForm;
import com.arsdigita.london.contenttypes.util.ContactGlobalizationUtil;
import com.arsdigita.toolbox.ui.ComponentAccess;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;

public class ContactPropertiesStep
extends SimpleEditStep {
    public static String EDIT_SHEET_NAME = "edit";

    public ContactPropertiesStep(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super(itemModel, parent);
        ContactPropertyForm editSheet = new ContactPropertyForm(itemModel, this);
        this.add(EDIT_SHEET_NAME, GlobalizationUtil.globalize((String)"cms.ui.edit"), (ComponentAccess)new WorkflowLockedComponentAccess((Component)editSheet, itemModel), editSheet.getSaveCancelSection().getCancelButton());
        this.setDefaultEditKey(EDIT_SHEET_NAME);
        this.setDisplayComponent(ContactPropertiesStep.getContactPropertySheet(itemModel));
    }

    public static Component getContactPropertySheet(ItemSelectionModel itemModel) {
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet((DomainObjectSelectionModel)itemModel);
        sheet.add(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.title"), "title");
        sheet.add(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.name"), "name");
        sheet.add(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.givenname"), "givenName");
        sheet.add(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.familyname"), "familyName");
        sheet.add(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.suffix"), "suffix");
        sheet.add(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.type"), "contactType", new DomainObjectPropertySheet.AttributeFormatter(){

            public String format(DomainObject item, String attribute, PageState state) {
                Contact contact = (Contact)item;
                if (contact.getContactType() != null) {
                    return contact.getContactTypeName();
                }
                return (String)GlobalizationUtil.globalize((String)"cms.ui.unknown").localize();
            }
        });
        sheet.add(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.description"), "description");
        sheet.add(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.emails"), "emails");
        sheet.add(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.orgname"), "orgName");
        sheet.add(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.deptname"), "deptName");
        sheet.add(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.role"), "role");
        return sheet;
    }
}

