/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.london.contenttypes.Contact;
import com.arsdigita.london.contenttypes.ContactType;
import com.arsdigita.london.contenttypes.ContactTypesCollection;
import com.arsdigita.london.contenttypes.ui.ContactPropertiesStep;
import com.arsdigita.london.contenttypes.util.ContactGlobalizationUtil;
import java.math.BigDecimal;

public class ContactPropertyForm
extends BasicPageForm {
    public static final String ID = "Contact_edit";
    private final ContactPropertiesStep step;

    public ContactPropertyForm(ItemSelectionModel itemModel, ContactPropertiesStep step) {
        super(ID, itemModel);
        this.step = step;
    }

    protected void addWidgets() {
        this.addBasicPageFormWidgets();
        this.addGivenNameWidget();
        this.addFamilyNameWidget();
        this.addSuffixWidget();
        this.addContactTypeWidget();
        this.addDescriptionWidget();
        this.addEmailsWidget();
        this.addOrganizationNameWidget();
        this.addDepartmentNameWidget();
        this.addRoleWidget();
    }

    protected void addBasicPageFormWidgets() {
        super.addWidgets();
    }

    protected void addGivenNameWidget() {
        this.add((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.givenname")));
        StringParameter givenNameParam = new StringParameter("givenName");
        TextField givenName = new TextField((ParameterModel)givenNameParam);
        this.add((Component)givenName);
    }

    protected void addFamilyNameWidget() {
        this.add((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.familyname")));
        StringParameter familyNameParam = new StringParameter("familyName");
        TextField familyName = new TextField((ParameterModel)familyNameParam);
        this.add((Component)familyName);
    }

    protected void addSuffixWidget() {
        this.add((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.suffix")));
        StringParameter suffixParam = new StringParameter("suffix");
        TextField suffix = new TextField((ParameterModel)suffixParam);
        this.add((Component)suffix);
    }

    protected void addContactTypeWidget() {
        this.add((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.type")));
        StringParameter contactTypeParam = new StringParameter("contactType");
        SingleSelect contactType = new SingleSelect((ParameterModel)contactTypeParam);
        this.add((Component)contactType);
        ContactTypesCollection ctTypes = ContactTypesCollection.getContactTypesCollection();
        while (ctTypes.next()) {
            contactType.addOption(new Option(ctTypes.getContactTypeID().toString(), ctTypes.getContactTypeName()));
        }
    }

    protected void addDescriptionWidget() {
        this.add((Component)new Label(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.description")));
        StringParameter descParam = new StringParameter("description");
        TextArea desc = new TextArea((ParameterModel)descParam);
        desc.setRows(5);
        this.add((Component)desc);
    }

    protected void addEmailsWidget() {
        this.add((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.emails")));
        StringParameter emailsParam = new StringParameter("emails");
        TextField emails = new TextField((ParameterModel)emailsParam);
        this.add((Component)emails);
    }

    protected void addOrganizationNameWidget() {
        this.add((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.orgname")));
        StringParameter orgNameParam = new StringParameter("orgName");
        TextField orgName = new TextField((ParameterModel)orgNameParam);
        this.add((Component)orgName);
    }

    protected void addDepartmentNameWidget() {
        this.add((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.deptname")));
        StringParameter deptParam = new StringParameter("deptName");
        TextField deptName = new TextField((ParameterModel)deptParam);
        this.add((Component)deptName);
    }

    protected void addRoleWidget() {
        this.add((Component)new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.role")));
        StringParameter roleParam = new StringParameter("role");
        TextField role = new TextField((ParameterModel)roleParam);
        this.add((Component)role);
    }

    public void init(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        Contact contact = (Contact)super.initBasicWidgets(fse);
        if (contact.getContactType() != null) {
            data.put((Object)"contactType", (Object)contact.getContactType().getID());
        }
        data.put((Object)"givenName", (Object)contact.getGivenName());
        data.put((Object)"familyName", (Object)contact.getFamilyName());
        data.put((Object)"suffix", (Object)contact.getSuffix());
        data.put((Object)"emails", (Object)contact.getEmails());
        data.put((Object)"description", (Object)contact.getDescription());
        data.put((Object)"orgName", (Object)contact.getOrganisationName());
        data.put((Object)"deptName", (Object)contact.getDeptName());
        data.put((Object)"role", (Object)contact.getRole());
    }

    public void process(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        Contact contact = (Contact)super.processBasicWidgets(fse);
        if (contact != null && this.getSaveCancelSection().getSaveButton().isSelected(fse.getPageState())) {
            contact.setGivenName((String)data.get((Object)"givenName"));
            contact.setFamilyName((String)data.get((Object)"familyName"));
            contact.setSuffix((String)data.get((Object)"suffix"));
            contact.setEmails((String)data.get((Object)"emails"));
            String contactTypeIDStr = (String)data.get((Object)"contactType");
            if (contactTypeIDStr != null) {
                BigDecimal contactTypeID = new BigDecimal(contactTypeIDStr);
                ContactType ctType = new ContactType(contactTypeID);
                contact.setContactType(ctType);
            }
            contact.setDescription((String)data.get((Object)"description"));
            contact.setOrganisationName((String)data.get((Object)"orgName"));
            contact.setDeptName((String)data.get((Object)"deptName"));
            contact.setRole((String)data.get((Object)"role"));
            contact.save();
            this.step.maybeForwardToNextStep(fse.getPageState());
        }
    }
}

