/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.contenttypes.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.ItemSearchWidget;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.london.contenttypes.Contact;
import com.arsdigita.london.contenttypes.ui.ContactPropertiesAddStep;
import com.arsdigita.london.contenttypes.util.ContactGlobalizationUtil;

public class ContactToItemAddForm
extends FormSection
implements FormInitListener,
FormValidationListener,
FormProcessListener,
FormSubmissionListener {
    private ContentItem m_item;
    private ItemSearchWidget m_itemSearch;
    private SaveCancelSection m_saveCancelSection;
    private ItemSelectionModel m_itemSelectionModel;
    private final String CONTACT_SEARCH = "contact";
    private Contact m_contact;
    private Label m_searchFormLabel;
    private ContactPropertiesAddStep m_step;
    private AuthoringKitWizard m_parent;
    private Label m_removeLinkText = new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.remove_contact"));
    private ActionLink m_removeLink;

    public ContactToItemAddForm(ContactPropertiesAddStep step) {
        this.m_step = step;
        this.m_parent = this.m_step.getParent();
        this.m_itemSelectionModel = this.m_step.getItemSelectionModel();
        this.addInitListener(this);
        this.addWidgets();
        this.addSaveCancelSection();
        this.addProcessListener(this);
        this.addValidationListener(this);
        this.addSubmissionListener(this);
    }

    public void addWidgets() {
        this.m_removeLink = new ActionLink((Component)this.m_removeLinkText);
        this.m_removeLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Contact contact = ContactToItemAddForm.this.m_step.getContact(e.getPageState());
                if (contact != null) {
                    PageState state = e.getPageState();
                    contact.removeContentItem(ContactToItemAddForm.this.m_step.getItem(state));
                    ((ContactToItemAddForm)ContactToItemAddForm.this).m_step.m_contactSelectionModel.setSelectedObject(state, null);
                    try {
                        ContactToItemAddForm.this.m_step.toggleDisplay(state);
                    }
                    catch (FormProcessException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.add((Component)this.m_removeLink, 64);
        this.m_searchFormLabel = new Label(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.search_contact_label"));
        this.add((Component)this.m_searchFormLabel);
        this.m_itemSearch = new ItemSearchWidget("contact", "com.arsdigita.london.contenttypes.Contact");
        this.add((Component)this.m_itemSearch);
    }

    public ContactToItemAddForm getThis() {
        return this;
    }

    public void addSaveCancelSection() {
        this.m_saveCancelSection = new SaveCancelSection();
        this.m_saveCancelSection.getSaveButton().setButtonLabel(ContactGlobalizationUtil.globalize("london.contenttypes.ui.contact.add_contact"));
        this.add((Component)this.m_saveCancelSection, 64);
    }

    protected ContentItem getContentItem(PageState s) {
        return (ContentItem)this.m_itemSelectionModel.getSelectedObject(s);
    }

    public void validate(FormSectionEvent e) throws FormProcessException {
        FormData data = e.getFormData();
        if (data.get((Object)"contact") == null) {
            throw new FormProcessException("Contact selection is required.");
        }
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        FormData data = e.getFormData();
        PageState ps = e.getPageState();
        this.m_contact = (Contact)((Object)data.get((Object)"contact"));
        this.m_contact.addContentItem(this.getContentItem(ps));
        this.init(e);
    }

    public void submitted(FormSectionEvent e) throws FormProcessException {
        if (this.m_saveCancelSection.getCancelButton().isSelected(e.getPageState())) {
            this.m_parent.reset(e.getPageState());
            throw new FormProcessException("cancelled");
        }
    }

    public void init(FormSectionEvent e) throws FormProcessException {
        PageState ps = e.getPageState();
        this.m_item = this.getContentItem(ps);
        this.m_contact = Contact.getContactForItem(this.m_item);
        if (this.m_contact != null) {
            this.m_removeLink.setVisible(ps, true);
            this.m_searchFormLabel.setVisible(ps, false);
            this.m_itemSearch.setVisible(ps, false);
            this.m_saveCancelSection.setVisible(ps, false);
        } else {
            this.m_removeLink.setVisible(ps, false);
            this.m_searchFormLabel.setVisible(ps, true);
            this.m_itemSearch.setVisible(ps, true);
            this.m_saveCancelSection.setVisible(ps, true);
        }
    }
}

