/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr;

import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.docmgr.DocFolder;
import com.arsdigita.cms.docmgr.DocLink;
import com.arsdigita.cms.docmgr.Repository;
import com.arsdigita.cms.docmgr.Resource;
import com.arsdigita.cms.docmgr.ResourceExistsException;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class Document
extends ContentPage
implements Resource {
    private static final Logger s_log = Logger.getLogger(Document.class);
    public static final String DESCRIPTION = "description";
    public static final String FILE = "file";
    public static final String AUTHOR = "author";
    public static final String CREATOR = "creator";
    public static final String LAST_MOD_LOCAL = "lastModifiedTimeCached";
    public static final String AUTHOR_LAST_NAME = "authorLastName";
    public static final String REPOSITORY = "repository";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.docmgr.Document";
    public static final String TYPE = "com.arsdigita.cms.docmgr.Document";
    private boolean m_wasNew;

    public Document() {
        this("com.arsdigita.cms.docmgr.Document");
        try {
            this.setContentType(ContentType.findByAssociatedObjectType((String)"com.arsdigita.cms.docmgr.Document"));
        }
        catch (DataObjectNotFoundException e) {
            throw new UncheckedWrapperException((String)GlobalizationUtil.globalize((String)"cms.contenttypes.event_type_not_registered").localize(), (Throwable)e);
        }
    }

    public Document(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID("com.arsdigita.cms.docmgr.Document", (Object)id));
    }

    public Document(OID id) throws DataObjectNotFoundException {
        super(id);
    }

    public Document(DataObject obj) {
        super(obj);
    }

    public Document(String type) {
        super(type);
    }

    public static Document retrieveDocument(DataObject documentData) {
        Document document = (Document)DomainObjectFactory.newInstance((DataObject)documentData);
        if (document == null) {
            throw new RuntimeException("Domain object factory produced null document for data object " + documentData);
        }
        return document;
    }

    @Override
    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.set(DESCRIPTION, description);
    }

    public User getCreator() {
        if (this.get(CREATOR) == null) {
            return null;
        }
        return new User((DataObject)this.get(CREATOR));
    }

    public void setCreator(User creator) {
        this.set(CREATOR, creator);
    }

    public Repository getRepository() {
        if (this.get(REPOSITORY) == null) {
            return null;
        }
        return new Repository((DataObject)this.get(REPOSITORY));
    }

    public void setRepository(Repository repository) {
        this.set(REPOSITORY, (Object)repository);
    }

    public Date getLastModifiedLocal() {
        return (Date)this.get(LAST_MOD_LOCAL);
    }

    public void setLastModifiedLocal(Date last) {
        this.set(LAST_MOD_LOCAL, last);
    }

    public String getImpliedAuthor() {
        if (this.getAuthor() == null) {
            if (this.getCreator() == null) {
                return "";
            }
            return this.getCreator().getName();
        }
        return this.getAuthor();
    }

    public String getAuthor() {
        return (String)this.get(AUTHOR);
    }

    public void setAuthor(String author) {
        if (author != null && this.getCreationUser() != null && author.equals(this.getCreationUser().getName())) {
            this.set(AUTHOR, null);
            this.setAuthorLastName(null);
        }
        this.set(AUTHOR, author);
        String[] chunks = StringUtils.split((String)author, (char)' ');
        if (chunks.length > 0) {
            this.setAuthorLastName(chunks[chunks.length - 1]);
        } else {
            this.setAuthorLastName(null);
        }
    }

    public String getAuthorLastName() {
        return (String)this.get(AUTHOR_LAST_NAME);
    }

    private void setAuthorLastName(String authorLastName) {
        this.set(AUTHOR_LAST_NAME, authorLastName);
    }

    public void setTitle(String title) {
        this.setName(URLEncoder.encode(title));
        super.setTitle(title);
    }

    public FileAsset getFile() {
        if (this.get(FILE) == null) {
            return null;
        }
        return new FileAsset((DataObject)this.get(FILE));
    }

    public void setFile(FileAsset file) {
        this.setAssociation(FILE, (DomainObject)file);
        if (file != null) {
            file.setMaster(this.getMaster());
        }
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public Resource copyTo(Resource parent) throws ResourceExistsException {
        return this.copyTo(this.getTitle(), parent);
    }

    @Override
    public Resource copyTo(String name, final Resource parent) throws ResourceExistsException {
        Folder.ItemCollection ic = ((Folder)parent).getItems();
        ic.addEqualsFilter("name", (Object)URLEncoder.encode(name));
        boolean resourceExists = ic.next();
        ic.close();
        if (resourceExists) {
            throw new ResourceExistsException("Copying document would result in duplicate: " + name);
        }
        Document item = this;
        if (item.getParent() instanceof ContentBundle) {
            item = (ContentBundle)item.getParent();
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Copying item " + item));
        }
        final ContentItem newItem = item.copy();
        newItem.copyServicesFrom((ContentItem)item);
        newItem.setParent((ACSObject)((Folder)parent));
        newItem.setContentSection(item.getContentSection());
        newItem.save();
        new KernelExcursion(){

            protected void excurse() {
                this.setParty(Kernel.getSystemParty());
                PermissionService.setContext((ACSObject)newItem, (ACSObject)((ACSObject)parent));
            }
        }.run();
        return (Resource)((ContentBundle)newItem).getPrimaryInstance();
    }

    @Override
    public Resource copyTo(String name) throws ResourceExistsException {
        ACSObject parent = this.getParent();
        return this.copyTo(name, (Resource)parent);
    }

    @Override
    public URL toURL() {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getSize() {
        FileAsset fa = this.getFile();
        if (fa == null) {
            return BigDecimal.valueOf(0L);
        }
        return new BigDecimal(fa.getSize());
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    public String getPrettyMimeType() {
        FileAsset fa = this.getFile();
        if (fa == null) {
            return "";
        }
        if (fa.getMimeType() == null) {
            return "unknown";
        }
        return fa.getMimeType().getLabel();
    }

    @Override
    public Resource getParentResource() {
        DocFolder parent = (DocFolder)((ContentBundle)this.getParent()).getParent();
        return parent;
    }

    @Override
    public void setParentResource(final Resource r) {
        final ContentBundle cb = (ContentBundle)this.getParent();
        cb.setParent((ACSObject)r);
        cb.save();
        new KernelExcursion(){

            protected void excurse() {
                this.setParty(Kernel.getSystemParty());
                PermissionService.setContext((ACSObject)cb, (ACSObject)((ACSObject)r));
            }
        }.run();
    }

    protected void beforeSave() {
        super.beforeSave();
        if (this.isNew()) {
            s_log.debug((Object)(this + "newly created Document"));
            this.m_wasNew = true;
        }
        if (this.m_wasNew) {
            this.setCreator(this.getCreationUser());
        }
    }

    public void setCategories(String[] catIDs) {
        CategoryCollection cats;
        HashSet<String> newCategories = new HashSet<String>();
        if (catIDs != null) {
            for (int i = 0; i < catIDs.length; ++i) {
                newCategories.add(catIDs[i]);
                s_log.debug((Object)("newCategories: " + catIDs[i]));
            }
        }
        if ((cats = this.getCategoryCollection()).next()) {
            Category cat = cats.getCategory();
            String catID = cat.getID().toString();
            if (newCategories.contains(catID)) {
                newCategories.remove(catID);
            } else {
                this.removeCategory(cat);
            }
        }
        Iterator additions = newCategories.iterator();
        while (additions.hasNext()) {
            this.addCategory(new Category(new BigDecimal((String)additions.next())));
        }
    }

    public Folder.ItemCollection getDocumentsWithName(Folder parentFolder, String name) {
        Folder.ItemCollection ic = parentFolder.getItems();
        ic.addEqualsFilter("name", (Object)name);
        return ic;
    }

    @Override
    public void delete() throws PersistenceException {
        this.deleteReferringLinks();
        ((ContentBundle)this.getParent()).delete();
    }

    private void deleteReferringLinks() {
        DataQuery dq = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.docmgr.getReferringLinks");
        dq.setParameter("docID", (Object)this.getID());
        while (dq.next()) {
            DataObject dobj = (DataObject)dq.get("docLink");
            DocLink docLink = new DocLink(dobj);
            docLink.delete();
        }
        dq.close();
    }

    public String getSearchLanguage() {
        return "eng";
    }

    public byte[] getSearchRawContent() {
        return new byte[0];
    }

    public String getSearchUrlStub() {
        return "";
    }

    public String getSearchLinkText() {
        return this.getTitle();
    }
}

