/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr;

import com.arsdigita.cms.docmgr.DocFolder;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.docmgr.Repository;
import com.arsdigita.cms.docmgr.ui.RecentUpdatedDocsPortlet;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.runtime.CompoundInitializer;
import com.arsdigita.runtime.DomainInitEvent;
import java.io.File;
import org.apache.log4j.Logger;

public class Initializer
extends CompoundInitializer {
    private static Logger s_log = Logger.getLogger(Initializer.class);
    private static final String SEPARATOR = File.separator;
    private static String PACKAGE_TYPE_NAME = "cmsdocs";
    private static String CATEGORY_PACKAGE_TYPE_NAME = "cmsdocs-categories";
    private static String LEGACY_PACKAGE_TYPE_NAME = "cmsdocs-categories-legacy";
    public static final String CONTENT_SECTION = "contentSection";
    public static final String INTERNAL_GROUP_ID = "internalGroupID";
    public static final String LEGACY_FOLDER_NAME = "legacyFolderName";

    public void init(DomainInitEvent e) {
        s_log.debug((Object)"Document (CCM) Manager is Domain initializing ... ");
        e.getFactory();
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.cms.docmgr.Repository", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new Repository(dataObject);
            }
        });
        e.getFactory();
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.cms.docmgr.ui.RecentUpdatedDocsPortlet", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new RecentUpdatedDocsPortlet(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.cms.docmgr.Document", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new Document(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.cms.docmgr.DocFolder", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new DocFolder(dataObject);
            }
        });
        this.startup();
    }

    public void startup() {
        s_log.info((Object)"Document Manager is initializing.");
        TransactionContext txn = SessionManager.getSession().getTransactionContext();
        txn.beginTxn();
        txn.commitTxn();
        s_log.info((Object)"Document Manager Initializer completed.");
    }

    public void shutdown() {
    }
}

