/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.search;

import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.docmgr.search.LuceneSearchResults;
import com.arsdigita.cms.docmgr.search.SearchResults;
import com.arsdigita.cms.docmgr.search.Searcher;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.User;
import com.arsdigita.search.lucene.LuceneSearch;
import com.arsdigita.search.lucene.ObjectTypeFilter;
import com.arsdigita.search.lucene.TypeSpecificFilter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Filter;

public class LuceneSearcher
implements Searcher {
    private static final Logger s_log = Logger.getLogger(LuceneSearcher.class);
    private static final int SCORE_MULTIPLIER = 100;

    @Override
    public SearchResults simpleSearch(String terms, User user) {
        TypeSpecificFilter tsf = new TypeSpecificFilter("live");
        LuceneSearch search = new LuceneSearch(terms, (Filter)tsf);
        s_log.debug((Object)("Do lucene simple search for [" + terms + "] ignoring user permissions"));
        return new LuceneSearchResults(search);
    }

    @Override
    public SearchResults advancedSearch(String terms, String author, String mimeType, BigDecimal workspaceID, Date lastModifiedStartDate, Date lastModifiedEndDate, String[] types, String[] sections, User user, Collection categoryIDs) {
        LuceneSearch search = null;
        Object filter = null;
        if (types != null && types.length > 0) {
            try {
                Filter[] filters = new Filter[types.length];
                for (int i = 0; i < filters.length; ++i) {
                    ContentType type = new ContentType(new BigDecimal(types[i]));
                    filters[i] = new ObjectTypeFilter(type.getClassName());
                }
                filter = new UnionFilter(filters);
            }
            catch (DataObjectNotFoundException e) {
                s_log.error((Object)e.getMessage());
            }
        }
        final TypeSpecificFilter tsf = new TypeSpecificFilter("live");
        if (filter == null) {
            filter = tsf;
        } else {
            TypeSpecificFilter objectTypeFilter = filter;
            filter = new Filter((Filter)objectTypeFilter){
                final /* synthetic */ Filter val$objectTypeFilter;
                {
                    this.val$objectTypeFilter = filter;
                }

                public BitSet bits(IndexReader reader) throws IOException {
                    BitSet bits = new BitSet(reader.maxDoc());
                    bits.or(tsf.bits(reader));
                    bits.and(this.val$objectTypeFilter.bits(reader));
                    return bits;
                }
            };
        }
        search = filter != null ? new LuceneSearch(terms, (Filter)filter) : new LuceneSearch(terms);
        return new LuceneSearchResults(search);
    }

    private class UnionFilter
    extends Filter {
        private Filter[] m_filters;

        public UnionFilter(Filter[] filters) {
            this.m_filters = filters;
        }

        public BitSet bits(IndexReader reader) throws IOException {
            BitSet bits = new BitSet(reader.maxDoc());
            for (int i = 0; i < this.m_filters.length; ++i) {
                bits.or(this.m_filters[i].bits(reader));
            }
            return bits;
        }
    }
}

