/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.search;

import com.arsdigita.cms.docmgr.search.SearchResults;
import com.arsdigita.cms.docmgr.search.Searcher;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class SearchUtils {
    private static final Logger s_log = Logger.getLogger(SearchUtils.class);
    private static Vector s_threads = new Vector();
    private static Searcher s_searcher;

    public static synchronized void setSearcher(Searcher searcher) {
        s_searcher = searcher;
    }

    public static synchronized Searcher getSearcher() {
        return s_searcher;
    }

    public static SearchResults getSimpleSearch(String terms, User user) {
        s_log.debug((Object)"getSimpleSearch()");
        return SearchUtils.getSearcher().simpleSearch(terms, user);
    }

    public static SearchResults getAdvancedSearch(String terms, String author, String mimeType, BigDecimal workspaceID, Date lastModifiedStartDate, Date lastModifiedEndDate, String[] types, String[] sections, User user, Collection categoryIDs) {
        return SearchUtils.getSearcher().advancedSearch(terms, author, mimeType, workspaceID, lastModifiedStartDate, lastModifiedEndDate, types, sections, user, categoryIDs);
    }

    public static void reindexObjects(DataCollection objects, String idAttribute) {
        while (objects.next()) {
            BigDecimal id = (BigDecimal)objects.get(idAttribute);
            try {
                s_log.debug((Object)("Reindexing object id: " + id));
                ACSObject acsObject = (ACSObject)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.kernel.ACSObject", (Object)id));
                acsObject.save();
                System.gc();
                Thread.currentThread();
                Thread.yield();
            }
            catch (DataObjectNotFoundException ex) {
                s_log.warn((Object)("Object " + id + " in search content does not exist"));
            }
        }
    }
}

