/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.form.FileUpload;
import com.arsdigita.bebop.form.MultipleSelect;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.EmailValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.parameters.TrimmedStringParameter;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentSectionCollection;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.docmgr.DocMgr;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.docmgr.ui.BrowsePane;
import com.arsdigita.cms.docmgr.ui.CategoriesPrintListener;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.cms.docmgr.ui.DMUtils;
import com.arsdigita.cms.docmgr.ui.DocmgrBasePage;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.MultipartHttpServletRequest;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.ObjectPermissionCollection;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.mail.Mail;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.versioning.TransactionCollection;
import com.arsdigita.versioning.Versions;
import com.arsdigita.web.Application;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.TooManyListenersException;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class BrowseFileInfoPropertiesPane
extends ModalContainer
implements DMConstants {
    private static final Logger s_log = Logger.getLogger(BrowseFileInfoPropertiesPane.class);
    private BrowsePane m_parent;
    private Page m_page;
    private Component m_properties;
    private Component m_edit;
    private Component m_upload;
    private FileSendColleaguePane m_sendColleague;
    private Component m_action;
    private FilePropertiesPanel m_propertiesPane;
    private BigDecimalParameter docIDParam = new BigDecimalParameter("doc_id");

    public BrowseFileInfoPropertiesPane(BrowsePane parent) {
        this.m_parent = parent;
        this.m_properties = this.makePropertiesPane();
        this.add(this.m_properties);
        this.setDefaultComponent(this.m_properties);
        this.m_edit = this.makeEditPane();
        this.add(this.m_edit);
        this.m_upload = this.makeUploadForm();
        this.add(this.m_upload);
        this.m_sendColleague = this.makeSendColleagueForm();
        this.add((Component)this.m_sendColleague);
    }

    public void register(Page p) {
        this.m_page = p;
        p.addGlobalStateParam((ParameterModel)this.docIDParam);
        super.register(p);
    }

    public BigDecimalParameter getFileIDParam() {
        try {
            return ((DocmgrBasePage)this.m_page).getFileIDParam();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void setDocID(PageState state, BigDecimal docID) {
        state.setValue((ParameterModel)this.docIDParam, (Object)docID);
        this.m_page.getTitle().setLabel(DMUtils.getFile(docID).getTitle(), state);
    }

    private Component makePropertiesPane() {
        SimpleContainer container = new SimpleContainer();
        this.m_propertiesPane = new FilePropertiesPanel(this);
        container.add((Component)this.m_propertiesPane);
        container.add((Component)new FileActionPane());
        return container;
    }

    public void displayPropertiesPane(PageState state) {
        this.setVisibleComponent(state, this.m_properties);
    }

    private Component makeEditPane() {
        return new FileEditForm(this);
    }

    public void displayEditForm(PageState state) {
        this.setVisibleComponent(state, this.m_edit);
    }

    private Component makeUploadForm() {
        return new VersionUploadForm();
    }

    public void displayUploadForm(PageState state) {
        this.setVisibleComponent(state, this.m_upload);
    }

    private FileSendColleaguePane makeSendColleagueForm() {
        return new FileSendColleaguePane();
    }

    public void displaySendColleagueForm(PageState state) {
        this.m_sendColleague.initState(state);
        this.setVisibleComponent(state, (Component)this.m_sendColleague);
    }

    private final class DeleteListener
    implements ActionListener {
        private DeleteListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PageState state = e.getPageState();
            Document doc = new Document((BigDecimal)state.getValue((ParameterModel)BrowseFileInfoPropertiesPane.this.docIDParam));
            ContentBundle cb = (ContentBundle)doc.getParent();
            String parentFolderID = cb.getParent().getID().toString();
            cb.delete();
            try {
                String appURI = this.getRedirectURI(state);
                DispatcherHelper.sendRedirect((HttpServletRequest)state.getRequest(), (HttpServletResponse)state.getResponse(), (String)(appURI + "?" + DMConstants.SEL_FOLDER_ID_PARAM.getName() + "=" + parentFolderID));
            }
            catch (IOException iox) {
                throw new UncheckedWrapperException((Throwable)iox);
            }
        }

        private String getRedirectURI(PageState state) {
            String servletPath;
            String appURI = state.getRequestURI();
            s_log.debug((Object)("Original app URI: " + appURI));
            int idx = appURI.indexOf("/file/");
            if (idx > -1) {
                appURI = appURI.substring(0, idx);
            }
            if (appURI.startsWith(servletPath = Web.getConfig().getDispatcherServletPath())) {
                appURI = appURI.substring(servletPath.length());
            }
            s_log.debug((Object)("New URI: " + appURI));
            return appURI;
        }
    }

    class FileActionPane
    extends ColumnPanel
    implements RequestListener {
        private ActionLink m_newVersion;
        private Link m_download;
        private ActionLink m_email;
        private ActionLink m_delete;
        private ActionLink m_editLink;
        private ActionLink m_fileRevisions;

        public FileActionPane() {
            super(1);
            this.add((Component)new BackCancelActionLink("back"));
            this.m_editLink = new ActionLink((Component)new Label(DMConstants.FILE_EDIT_LINK));
            this.m_editLink.setClassAttr("actionLink");
            this.m_editLink.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PageState state = e.getPageState();
                    BrowseFileInfoPropertiesPane.this.displayEditForm(state);
                }
            });
            this.add((Component)this.m_editLink);
            this.m_fileRevisions = new ActionLink("file revisions");
            this.m_fileRevisions.setClassAttr("actionLink");
            this.m_fileRevisions.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PageState state = e.getPageState();
                    BrowseFileInfoPropertiesPane.this.m_parent.displayFileVersions(state, (BigDecimal)state.getValue((ParameterModel)BrowseFileInfoPropertiesPane.this.docIDParam));
                }
            });
            this.add((Component)this.m_fileRevisions);
            this.m_newVersion = this.addActionLink(DMConstants.FILE_NEW_VERSION_LINK);
            PrintListener printListener = new PrintListener(){

                public void prepare(PrintEvent e) {
                    Link l = (Link)e.getTarget();
                    PageState state = e.getPageState();
                    Document f = new Document((BigDecimal)state.getValue((ParameterModel)BrowseFileInfoPropertiesPane.this.docIDParam));
                    l.setTarget("download/?d_id=" + f.getID());
                }
            };
            this.m_download = new Link((Component)new Label(DMConstants.FILE_DOWNLOAD_LINK), printListener);
            this.m_download.setClassAttr("actionLink");
            this.add((Component)this.m_download);
            this.m_email = this.addActionLink(DMConstants.FILE_SEND_COLLEAGUE_LINK);
            this.m_delete = this.addActionLink(DMConstants.FILE_DELETE_LINK);
            this.m_newVersion.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BrowseFileInfoPropertiesPane.this.displayUploadForm(e.getPageState());
                }
            });
            this.m_email.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BrowseFileInfoPropertiesPane.this.displaySendColleagueForm(e.getPageState());
                }
            });
            this.m_delete.addActionListener((ActionListener)new DeleteListener());
            this.m_delete.setConfirmation(DMConstants.FILE_DELETE_CONFIRM.localize().toString());
        }

        public void register(Page p) {
            super.register(p);
            p.addRequestListener((RequestListener)this);
        }

        private ActionLink addActionLink(GlobalizedMessage msg) {
            ActionLink ln = new ActionLink((Component)new Label(msg));
            ln.setClassAttr("actionLink");
            this.add((Component)ln);
            return ln;
        }

        public void pageRequested(RequestEvent event) {
            PageState state = event.getPageState();
            s_log.debug((Object)"pageRequested");
            if (!this.isVisible(state)) {
                return;
            }
            User user = Web.getContext().getUser();
            Application app = Web.getContext().getApplication();
            if (PermissionService.checkPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)app, (Party)user))) {
                return;
            }
            if (!PermissionService.checkPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.EDIT, (ACSObject)app, (Party)user))) {
                this.m_editLink.setVisible(state, false);
                this.m_delete.setVisible(state, false);
                this.m_newVersion.setVisible(state, false);
            }
        }
    }

    class SendForm
    extends Form
    implements FormProcessListener {
        private static final String EMAIL_PARAM_NAME = "scEmail";
        private final TrimmedStringParameter m_emailParam;
        private FileSendColleaguePane m_parent;

        public SendForm(FileSendColleaguePane parent) {
            super("sendEmail", (Container)new BoxPanel());
            this.m_emailParam = new TrimmedStringParameter(EMAIL_PARAM_NAME);
            this.m_parent = parent;
            GridPanel panel = new GridPanel(2);
            panel.add((Component)DMConstants.FILE_SEND_COLLEAGUE_FORM_EMAIL);
            TextField emailField = new TextField((ParameterModel)this.m_emailParam);
            emailField.addValidationListener((ParameterListener)new EmailValidationListener());
            panel.add((Component)emailField, 1);
            panel.add((Component)new Submit(DMConstants.FILE_SEND_COLLEAGUE_SUBMIT));
            this.add((Component)panel);
            this.addProcessListener(this);
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            FormData data = e.getFormData();
            this.setVisible(state, false);
            this.m_parent.displayThankYou(state);
            User u = Web.getContext().getUser();
            s_log.debug((Object)DMConstants.FILE_SEND_COLLEAGUE_RETURN_ADDRESS.localize().toString());
            Mail mail = new Mail((String)data.get((Object)EMAIL_PARAM_NAME), DMConstants.FILE_SEND_COLLEAGUE_RETURN_ADDRESS.localize().toString(), DMConstants.FILE_SEND_COLLEAGUE_SUBJECT.localize().toString(), DMConstants.FILE_SEND_COLLEAGUE_MESSAGE.localize().toString() + " " + u.getName());
            Document doc = new Document((BigDecimal)state.getValue((ParameterModel)BrowseFileInfoPropertiesPane.this.docIDParam));
            try {
                FileAsset fa = doc.getFile();
                if (fa == null) {
                    return;
                }
                ByteArrayOutputStream assetStream = new ByteArrayOutputStream();
                long readBytes = fa.writeBytes((OutputStream)assetStream);
                if (readBytes == 0L) {
                    return;
                }
                String mimeTypeString = "application/octet-stream";
                MimeType mimeType = fa.getMimeType();
                if (mimeType != null) {
                    mimeTypeString = mimeType.getMimeType();
                }
                s_log.debug((Object)("mimeTypeString: " + mimeTypeString));
                mail.attach(assetStream.toByteArray(), mimeTypeString, doc.getTitle());
                mail.send();
            }
            catch (IOException iox) {
                s_log.error((Object)"SendForm.process", (Throwable)iox);
                throw new FormProcessException("An error occurred while trying to send document");
            }
            catch (MessagingException mex) {
                s_log.error((Object)"SendForm.process", (Throwable)mex);
                throw new FormProcessException("An error occurred while trying to send document");
            }
        }
    }

    class FileSendColleaguePane
    extends SimpleContainer {
        private Component m_sendForm;
        private Component m_thankYou;

        public FileSendColleaguePane() {
            GridPanel spacer = new GridPanel(1);
            spacer.add((Component)new Label("   "));
            this.add((Component)spacer);
            this.m_sendForm = new SendForm(this);
            this.add(this.m_sendForm);
            this.m_thankYou = this.buildThankYou();
            this.add(this.m_thankYou);
        }

        public void initState(PageState ps) {
            s_log.debug((Object)"FileSendColleaguePane.initState");
            this.m_sendForm.setVisible(ps, true);
            this.m_thankYou.setVisible(ps, false);
        }

        private Component buildThankYou() {
            BoxPanel panel = new BoxPanel();
            panel.add((Component)DMConstants.FILE_SEND_COLLEAGUE_THANKS);
            ActionLink backLink = new ActionLink(DMConstants.FILE_SEND_COLLEAGUE_THANKS_RETURN_LINK.localize().toString());
            backLink.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PageState state = e.getPageState();
                    BrowseFileInfoPropertiesPane.this.displayPropertiesPane(state);
                }
            });
            panel.add((Component)backLink);
            return panel;
        }

        public void displayThankYou(PageState ps) {
            s_log.debug((Object)"FileSendColleaguePane.displayThankYou");
            this.m_thankYou.setVisible(ps, true);
        }
    }

    class VersionUploadForm
    extends Form
    implements FormInitListener,
    FormProcessListener,
    FormValidationListener {
        private static final String VERSION_UPLOAD_FORM = "file-version";
        private static final String VERSION_TRANSACTION_DESCRIPTION = "file-transaction-description";
        private static final String VERSION_FILE_UPLOAD = "file-version-upload";
        private FileUpload m_fileUpload;
        private StringParameter m_versionDesc;
        private RequestLocal m_fileData;
        private Submit m_submit;
        private int FOUR_K_CHAR_LIMIT;

        public VersionUploadForm() {
            super(VERSION_UPLOAD_FORM, (Container)new ColumnPanel(2));
            this.FOUR_K_CHAR_LIMIT = 1994;
            this.setMethod("post");
            this.setEncType("multipart/form-data");
            this.m_fileData = new RequestLocal(){

                protected Object initialValue(PageState state) {
                    BigDecimal id = (BigDecimal)state.getValue((ParameterModel)BrowseFileInfoPropertiesPane.this.docIDParam);
                    return new Document(id);
                }
            };
            this.m_fileUpload = new FileUpload(VERSION_FILE_UPLOAD);
            this.m_versionDesc = new StringParameter(VERSION_TRANSACTION_DESCRIPTION);
            this.add((Component)new Label("Title"));
            Label labelTitle = new Label();
            labelTitle.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    PageState state = e.getPageState();
                    Label t = (Label)e.getTarget();
                    t.setLabel(VersionUploadForm.this.getFile(state).getTitle());
                }
            });
            this.add((Component)labelTitle);
            this.add((Component)new Label(DMConstants.FILE_NAME));
            Label label = new Label();
            label.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    PageState state = e.getPageState();
                    Label t = (Label)e.getTarget();
                    t.setLabel(URLDecoder.decode(VersionUploadForm.this.getFile(state).getName()));
                }
            });
            this.add((Component)label);
            this.add((Component)new Label(DMConstants.FILE_SOURCE));
            this.add((Component)this.m_fileUpload);
            this.add((Component)new Label(DMConstants.FILE_VERSION_DESCRIPTION));
            TextArea fversionDesc = new TextArea((ParameterModel)this.m_versionDesc);
            fversionDesc.setRows(10);
            fversionDesc.setCols(40);
            this.add((Component)fversionDesc);
            this.m_submit = new Submit("file-version-save");
            this.m_submit.setButtonLabel(DMConstants.FILE_SAVE);
            this.add((Component)new Label());
            SimpleContainer sc = new SimpleContainer();
            sc.add((Component)this.m_submit);
            sc.add((Component)new Submit(DMConstants.CANCEL));
            this.add((Component)sc, 1);
            this.addInitListener(this);
            this.addValidationListener(this);
            this.addProcessListener(this);
        }

        private Document getFile(PageState s) {
            return (Document)this.m_fileData.get(s);
        }

        public void init(FormSectionEvent e) {
            PageState state = e.getPageState();
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            if (this.m_submit.isSelected(state)) {
                FormData data = e.getFormData();
                MultipartHttpServletRequest req = (MultipartHttpServletRequest)state.getRequest();
                String fpath = (String)data.get((Object)VERSION_FILE_UPLOAD);
                String fname = DMUtils.extractFileName(fpath, state);
                Document doc = this.getFile(state);
                File src = null;
                try {
                    if (fpath != null && fpath.length() > 0) {
                        src = req.getFile(VERSION_FILE_UPLOAD);
                    }
                    FileAsset fa = doc.getFile();
                    fa.loadFromFile(fname, src, "txt");
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    throw new FormProcessException(ex.getMessage());
                }
                String vdesc = (String)data.get((Object)VERSION_TRANSACTION_DESCRIPTION);
                if (vdesc.length() > this.FOUR_K_CHAR_LIMIT) {
                    vdesc = vdesc.substring(0, this.FOUR_K_CHAR_LIMIT);
                }
                Versions.tag((OID)doc.getOID(), (String)vdesc);
                doc.setLastModifiedLocal(doc.getLastModifiedDate());
                doc.save();
            }
            BrowseFileInfoPropertiesPane.this.displayPropertiesPane(state);
        }

        public void validate(FormSectionEvent e) throws FormProcessException {
            String desc;
            PageState state = e.getPageState();
            if (!this.m_submit.isSelected(state)) {
                return;
            }
            FormData data = e.getFormData();
            String fpath = (String)data.get((Object)VERSION_FILE_UPLOAD);
            if (fpath == null || fpath.length() == 0) {
                data.addError(VERSION_FILE_UPLOAD, "This parameter is required.");
            }
            String fname = DMUtils.extractFileName(fpath, state);
            int nameLength = 500;
            try {
                nameLength = fname.getBytes("UTF-8").length;
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException("No UTF-8 support: " + uee);
            }
            if (nameLength > 200) {
                data.addError(VERSION_FILE_UPLOAD, "This filename is too long. It must be fewer than 200 characters.");
            }
            if ((desc = (String)data.get((Object)VERSION_TRANSACTION_DESCRIPTION)) != null) {
                desc = desc.trim();
            }
            if (desc == null || desc.length() == 0) {
                data.addError(VERSION_TRANSACTION_DESCRIPTION, "This parameter is required.");
            }
        }
    }

    class FileEditForm
    extends Form
    implements FormValidationListener,
    FormProcessListener,
    FormInitListener {
        private static final String FILE_EDIT = "file-edit";
        private static final String FILE_EDIT_CATS = "file-edit-cats";
        private static final String FILE_EDIT_FNAME = "file-edit-name";
        private static final String FILE_EDIT_AUDIENCE = "file-edit-audience";
        private static final String FILE_EDIT_AUTHOR = "file-edit-author";
        private static final String FILE_EDIT_DESCRIPTION = "file-edit-description";
        private static final String FILE_EDIT_TITLE = "file-edit-title";
        private BrowseFileInfoPropertiesPane m_parent;
        private StringParameter m_FileAudience;
        private StringParameter m_FileName;
        private TrimmedStringParameter m_FileAuthor;
        private StringParameter m_FileDesc;
        private ArrayParameter m_FileCats;
        private StringParameter m_FileTitle;
        private FileUpload m_fileUpload;
        private static final String FILE_UPLOAD = "file-upload";
        private Submit m_submit;

        public FileEditForm(BrowseFileInfoPropertiesPane parent) {
            super(FILE_EDIT, (Container)new ColumnPanel(2));
            this.m_parent = parent;
            this.m_FileAudience = new StringParameter(FILE_EDIT_AUDIENCE);
            this.m_FileAuthor = new TrimmedStringParameter(FILE_EDIT_AUTHOR);
            this.m_FileDesc = new StringParameter(FILE_EDIT_DESCRIPTION);
            this.m_FileCats = new ArrayParameter(FILE_EDIT_CATS);
            this.add((Component)new Label(DMConstants.FILE_NAME_REQUIRED));
            this.m_FileName = new StringParameter(FILE_EDIT_FNAME);
            TextField fnameEntry = new TextField((ParameterModel)this.m_FileName);
            this.add((Component)fnameEntry);
            this.add((Component)new Label("Title"));
            this.m_FileTitle = new StringParameter(FILE_EDIT_TITLE);
            TextField fTitleEntry = new TextField((ParameterModel)this.m_FileTitle);
            this.add((Component)fTitleEntry);
            this.add((Component)new Label(DMConstants.FILE_INTENDED_AUDIENCE));
            SingleSelect audienceEntry = new SingleSelect((ParameterModel)this.m_FileAudience);
            try {
                audienceEntry.addPrintListener((PrintListener)new IntendedAudienceSelectPrinter());
            }
            catch (TooManyListenersException tmlex) {
                s_log.error((Object)tmlex.getMessage());
                tmlex.printStackTrace();
            }
            this.add((Component)audienceEntry);
            this.add((Component)new Label((PrintListener)new AuthorLabelPrinter()));
            TextField authorEntry = new TextField((ParameterModel)this.m_FileAuthor);
            authorEntry.addValidationListener((ParameterListener)new StringLengthValidationListener(200));
            this.add((Component)authorEntry);
            this.add((Component)new Label(DMConstants.FILE_CATEGORIES));
            MultipleSelect catSelect = new MultipleSelect(FILE_EDIT_CATS);
            catSelect.setSize(20);
            try {
                BigDecimalParameter fileIDParam = null;
                fileIDParam = BrowseFileInfoPropertiesPane.this.getFileIDParam();
                catSelect.addPrintListener((PrintListener)new CategoriesPrintListener(this.getContentSection(), fileIDParam));
            }
            catch (TooManyListenersException tmex) {
                throw new UncheckedWrapperException(tmex.getMessage());
            }
            this.add((Component)catSelect);
            this.add((Component)new Label(DMConstants.FILE_DESCRIPTION));
            TextArea descArea = new TextArea((ParameterModel)this.m_FileDesc);
            descArea.setRows(10);
            descArea.setCols(40);
            this.add((Component)descArea);
            this.m_submit = new Submit("file-edit-save");
            this.m_submit.setButtonLabel(DMConstants.FILE_SAVE);
            this.add((Component)new Label());
            SimpleContainer sc = new SimpleContainer();
            sc.add((Component)this.m_submit);
            sc.add((Component)new Submit(DMConstants.CANCEL));
            this.add((Component)sc);
            this.addInitListener(this);
            this.addProcessListener(this);
            this.addValidationListener(this);
        }

        public void init(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            FormData data = e.getFormData();
            BigDecimal id = (BigDecimal)state.getValue((ParameterModel)BrowseFileInfoPropertiesPane.this.docIDParam);
            Document doc = DMUtils.getFile(id);
            ArrayList<String> assignedCats = new ArrayList<String>();
            CategoryCollection cats = doc.getCategoryCollection();
            while (cats.next()) {
                Category cat = cats.getCategory();
                String catID = cat.getID().toString();
                assignedCats.add(catID);
                s_log.debug((Object)("init: " + catID));
            }
            data.put((Object)FILE_EDIT_FNAME, (Object)URLDecoder.decode(doc.getName()));
            data.put((Object)FILE_EDIT_TITLE, (Object)doc.getTitle());
            data.put((Object)FILE_EDIT_AUTHOR, (Object)doc.getAuthor());
            data.put((Object)FILE_EDIT_DESCRIPTION, (Object)doc.getDescription());
            data.put((Object)FILE_EDIT_CATS, (Object)assignedCats.toArray());
            this.initAudienceFormData(data, doc);
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            if (this.m_submit.isSelected(state)) {
                this.processEdit(e);
            }
            BrowseFileInfoPropertiesPane.this.displayPropertiesPane(state);
        }

        private void processEdit(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            FormData data = e.getFormData();
            Document doc = DMUtils.getFile((BigDecimal)state.getValue((ParameterModel)BrowseFileInfoPropertiesPane.this.docIDParam));
            this.setDocumentAttributes(data, doc);
            doc.setCategories((String[])data.get((Object)FILE_EDIT_CATS));
            doc.setLastModifiedLocal(new Date());
            doc.save();
            this.setDocumentPermission(data, doc);
        }

        private void setDocumentAttributes(FormData data, Document doc) {
            String ftitle = (String)data.get((Object)FILE_EDIT_TITLE);
            String fname = (String)data.get((Object)FILE_EDIT_FNAME);
            doc.setTitle(ftitle != null && ftitle.length() > 0 ? ftitle : fname);
            fname = fname.replace('\"', ' ');
            doc.setName(URLEncoder.encode(fname));
            String fauthor = (String)data.get((Object)FILE_EDIT_AUTHOR);
            String fdesc = (String)data.get((Object)FILE_EDIT_DESCRIPTION);
            if (fauthor != null) {
                doc.setAuthor(fauthor);
            }
            doc.setDescription(fdesc);
        }

        protected String getUploadFileName(FormSectionEvent e) {
            FormData data = e.getFormData();
            String filename = (String)data.get((Object)FILE_UPLOAD);
            return DMUtils.extractFileName(filename, e.getPageState());
        }

        public void validate(FormSectionEvent event) throws FormProcessException {
            PageState state = event.getPageState();
            if (this.m_submit.isSelected(state)) {
                this.validateEdit(event);
            }
        }

        private void validateEdit(FormSectionEvent event) throws FormProcessException {
            String title;
            PageState state = event.getPageState();
            FormData data = event.getFormData();
            String fname = (String)data.get((Object)FILE_EDIT_FNAME);
            if (fname == null || fname.trim().length() == 0) {
                data.addError(FILE_EDIT_FNAME, "This parameter is required");
            }
            if ((title = (String)data.get((Object)FILE_EDIT_TITLE)) == null || title.length() == 0) {
                data.addError(FILE_EDIT_TITLE, "This parameter is required.");
            } else if (title.length() > 200) {
                data.addError(FILE_EDIT_TITLE, "This title is too long. It must be fewer than 200 characters.");
            }
        }

        private void initAudienceFormData(FormData data, Document doc) {
            ObjectPermissionCollection opc = PermissionService.getDirectGrantedPermissions((OID)doc.getOID());
            long numPermissions = opc.size();
            if (numPermissions > 1L) {
                s_log.error((Object)"there should only be 1 direct permission for a document");
            }
            if (numPermissions == 0L) {
                data.put((Object)FILE_EDIT_AUDIENCE, (Object)"workspace");
                opc.close();
                return;
            }
            boolean isPublic = false;
            while (opc.next()) {
                if (opc.getGranteeID().intValue() != -200) continue;
                isPublic = true;
            }
            opc.close();
            if (isPublic) {
                data.put((Object)FILE_EDIT_AUDIENCE, (Object)"public");
            } else {
                data.put((Object)FILE_EDIT_AUDIENCE, (Object)"internal");
            }
        }

        private void setDocumentPermission(FormData data, Document doc) throws FormProcessException {
            final String intendedAudience = (String)data.get((Object)FILE_EDIT_AUDIENCE);
            if (intendedAudience == null) {
                throw new FormProcessException("Intended Audience cannot be null");
            }
            final PermissionDescriptor publicDescriptor = new PermissionDescriptor(PrivilegeDescriptor.READ, doc.getOID(), new OID("com.arsdigita.kernel.User", -200));
            final PermissionDescriptor internalDescriptor = new PermissionDescriptor(PrivilegeDescriptor.READ, doc.getOID(), new OID("com.arsdigita.kernel.Group", DocMgr.getConfig().getInternalGroupID()));
            new KernelExcursion(){

                protected void excurse() {
                    this.setParty(Kernel.getSystemParty());
                    if ("public".equals(intendedAudience)) {
                        PermissionService.grantPermission((PermissionDescriptor)publicDescriptor);
                        PermissionService.revokePermission((PermissionDescriptor)internalDescriptor);
                    } else if ("internal".equals(intendedAudience)) {
                        PermissionService.revokePermission((PermissionDescriptor)publicDescriptor);
                        PermissionService.grantPermission((PermissionDescriptor)internalDescriptor);
                    } else {
                        PermissionService.revokePermission((PermissionDescriptor)publicDescriptor);
                        PermissionService.revokePermission((PermissionDescriptor)internalDescriptor);
                    }
                }
            }.run();
        }

        private ContentSection getContentSection() {
            ContentSectionCollection csl = ContentSection.getAllSections();
            csl.addEqualsFilter("label", (Object)DocMgr.getConfig().getContentSection());
            if (!csl.next()) {
                csl.close();
                return null;
            }
            ContentSection docsContentSection = csl.getContentSection();
            csl.close();
            return docsContentSection;
        }

        protected class IntendedAudienceSelectPrinter
        implements PrintListener {
            public void prepare(PrintEvent e) {
                SingleSelect select = (SingleSelect)e.getTarget();
                select.addOption(new Option("workspace", Web.getContext().getApplication().getParentApplication() == null ? Web.getContext().getApplication().getDisplayName() : Web.getContext().getApplication().getParentApplication().getDisplayName() + " members"));
                select.addOption(new Option("internal", (Component)new Label(DMConstants.FILE_INTENDED_AUDIENCE_INTERNAL)));
                select.addOption(new Option("public", (Component)new Label(DMConstants.FILE_INTENDED_AUDIENCE_PUBLIC)));
            }
        }

        protected class AuthorLabelPrinter
        implements PrintListener {
            public void prepare(PrintEvent e) {
                Label label = (Label)e.getTarget();
                PageState pageState = e.getPageState();
                String name = Web.getContext().getUser().getName();
                label.setLabel("Author: (if not " + name + ")");
            }
        }
    }

    class FilePropertiesPanel
    extends SimpleComponent {
        BrowseFileInfoPropertiesPane m_parent;

        public FilePropertiesPanel(BrowseFileInfoPropertiesPane parent) {
            this.m_parent = parent;
        }

        public void generateXML(PageState state, Element parent) {
            Element element = parent.newChildElement("docs:file-info", "http://www.redhat.com/docs/1.0");
            BigDecimal docID = (BigDecimal)state.getValue((ParameterModel)BrowseFileInfoPropertiesPane.this.docIDParam);
            if (docID != null) {
                try {
                    Document doc = new Document(docID);
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("doc raw content: " + doc.getSearchRawContent()));
                    }
                    Element titleElement = element.newChildElement("docs:title", "http://www.redhat.com/docs/1.0");
                    titleElement.setText(doc.getTitle());
                    Element nameElement = element.newChildElement("docs:name", "http://www.redhat.com/docs/1.0");
                    nameElement.setText(URLDecoder.decode(doc.getName()));
                    Element descriptionElement = element.newChildElement("docs:description", "http://www.redhat.com/docs/1.0");
                    String description = doc.getDescription();
                    if (description != null) {
                        descriptionElement.setText(description);
                    }
                    Element sizeElement = element.newChildElement("docs:size", "http://www.redhat.com/docs/1.0");
                    sizeElement.setText(DMUtils.FileSize.formatFileSize(doc.getSize()));
                    Element typeElement = element.newChildElement("docs:type", "http://www.redhat.com/docs/1.0");
                    typeElement.setText(doc.getPrettyMimeType());
                    Element lastModifiedElement = element.newChildElement("docs:last-modified", "http://www.redhat.com/docs/1.0");
                    lastModifiedElement.setText(null != doc.getLastModifiedDate() ? DMUtils.DateFormat.format(doc.getLastModifiedDate()) : "");
                    Element revisionElement = element.newChildElement("docs:revision", "http://www.redhat.com/docs/1.0");
                    TransactionCollection tc = Versions.getTaggedTransactions((OID)doc.getOID());
                    long numRevs = tc.size();
                    revisionElement.setText(numRevs + "");
                    Element authorElement = element.newChildElement("docs:author", "http://www.redhat.com/docs/1.0");
                    authorElement.setText(doc.getImpliedAuthor());
                    Element uriElement = element.newChildElement("docs:uri", "http://www.redhat.com/docs/1.0");
                    uriElement.setText(this.makeFileURL(doc, state));
                    Element catsElement = element.newChildElement("docs:categories", "http://www.redhat.com/docs/1.0");
                    CategoryCollection cats = doc.getCategoryCollection();
                    while (cats.next()) {
                        Category cat = cats.getCategory();
                        Element catElement = catsElement.newChildElement("docs:category", "http://www.redhat.com/docs/1.0");
                        catElement.addAttribute("id", cat.getID().toString());
                        catElement.addAttribute("name", cat.getName());
                    }
                }
                catch (DataObjectNotFoundException exc) {
                    Element notfoundElement = element.newChildElement("docs:notfound", "http://www.redhat.com/docs/1.0");
                }
            } else {
                Element notfoundElement = element.newChildElement("docs:notfound", "http://www.redhat.com/docs/1.0");
            }
        }

        private String makeFileURL(Document doc, PageState state) {
            HttpServletRequest req = state.getRequest();
            ParameterMap params = new ParameterMap();
            params.setParameter("d_id", (Object)doc.getID());
            return URL.here((HttpServletRequest)req, (String)"/download/", (ParameterMap)params).toString();
        }
    }

    class BackCancelActionLink
    extends ActionLink {
        public BackCancelActionLink(String label) {
            super(label);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BrowseFileInfoPropertiesPane.this.m_parent.displayFolderContentPanel(e.getPageState());
                }
            });
        }
    }
}

