/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.docmgr.ui.BrowseFileRevisionsTableModelBuilder;
import com.arsdigita.cms.docmgr.ui.BrowsePane;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class BrowseFileRevisionsTable
extends Table
implements TableActionListener,
DMConstants {
    protected static final Logger s_log = Logger.getLogger(BrowseFileRevisionsTable.class);
    public static final String[] s_tableHeaders = new String[]{"", "Author", "Date", "Comments", ""};
    private final BrowsePane m_parent;
    private Page m_page;

    public BrowseFileRevisionsTable(BrowsePane parent) {
        super((TableModelBuilder)new BrowseFileRevisionsTableModelBuilder(parent), (Object[])s_tableHeaders);
        this.m_parent = parent;
        this.setClassAttr("AlternateTable");
        this.setWidth("100%");
        this.getColumn(4).setCellRenderer((TableCellRenderer)new LinkRenderer());
        this.addTableActionListener(this);
    }

    public void cellSelected(TableActionEvent e) {
    }

    public void headSelected(TableActionEvent e) {
        throw new UnsupportedOperationException();
    }

    public void register(Page p) {
        this.m_page = p;
        super.register(p);
    }

    public void setDocID(PageState ps, BigDecimal docID) {
        Document doc = new Document(docID);
        Label title = this.m_page.getTitle();
        title.setLabel(doc.getTitle(), ps);
        BrowseFileRevisionsTableModelBuilder builder = (BrowseFileRevisionsTableModelBuilder)this.getModelBuilder();
        builder.setDocument(doc);
    }

    private final class LinkRenderer
    implements TableCellRenderer {
        private LinkRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            String keyTxt = String.valueOf(key);
            int index = keyTxt.indexOf(46);
            if (value != null && index > -1) {
                Document doc = new Document(new BigDecimal(keyTxt.substring(0, index)));
                Link link = new Link("Download", "download/");
                link.setVar("d_id", doc.getID().toString());
                link.setVar("transID", keyTxt.substring(index + 1));
                link.setClassAttr("downloadLink");
                return link;
            }
            return new Label();
        }
    }
}

