/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.TabbedPane;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.tree.TreeCellRenderer;
import com.arsdigita.bebop.tree.TreeModel;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.docmgr.DocFolder;
import com.arsdigita.cms.docmgr.DocLink;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.docmgr.ui.BrowseFileInfoPropertiesPane;
import com.arsdigita.cms.docmgr.ui.BrowseFileRevisionsTable;
import com.arsdigita.cms.docmgr.ui.BrowseFolderEdit;
import com.arsdigita.cms.docmgr.ui.CreateDocLinkPane;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.cms.docmgr.ui.DMUtils;
import com.arsdigita.cms.docmgr.ui.DestinationFolderForm;
import com.arsdigita.cms.docmgr.ui.FileEditForm;
import com.arsdigita.cms.docmgr.ui.FolderContentsTableForm;
import com.arsdigita.cms.docmgr.ui.FolderCreateForm;
import com.arsdigita.cms.docmgr.ui.FolderNamePrintListener;
import com.arsdigita.cms.docmgr.ui.tree.DocFolderAppCellRenderer;
import com.arsdigita.cms.docmgr.ui.tree.RepositoryTreeModel;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.web.Application;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

class BrowsePane
extends ModalContainer
implements DMConstants,
ChangeListener,
RequestListener,
ActionListener {
    private static final Logger s_log = Logger.getLogger(BrowsePane.class);
    public static final String PARAM_ADD_DOC_TO_FID = "add_doc_to_fid";
    public static final String PARAM_ADD_FOLDER_TO_FID = "add_folder_to_fid";
    private Component m_folderContent;
    private FolderContentsTableForm m_folderContentsTableForm;
    private Component m_destinationFolderPanel;
    private Component m_newFileForm;
    private Component m_newFolderForm;
    private Component m_newDocLinkForm;
    private Component m_editDocLinkForm;
    private Component m_errorMsgPanel;
    private Component m_fileInfoComponent;
    private Component m_folderEditComponent;
    private Component m_fileVersionsComponent;
    private BrowseFileInfoPropertiesPane m_fileInfoPane;
    private BrowseFileRevisionsTable m_fileVersionsTable;
    private DestinationFolderForm m_destinationFolderForm;
    private ErrorMessageLabel m_errorMsgLabel;
    private Container m_mainBrowseContainer;
    private CreateDocLinkPane m_docLinkPane;
    private ActionLink m_newFileLink;
    private ActionLink m_createDoclinkLink;
    private ActionLink m_newFolderLink;
    private TabbedPane m_mainTabPane;
    protected Tree m_tree;
    private RequestLocal m_createdFolderID = new RequestLocal();
    private BigDecimalParameter m_rootFolderIdParam = new BigDecimalParameter("r_id");
    private BigDecimalParameter m_selFolderIdParam = new BigDecimalParameter("f_id");
    private BigDecimalParameter m_fileIdParam = new BigDecimalParameter("d_id");
    private StringParameter m_rootAddDocParam = new StringParameter("root_add_doc");
    private BigDecimalParameter m_openFolderIdParam = new BigDecimalParameter("of_id");
    private BigDecimalParameter m_folderAddDocParam = new BigDecimalParameter("folder_add_doc");

    public BrowsePane() {
        this.m_mainTabPane = new TabbedPane();
        this.m_mainBrowseContainer = new BoxPanel();
        this.m_mainTabPane.addTab((Component)WS_BROWSE_TITLE, (Component)this.m_mainBrowseContainer);
        this.m_mainBrowseContainer.setClassAttr("sidebarNavPanel");
        BoxPanel leftSide = new BoxPanel();
        leftSide.setClassAttr("navbar");
        this.m_tree = new Tree((TreeModel)new RepositoryTreeModel());
        this.m_tree.setCellRenderer((TreeCellRenderer)new DocFolderAppCellRenderer());
        this.m_tree.addActionListener((ActionListener)this);
        leftSide.add((Component)this.m_tree);
        this.m_mainBrowseContainer.add((Component)leftSide);
        SegmentedPanel rightSide = new SegmentedPanel();
        rightSide.setClassAttr("main");
        this.m_folderContent = this.makeContentPanel(rightSide);
        this.m_mainBrowseContainer.add((Component)rightSide);
        this.add((Component)this.m_mainTabPane);
        this.m_newFileForm = this.makeFileUploadForm();
        this.add(this.m_newFileForm);
        this.m_newDocLinkForm = this.makeDocLinkCreateForm();
        this.add(this.m_newDocLinkForm);
        this.m_editDocLinkForm = this.makeDocLinkEditForm();
        this.add(this.m_editDocLinkForm);
        this.m_newFolderForm = this.makeFolderCreateForm();
        this.add(this.m_newFolderForm);
        this.m_destinationFolderPanel = this.makeExpandFolderPanel();
        this.add(this.m_destinationFolderPanel);
        this.m_errorMsgPanel = this.makeErrorMsgPanel();
        this.add(this.m_errorMsgPanel);
        this.m_fileInfoComponent = this.makeFilePropPanel();
        this.add(this.m_fileInfoComponent);
        this.m_folderEditComponent = this.makeFolderEditForm();
        this.add(this.m_folderEditComponent);
        this.m_fileVersionsComponent = this.makeFileVersionsPanel();
        this.add(this.m_fileVersionsComponent);
    }

    public void register(Page p) {
        p.addGlobalStateParam((ParameterModel)this.m_rootFolderIdParam);
        p.addGlobalStateParam((ParameterModel)this.m_selFolderIdParam);
        p.addGlobalStateParam((ParameterModel)this.m_rootAddDocParam);
        p.addGlobalStateParam((ParameterModel)this.m_fileIdParam);
        p.addGlobalStateParam((ParameterModel)this.m_openFolderIdParam);
        p.addGlobalStateParam((ParameterModel)this.m_folderAddDocParam);
        p.addRequestListener((RequestListener)this);
        super.register(p);
    }

    public void pageRequested(RequestEvent e) {
        String key;
        PageState state = e.getPageState();
        BigDecimal fid = (BigDecimal)state.getValue((ParameterModel)this.m_fileIdParam);
        boolean display = false;
        BigDecimal openFolder = (BigDecimal)state.getValue((ParameterModel)this.m_openFolderIdParam);
        HttpServletRequest request = state.getRequest();
        BigDecimal addDocToFolderID = null;
        String addDocToFolderIDTxt = request.getParameter(PARAM_ADD_DOC_TO_FID);
        if (addDocToFolderIDTxt != null) {
            try {
                addDocToFolderID = new BigDecimal(addDocToFolderIDTxt);
                if (openFolder == null) {
                    openFolder = addDocToFolderID;
                }
            }
            catch (Throwable t) {
                s_log.warn((Object)("url param:add_doc_to_fid doesn't contain an integer (" + addDocToFolderIDTxt + ")"));
            }
        }
        BigDecimal addFolderToFolderID = null;
        String addFolderToFolderIDTxt = request.getParameter(PARAM_ADD_FOLDER_TO_FID);
        if (addFolderToFolderIDTxt != null) {
            try {
                addFolderToFolderID = new BigDecimal(addFolderToFolderIDTxt);
                if (openFolder == null) {
                    openFolder = addFolderToFolderID;
                }
            }
            catch (Throwable t) {
                s_log.warn((Object)("url param:add_folder_to_fid doesn't contain an integer (" + addFolderToFolderIDTxt + ")"));
            }
        }
        if (openFolder != null) {
            this.m_tree.setSelectedKey(state, (Object)openFolder.toString());
            DocFolder parent = new DocFolder(openFolder);
            while (!parent.isRoot()) {
                parent = (DocFolder)parent.getParent();
                this.m_tree.expand(parent.getID().toString(), state);
            }
        }
        if ((key = (String)this.m_tree.getSelectedKey(state)) == null) {
            key = DMUtils.getRootFolder(state).getID().toString();
            this.m_tree.setSelectedKey(state, (Object)key);
            display = true;
        }
        User user = Web.getContext().getUser();
        Application app = Web.getContext().getApplication();
        if (!PermissionService.checkPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.CREATE, (ACSObject)app, (Party)user))) {
            this.m_newFileLink.setVisible(state, false);
            this.m_newFolderLink.setVisible(state, false);
            this.m_createDoclinkLink.setVisible(state, false);
        }
        if (fid != null) {
            try {
                Document file = new Document(fid);
                DocFolder parent = (DocFolder)((ContentBundle)file.getParent()).getParent();
                key = parent.getID().toString();
                while (!parent.isRoot()) {
                    parent = (DocFolder)parent.getParent();
                    this.m_tree.expand(parent.getID().toString(), state);
                }
                this.displayFilePropPanel(state, fid);
                display = false;
            }
            catch (DataObjectNotFoundException exc) {
                s_log.error((Object)"document not found", (Throwable)exc);
            }
            this.m_tree.setSelectedKey(state, (Object)key);
            state.setValue((ParameterModel)this.m_fileIdParam, null);
        }
        String dlIDtxt = request.getParameter("dl_id");
        BigDecimal dlID = null;
        if (dlIDtxt != null) {
            try {
                dlID = new BigDecimal(dlIDtxt);
            }
            catch (Exception exc) {
                s_log.error((Object)"parse docLinkID", (Throwable)exc);
            }
        }
        if (dlID != null) {
            try {
                DocLink docLink = new DocLink(dlID);
                DocFolder parent = (DocFolder)((ContentBundle)docLink.getParent()).getParent();
                key = parent.getID().toString();
                while (!parent.isRoot()) {
                    parent = (DocFolder)parent.getParent();
                    this.m_tree.expand(parent.getID().toString(), state);
                }
                this.displayDocLinkEditForm(state, dlID);
                display = false;
            }
            catch (DataObjectNotFoundException exc) {
                s_log.error((Object)"docLink not found", (Throwable)exc);
            }
            this.m_tree.setSelectedKey(state, (Object)key);
            state.setValue((ParameterModel)this.m_fileIdParam, null);
        }
        this.m_tree.expand(key, state);
        if (display) {
            if ("t".equalsIgnoreCase((String)state.getValue((ParameterModel)this.m_rootAddDocParam))) {
                this.displayFileUpload(state);
            } else if (request.getParameter("root_add_doc_link") != null) {
                state.setValue((ParameterModel)this.m_docLinkPane.getEditDoclinkIDParam(), null);
                this.displayLinkCreate(state);
            } else {
                BigDecimal folderID = (BigDecimal)state.getValue((ParameterModel)this.m_folderAddDocParam);
                if (folderID != null) {
                    this.m_tree.setSelectedKey(state, (Object)folderID.toString());
                    this.displayFileUpload(state);
                } else {
                    this.displayFolderContentPanel(state);
                }
            }
        } else if (addDocToFolderID != null) {
            this.displayFileUpload(state);
        } else if (addFolderToFolderID != null) {
            this.displayFolderCreate(state);
        }
    }

    public void generateXML(PageState state, Element parent) {
        super.generateXML(state, parent);
        Object createdFolderID = this.m_createdFolderID.get(state);
        if (createdFolderID != null) {
            parent.addAttribute("createdFolderID", createdFolderID.toString());
        }
    }

    public void setCreatedFolderID(PageState state, BigDecimal id) {
        this.m_createdFolderID.set(state, (Object)id);
    }

    public BigDecimal getFolderID(PageState state) {
        return new BigDecimal((String)this.m_tree.getSelectedKey(state));
    }

    public void stateChanged(ChangeEvent e) {
        PageState state = e.getPageState();
        this.displayFolderContentPanel(state);
    }

    public void actionPerformed(ActionEvent e) {
        PageState state = e.getPageState();
        state.setValue((ParameterModel)this.m_folderContentsTableForm.getPageNoParameter(), (Object)new Integer(0));
        this.displayFolderContentPanel(state);
    }

    private Component makeContentPanel(SegmentedPanel main) {
        Label folder_info_header = new Label(new GlobalizedMessage("ui.folder.content.header", "com.arsdigita.cms.docmgr.ui.DMResources"));
        folder_info_header.addPrintListener((PrintListener)new FolderNamePrintListener(this.m_tree));
        this.m_newFileLink = new ActionLink((Component)new Label(FOLDER_NEW_FILE_LINK));
        this.m_newFileLink.setClassAttr("actionLink");
        this.m_createDoclinkLink = new ActionLink((Component)new Label(FOLDER_NEW_DOCLINK_LINK));
        this.m_createDoclinkLink.setClassAttr("actionLink");
        this.m_newFolderLink = new ActionLink((Component)new Label(FOLDER_NEW_FOLDER_LINK));
        this.m_newFolderLink.setClassAttr("actionLink");
        this.m_newFileLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowsePane.this.displayFileUpload(e.getPageState());
            }
        });
        this.m_createDoclinkLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                state.setValue((ParameterModel)BrowsePane.this.m_docLinkPane.getEditDoclinkIDParam(), null);
                BrowsePane.this.displayLinkCreate(state);
            }
        });
        this.m_newFolderLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowsePane.this.displayFolderCreate(e.getPageState());
            }
        });
        GridPanel folderGrid = new GridPanel(1);
        SimpleContainer pane = new SimpleContainer();
        pane.add((Component)this.m_newFileLink);
        pane.add((Component)new Label("        "));
        pane.add((Component)this.m_createDoclinkLink);
        pane.add((Component)new Label("        "));
        pane.add((Component)this.m_newFolderLink);
        folderGrid.add((Component)pane, 36);
        this.m_folderContentsTableForm = new FolderContentsTableForm(this, this.m_tree);
        folderGrid.add((Component)this.m_folderContentsTableForm, 33);
        return main.addSegment((Component)folder_info_header, (Component)folderGrid);
    }

    private Component makeFileUploadForm() {
        Label fileUploadFormHeaderLabel = new Label(new GlobalizedMessage("ui.file.upload.header", "com.arsdigita.cms.docmgr.ui.DMResources"));
        fileUploadFormHeaderLabel.addPrintListener((PrintListener)new FolderNamePrintListener(this.m_tree));
        TabbedPane tabbedPane = new TabbedPane();
        BoxPanel browseContainer = new BoxPanel();
        tabbedPane.addTab((Component)WS_BROWSE_TITLE, (Component)browseContainer);
        browseContainer.setClassAttr("sidebarNavPanel");
        BoxPanel leftSide = new BoxPanel();
        leftSide.setClassAttr("navbar");
        leftSide.add((Component)this.m_tree);
        browseContainer.add((Component)leftSide);
        SegmentedPanel rightSide = new SegmentedPanel();
        rightSide.setClassAttr("main");
        rightSide.addSegment((Component)fileUploadFormHeaderLabel, (Component)new FileEditForm((Component)this, true, this.m_tree));
        browseContainer.add((Component)rightSide);
        return tabbedPane;
    }

    private Component makeFolderCreateForm() {
        Label folderCreateFormHeaderLabel = new Label(new GlobalizedMessage("ui.folder.create.header", "com.arsdigita.cms.docmgr.ui.DMResources"));
        folderCreateFormHeaderLabel.addPrintListener((PrintListener)new FolderNamePrintListener(this.m_tree));
        TabbedPane tabbedPane = new TabbedPane();
        BoxPanel browseContainer = new BoxPanel();
        tabbedPane.addTab((Component)WS_BROWSE_TITLE, (Component)browseContainer);
        browseContainer.setClassAttr("sidebarNavPanel");
        BoxPanel leftSide = new BoxPanel();
        leftSide.setClassAttr("navbar");
        leftSide.add((Component)this.m_tree);
        browseContainer.add((Component)leftSide);
        SegmentedPanel rightSide = new SegmentedPanel();
        rightSide.setClassAttr("main");
        rightSide.addSegment((Component)folderCreateFormHeaderLabel, (Component)new FolderCreateForm(this, this.m_tree));
        browseContainer.add((Component)rightSide);
        return tabbedPane;
    }

    private Component makeDocLinkCreateForm() {
        TabbedPane docLinkTabPane = new TabbedPane();
        GridPanel gridPanel = new GridPanel(1);
        Label docLinkCreateFormHeaderLabel = new Label(new GlobalizedMessage("ui.link.create.header", "com.arsdigita.cms.docmgr.ui.DMResources"));
        docLinkCreateFormHeaderLabel.addPrintListener((PrintListener)new FolderNamePrintListener(this.m_tree));
        gridPanel.add((Component)docLinkCreateFormHeaderLabel);
        this.m_docLinkPane = new CreateDocLinkPane((Component)this, this.m_tree);
        gridPanel.add((Component)this.m_docLinkPane);
        BoxPanel browseContainer = new BoxPanel();
        docLinkTabPane.addTab((Component)WS_BROWSE_TITLE, (Component)browseContainer);
        browseContainer.setClassAttr("sidebarNavPanel");
        BoxPanel leftSide = new BoxPanel();
        leftSide.setClassAttr("navbar");
        leftSide.add((Component)this.m_tree);
        browseContainer.add((Component)leftSide);
        SegmentedPanel rightSide = new SegmentedPanel();
        rightSide.setClassAttr("main");
        rightSide.addSegment((Component)new Label("Doc Link"), (Component)gridPanel);
        browseContainer.add((Component)rightSide);
        return docLinkTabPane;
    }

    private Component makeDocLinkEditForm() {
        TabbedPane docLinkTabPane = new TabbedPane();
        GridPanel gridPanel = new GridPanel(1);
        Label docLinkCreateFormHeaderLabel = new Label("Edit Link in");
        docLinkCreateFormHeaderLabel.addPrintListener((PrintListener)new FolderNamePrintListener(this.m_tree));
        gridPanel.add((Component)docLinkCreateFormHeaderLabel);
        this.m_docLinkPane = new CreateDocLinkPane((Component)this, this.m_tree);
        gridPanel.add((Component)this.m_docLinkPane);
        BoxPanel browseContainer = new BoxPanel();
        docLinkTabPane.addTab((Component)WS_BROWSE_TITLE, (Component)browseContainer);
        browseContainer.setClassAttr("sidebarNavPanel");
        BoxPanel leftSide = new BoxPanel();
        leftSide.setClassAttr("navbar");
        leftSide.add((Component)this.m_tree);
        browseContainer.add((Component)leftSide);
        SegmentedPanel rightSide = new SegmentedPanel();
        rightSide.setClassAttr("main");
        rightSide.addSegment((Component)new Label("Edit New Link"), (Component)gridPanel);
        browseContainer.add((Component)rightSide);
        return docLinkTabPane;
    }

    private Component makeExpandFolderPanel() {
        this.m_destinationFolderForm = new DestinationFolderForm(this);
        TabbedPane tabbedPane = new TabbedPane();
        BoxPanel browseContainer = new BoxPanel();
        tabbedPane.addTab((Component)WS_BROWSE_TITLE, (Component)browseContainer);
        browseContainer.setClassAttr("sidebarNavPanel");
        BoxPanel leftSide = new BoxPanel();
        leftSide.setClassAttr("navbar");
        leftSide.add((Component)this.m_tree);
        browseContainer.add((Component)leftSide);
        SegmentedPanel rightSide = new SegmentedPanel();
        rightSide.setClassAttr("main");
        rightSide.addSegment((Component)DESTINATION_FOLDER_PANEL_HEADER, (Component)this.m_destinationFolderForm);
        browseContainer.add((Component)rightSide);
        return tabbedPane;
    }

    private Component makeErrorMsgPanel() {
        ColumnPanel c = new ColumnPanel(1);
        this.m_errorMsgLabel = new ErrorMessageLabel();
        c.add((Component)this.m_errorMsgLabel);
        ActionLink link = new ActionLink((Component)ACTION_ERROR_CONTINUE);
        link.setClassAttr("actionLink");
        link.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowsePane.this.displayFolderContentPanel(e.getPageState());
            }
        });
        c.add((Component)link);
        return c;
    }

    private Component makeFilePropPanel() {
        this.m_fileInfoPane = new BrowseFileInfoPropertiesPane(this);
        TabbedPane filePropTabPane = new TabbedPane();
        BoxPanel filePropBrowseContainer = new BoxPanel();
        filePropTabPane.addTab((Component)WS_BROWSE_TITLE, (Component)filePropBrowseContainer);
        filePropBrowseContainer.setClassAttr("sidebarNavPanel");
        BoxPanel leftSide = new BoxPanel();
        leftSide.setClassAttr("navbar");
        leftSide.add((Component)this.m_tree);
        filePropBrowseContainer.add((Component)leftSide);
        SegmentedPanel rightSide = new SegmentedPanel();
        rightSide.setClassAttr("main");
        rightSide.addSegment((Component)new Label("Document"), (Component)this.m_fileInfoPane);
        filePropBrowseContainer.add((Component)rightSide);
        return filePropTabPane;
    }

    private Component makeFolderEditForm() {
        TabbedPane tabbedPane = new TabbedPane();
        BoxPanel browseContainer = new BoxPanel();
        tabbedPane.addTab((Component)WS_BROWSE_TITLE, (Component)browseContainer);
        browseContainer.setClassAttr("sidebarNavPanel");
        BoxPanel leftSide = new BoxPanel();
        leftSide.setClassAttr("navbar");
        leftSide.add((Component)this.m_tree);
        browseContainer.add((Component)leftSide);
        SegmentedPanel rightSide = new SegmentedPanel();
        rightSide.setClassAttr("main");
        rightSide.addSegment((Component)new Label("Folder edit"), (Component)new BrowseFolderEdit(this, this.m_selFolderIdParam));
        browseContainer.add((Component)rightSide);
        return tabbedPane;
    }

    private Component makeFileVersionsPanel() {
        this.m_fileVersionsTable = new BrowseFileRevisionsTable(this);
        TabbedPane tabbedPane = new TabbedPane();
        BoxPanel browseContainer = new BoxPanel();
        tabbedPane.addTab((Component)WS_BROWSE_TITLE, (Component)browseContainer);
        browseContainer.setClassAttr("sidebarNavPanel");
        BoxPanel leftSide = new BoxPanel();
        leftSide.setClassAttr("navbar");
        leftSide.add((Component)this.m_tree);
        browseContainer.add((Component)leftSide);
        SegmentedPanel rightSide = new SegmentedPanel();
        rightSide.setClassAttr("main");
        rightSide.addSegment((Component)new Label("File revisions"), (Component)this.m_fileVersionsTable);
        browseContainer.add((Component)rightSide);
        return tabbedPane;
    }

    public void displayFileUpload(PageState state) {
        this.setVisibleComponent(state, this.m_newFileForm);
    }

    public void displayFolderCreate(PageState state) {
        this.setVisibleComponent(state, this.m_newFolderForm);
    }

    public void displayLinkCreate(PageState state) {
        this.setVisibleComponent(state, this.m_newDocLinkForm);
    }

    public void displayLinkEdit(PageState state) {
        this.setVisibleComponent(state, this.m_editDocLinkForm);
    }

    public void displayFolderContentPanel(PageState state) {
        this.setVisibleComponent(state, (Component)this.m_mainTabPane);
    }

    public void displayDestinationFolderPanel(PageState state, Object[] resourceList, boolean isMove) {
        this.setVisibleComponent(state, this.m_destinationFolderPanel);
        this.m_destinationFolderForm.setResourceList(state, resourceList);
        if (isMove) {
            this.m_destinationFolderForm.setMove(state);
        } else {
            this.m_destinationFolderForm.setCopy(state);
        }
    }

    public void displayErrorMsgPanel(PageState state, String action, ArrayList list) {
        this.m_errorMsgLabel.setMessages(state, action, list);
        this.setVisibleComponent(state, this.m_errorMsgPanel);
    }

    public void displayFilePropPanel(PageState state, BigDecimal docID) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("displayFilePropPanel, docID=" + docID.toString()));
        }
        this.m_fileInfoPane.setDocID(state, docID);
        this.m_fileInfoPane.displayPropertiesPane(state);
        this.setVisibleComponent(state, this.m_fileInfoComponent);
    }

    public void displayFilePropEditForm(PageState state, BigDecimal docID) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("displayFilePropEditForm, docID=" + docID.toString()));
        }
        this.m_fileInfoPane.setDocID(state, docID);
        this.m_fileInfoPane.displayEditForm(state);
        this.setVisibleComponent(state, this.m_fileInfoComponent);
    }

    public void displayDocLinkEditForm(PageState state, BigDecimal doclinkID) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("displayDocLinkEditForm, doclinkID=" + doclinkID.toString()));
        }
        state.setValue((ParameterModel)this.m_docLinkPane.getEditDoclinkIDParam(), (Object)doclinkID);
        this.displayLinkEdit(state);
    }

    public void displayFilePropSendColleagueForm(PageState state, BigDecimal docID) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("displayFilePropSendColleagueForm, docID=" + docID.toString()));
        }
        this.m_fileInfoPane.setDocID(state, docID);
        this.m_fileInfoPane.displaySendColleagueForm(state);
        this.setVisibleComponent(state, this.m_fileInfoComponent);
    }

    public void displayFolderEditForm(PageState state, BigDecimal folderID) {
        state.setValue((ParameterModel)this.m_selFolderIdParam, (Object)folderID);
        this.setVisibleComponent(state, this.m_folderEditComponent);
    }

    public void displayFileVersions(PageState state, BigDecimal docID) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("displayFileVersions, docID=" + docID));
        }
        this.m_fileVersionsTable.setDocID(state, docID);
        this.setVisibleComponent(state, this.m_fileVersionsComponent);
    }

    public BigDecimalParameter getFileIDparam() {
        return this.m_fileIdParam;
    }

    private static class ErrorMessageLabel
    extends SimpleComponent
    implements DMConstants {
        private RequestLocal m_msgs = new RequestLocal();
        private RequestLocal m_action = new RequestLocal();

        public void setMessages(PageState state, String action, ArrayList msgs) {
            this.m_action.set(state, (Object)action);
            this.m_msgs.set(state, (Object)msgs);
        }

        public void generateXML(PageState state, Element parent) {
            Element element = parent.newChildElement("docs:error-label", "http://www.redhat.com/docs/1.0");
            element.addAttribute("action", (String)this.m_action.get(state));
            ArrayList list = (ArrayList)this.m_msgs.get(state);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Element item = element.newChildElement("docs:item", "http://www.redhat.com/docs/1.0");
                    item.addAttribute("name", (String)list.get(i));
                }
            }
        }
    }
}

