/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.tree.TreeNode;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.categorization.CategoryTreeModelLite;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.kernel.ui.DataQueryTreeNode;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class CategoriesPrintListener
implements PrintListener {
    private final ContentSection m_docsContentSection;
    private final BigDecimalParameter m_selectedFileParam;
    private final boolean m_showRoot;
    private static final String SEPARATOR = ">";

    public CategoriesPrintListener(ContentSection docsContentSection) {
        this(docsContentSection, null);
    }

    public CategoriesPrintListener(ContentSection docsContentSection, BigDecimalParameter selectedFileParam) {
        this(docsContentSection, selectedFileParam, false);
    }

    public CategoriesPrintListener(ContentSection docsContentSection, BigDecimalParameter selectedFileParam, boolean showRoot) {
        this.m_docsContentSection = docsContentSection;
        this.m_selectedFileParam = selectedFileParam;
        this.m_showRoot = showRoot;
    }

    public void prepare(PrintEvent e) {
        ContentItem ci;
        CategoryCollection cats;
        BigDecimal id;
        OptionGroup o = (OptionGroup)e.getTarget();
        PageState state = e.getPageState();
        Category root = this.m_docsContentSection.getRootCategory();
        CategoryTreeModelLite model = new CategoryTreeModelLite(root);
        LinkedList<TreeNode> queue = new LinkedList<TreeNode>();
        LinkedList<String> nameQueue = new LinkedList<String>();
        queue.addLast(model.getRoot(state));
        nameQueue.addLast("");
        HashSet<String> assignedIDs = new HashSet<String>();
        if (this.m_selectedFileParam != null && (id = (BigDecimal)state.getValue((ParameterModel)this.m_selectedFileParam)) != null && (cats = (ci = new ContentItem(id)).getCategoryCollection()).next()) {
            Category cat = cats.getCategory();
            String catID = cat.getID().toString();
            assignedIDs.add(catID);
        }
        boolean firstLoop = true;
        while (!queue.isEmpty()) {
            DataQueryTreeNode node = (DataQueryTreeNode)queue.removeFirst();
            String name = (String)nameQueue.removeFirst();
            String id2 = (String)node.getKey();
            if (firstLoop && this.m_showRoot) {
                o.addOption(new Option(id2, name));
            } else if (!firstLoop) {
                o.addOption(new Option(id2, name));
            }
            if (model.hasChildren((TreeNode)node, state)) {
                Iterator i = model.getChildren((TreeNode)node, state);
                while (i.hasNext()) {
                    TreeNode n = (TreeNode)i.next();
                    queue.addLast(n);
                    StringBuffer nameBuf = new StringBuffer(name);
                    if (name.length() > 0) {
                        nameBuf.append(SEPARATOR);
                    }
                    nameBuf.append(n.getElement());
                    nameQueue.addLast(nameBuf.toString());
                }
            }
            firstLoop = false;
        }
    }
}

