/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.DateParameter;
import com.arsdigita.cms.docmgr.DocMgr;
import com.arsdigita.cms.docmgr.ui.CategoryDocsNavigatorPortlet;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.permissions.UniversalPermissionDescriptor;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.toolbox.ui.DataQueryBuilder;
import com.arsdigita.toolbox.ui.DataTable;
import com.arsdigita.web.Web;
import java.util.Date;
import org.apache.log4j.Category;

public class CategoryDocModelBuilder
implements DataQueryBuilder,
DMConstants {
    private ACSObjectSelectionModel m_sel;
    private String m_context;
    private static final String DOC_ID = "docID";
    private static final String DOCS_IN_CAT_QUERY = "com.arsdigita.cms.docmgr.docsInCategory";
    protected static Category s_log = Category.getInstance((String)CategoryDocsNavigatorPortlet.class.getName());
    private final DateParameter m_startDateParameter = new DateParameter("startDate");
    private final DateParameter m_endDateParameter = new DateParameter("endDate");

    public CategoryDocModelBuilder(ACSObjectSelectionModel sel, String context) {
        this.m_sel = sel;
        this.m_context = context;
    }

    public void lock() {
    }

    public boolean isLocked() {
        return false;
    }

    public DataQuery makeDataQuery(DataTable t, PageState s) {
        DataQuery dq = SessionManager.getSession().retrieveQuery(DOCS_IN_CAT_QUERY);
        dq.setParameter("categoryID", this.m_sel.getSelectedKey(s));
        dq.setParameter("context", (Object)this.m_context);
        if (Web.getContext().getApplication().getDefaultDomainClass().equals("com.arsdigita.cms.docmgr.LegacyCategoryBrowserApplication")) {
            s_log.debug((Object)("contains legacy folder id: " + DocMgr.getConfig().getLegacyFolderID()));
            dq.addFilter(dq.getFilterFactory().contains("ancestors", "/" + DocMgr.getConfig().getLegacyFolderID() + "/", false));
        } else {
            s_log.debug((Object)"NOT contains legacy folder id");
            dq.addFilter(dq.getFilterFactory().simple("ancestors not like :ancestors").set("ancestors", (Object)("%/" + DocMgr.getConfig().getLegacyFolderID() + "/%")));
        }
        Date startDate = (Date)this.m_startDateParameter.transformValue(s.getRequest());
        Date endDate = (Date)this.m_endDateParameter.transformValue(s.getRequest());
        s_log.debug((Object)"makeDataQuery");
        if (startDate != null) {
            dq.addFilter(dq.getFilterFactory().greaterThan("lastModifiedDate", (Object)startDate, false));
            s_log.debug((Object)("startDate is " + startDate.toString()));
        }
        if (endDate != null) {
            dq.addFilter(dq.getFilterFactory().lessThan("lastModifiedDate", (Object)endDate, false));
            s_log.debug((Object)("endDate is " + endDate.toString()));
        }
        User u = Web.getContext().getUser();
        OID uOID = null;
        uOID = u == null ? new OID("com.arsdigita.kernel.User", -200) : u.getOID();
        if (!PermissionService.checkPermission((PermissionDescriptor)new UniversalPermissionDescriptor(PrivilegeDescriptor.READ, (Party)u))) {
            PermissionService.filterQuery((DataQuery)dq, (String)DOC_ID, (PrivilegeDescriptor)PrivilegeDescriptor.READ, (OID)uOID);
        }
        return dq;
    }

    public String getKeyColumn() {
        return DOC_ID;
    }
}

