/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.docmgr.ui.CategoryDocModelBuilder;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.cms.docmgr.ui.DMUtils;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.toolbox.ui.DataQueryBuilder;
import com.arsdigita.toolbox.ui.DataTable;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Lockable;
import com.arsdigita.web.Application;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class CategoryItemsBrowser
extends DataTable
implements DMConstants {
    private static final Logger s_log = Logger.getLogger(CategoryItemsBrowser.class);
    private RequestLocal m_resolver;
    private ContentSection m_section;
    private String m_context;
    private static final SimpleDateFormat simpleDateFormatter = new SimpleDateFormat();

    public CategoryItemsBrowser(CategoryDocModelBuilder cdmb, ACSObjectSelectionModel selCategory, String context, ContentSection cs) {
        super((DataQueryBuilder)cdmb);
        this.m_context = context;
        this.m_section = cs;
        s_log.debug((Object)("m_section is " + this.m_section.getName()));
        this.addColumn("Document Name", "name", true, new NameCellRenderer());
        this.addColumn("Type", new MimeTypeCellRenderer());
        this.addColumn("Size", "fileSize", true, new FileSizeCellRenderer());
        this.addColumn("Author", "authorSortKey", true, new AuthorCellRenderer());
        this.addColumn("Last Modified", "lastModifiedDate", true, new DateCellRenderer());
        this.addColumn("Workspace", "workspaceName", true, new WorkspaceCellRenderer());
        this.setCellPadding("3");
        this.setCellSpacing("3");
    }

    public String getContext() {
        return this.m_context;
    }

    public void setContext(String context) {
        Assert.isUnlocked((Lockable)this);
        this.m_context = context;
    }

    private class ItemSummaryCellRenderer
    implements TableCellRenderer {
        private ItemSummaryCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            if (value == null) {
                return new Label("&nbsp;", false);
            }
            DomainObject d = DomainObjectFactory.newInstance((DataObject)((DataObject)value));
            Assert.isTrue((boolean)(d instanceof ContentPage));
            ContentPage p = (ContentPage)d;
            Label l = new Label(p.getName() + "(id is " + p.getID().toString() + ")");
            return l;
        }
    }

    private class WorkspaceCellRenderer
    implements TableCellRenderer {
        private WorkspaceCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            s_log.debug((Object)("workspace: key is " + key.toString()));
            Document doc = new Document((BigDecimal)key);
            Application parentWorkspace = doc.getRepository().getParentApplication();
            User user = Web.getContext().getUser();
            if (!PermissionService.checkPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.READ, (ACSObject)parentWorkspace, (Party)user))) {
                s_log.debug((Object)("no permission for " + parentWorkspace.getTitle()));
                return new Label("");
            }
            return new Link(parentWorkspace.getTitle(), parentWorkspace.getPath());
        }
    }

    private class AuthorCellRenderer
    implements TableCellRenderer {
        private AuthorCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            String author = "unknown";
            if (key != null) {
                author = new Document((BigDecimal)key).getImpliedAuthor();
            }
            return new Label(author);
        }
    }

    private class MimeTypeCellRenderer
    implements TableCellRenderer {
        private MimeTypeCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            s_log.debug((Object)("mime: key is " + key.toString()));
            Document doc = new Document((BigDecimal)key);
            return new Label(doc.getPrettyMimeType());
        }
    }

    private class FileSizeCellRenderer
    implements TableCellRenderer {
        private FileSizeCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            s_log.debug((Object)("filesize: key is " + key.toString()));
            return new Label(DMUtils.FileSize.formatFileSize((BigDecimal)value));
        }
    }

    private class NameCellRenderer
    implements TableCellRenderer {
        private NameCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            s_log.debug((Object)("mime: key is " + key.toString()));
            String fileID = ((BigDecimal)key).toString();
            Document doc = new Document((BigDecimal)key);
            User user = Web.getContext().getUser();
            if (!PermissionService.checkPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.READ, (ACSObject)doc, (Party)user))) {
                s_log.debug((Object)("no read permission for file id" + fileID));
                return new Label(doc.getTitle());
            }
            return new Link(URLDecoder.decode(value.toString()), "file?d_id=" + fileID);
        }
    }

    private class DateCellRenderer
    implements TableCellRenderer {
        private DateCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            if (value == null) {
                return new Label("unknown");
            }
            return new Label(simpleDateFormatter.format((Date)value));
        }
    }
}

