/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.ExternalLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PaginationModelBuilder;
import com.arsdigita.bebop.Paginator;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.table.AbstractTableModelBuilder;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.docmgr.DocFolder;
import com.arsdigita.cms.docmgr.DocLink;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.docmgr.search.SearchResult;
import com.arsdigita.cms.docmgr.search.SearchResults;
import com.arsdigita.cms.docmgr.ui.BrowsePane;
import com.arsdigita.cms.docmgr.ui.CreateDocLinkPane;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.cms.docmgr.ui.DMUtils;
import com.arsdigita.cms.docmgr.ui.SearchForm;
import com.arsdigita.dispatcher.ObjectNotFoundException;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.OID;
import com.arsdigita.versioning.Versions;
import java.math.BigDecimal;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class CreateDocLinkSearchTable
extends Table
implements DMConstants {
    private static final Logger s_log = Logger.getLogger(CreateDocLinkSearchTable.class);
    public static final int PAGE_SIZE = 10;
    private static String[] s_headers = new String[]{"Name", "Workspace/Application", "Action"};
    private TableColumn m_createColumn;
    private Component m_parent;
    private Tree m_tree;
    private CreateDocLinkPane m_linkPane;

    CreateDocLinkSearchTable(CreateDocLinkPane linkPane, Component parent, Tree tree, SearchForm form) {
        super((TableModelBuilder)new CreateDocLinkTableModelBuilder(form), (Object[])s_headers);
        this.m_parent = parent;
        this.m_tree = tree;
        this.m_linkPane = linkPane;
        this.setWidth("100%");
        this.setRenderers();
        this.addTableActionListener((TableActionListener)new LinkCreator());
    }

    private void setRenderers() {
        this.getColumn(0).setCellRenderer((TableCellRenderer)new NameCellRenderer());
        this.getColumn(1).setCellRenderer((TableCellRenderer)new WorkspaceCellRenderer());
        this.m_createColumn = this.getColumn(2);
        this.m_createColumn.setCellRenderer((TableCellRenderer)new ActionCellRenderer());
        this.m_createColumn.setAlign("center");
    }

    private DocFolder getSelectedFolder(PageState state) {
        DocFolder p = null;
        String selKey = (String)this.m_tree.getSelectedKey(state);
        if (selKey == null) {
            p = DMUtils.getRootFolder(state);
        } else {
            BigDecimal folderID = new BigDecimal(selKey);
            try {
                p = new DocFolder(folderID);
            }
            catch (DataObjectNotFoundException nf) {
                throw new ObjectNotFoundException((String)FOLDER_PARENTNOTFOUND_ERROR.localize(state.getRequest()));
            }
        }
        return p;
    }

    private static class CreateDocLinkTableModelBuilder
    extends AbstractTableModelBuilder
    implements PaginationModelBuilder {
        private RequestLocal m_resultsLocal = new RequestLocal();
        private SearchForm m_form;

        public CreateDocLinkTableModelBuilder(SearchForm form) {
            this.m_form = form;
        }

        public TableModel makeModel(Table t, PageState ps) {
            SearchResults results = (SearchResults)this.m_resultsLocal.get(ps);
            if (results == null) {
                return Table.EMPTY_MODEL;
            }
            t.getRowSelectionModel().clearSelection(ps);
            return new CreateDocLinkTableModel((CreateDocLinkSearchTable)t, ps, (SearchResults)this.m_resultsLocal.get(ps));
        }

        public int getTotalSize(Paginator p, PageState ps) {
            SearchResults results = null;
            if (this.m_resultsLocal.get(ps) == null) {
                results = this.m_form.getSearchHits(ps);
                this.m_resultsLocal.set(ps, (Object)results);
            }
            if (results == null) {
                return 0;
            }
            int totalSize = (int)results.getTotalSize();
            s_log.debug((Object)("Setting paginator: size = " + results.getTotalSize() + " first = " + p.getFirst(ps) + " last = " + p.getLast(ps)));
            results.setRange(new Integer(p.getFirst(ps)), new Integer(p.getLast(ps) + 1));
            s_log.debug((Object)("totoalsize is " + totalSize));
            return totalSize;
        }

        public boolean isVisible(PageState state) {
            return this.m_form.isVisible(state);
        }
    }

    private static class CreateDocLinkTableModel
    implements TableModel {
        private static final int NAME = 0;
        private static final int WORKSPACE = 1;
        private static final int CREATABLE = 2;
        private PageState m_state;
        private CreateDocLinkSearchTable m_table;
        private Iterator m_results;
        private SearchResult m_result;

        public CreateDocLinkTableModel(CreateDocLinkSearchTable table, PageState state, SearchResults results) {
            this.m_state = state;
            this.m_table = table;
            if (results != null) {
                this.m_results = results.getResults();
                s_log.debug((Object)("In CreateDocLinkTableModel - Iterator ID: " + this.m_results.toString()));
            }
        }

        public int getColumnCount() {
            return 3;
        }

        public boolean nextRow() {
            if (this.m_results != null && this.m_results.hasNext()) {
                this.m_result = (SearchResult)this.m_results.next();
                return true;
            }
            return false;
        }

        public Object getElementAt(int columnIndex) {
            return this.m_result;
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_result.getID();
        }
    }

    private class NameCellRenderer
    extends DefaultTableCellRenderer {
        public NameCellRenderer() {
            super(true);
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            SearchResult result = (SearchResult)value;
            String url = result.getUrlStub();
            ExternalLink m_title = new ExternalLink(result.getLink(), url);
            return m_title;
        }
    }

    private static class WorkspaceCellRenderer
    implements TableCellRenderer {
        private WorkspaceCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            SearchResult result = (SearchResult)value;
            BigDecimal id = result.getID();
            OID oid = new OID("com.arsdigita.cms.docmgr.Document", (Object)id.abs());
            Document doc = (Document)DomainObjectFactory.newInstance((OID)oid);
            String workspace = doc.getRepository().getParentApplication().getDisplayName() + "/" + doc.getRepository().getDisplayName();
            return new Label(workspace);
        }
    }

    private static class ActionCellRenderer
    implements TableCellRenderer {
        private static final Logger logger = Logger.getLogger(ActionCellRenderer.class);
        private static ControlLink s_link;

        private ActionCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            return s_link;
        }

        static {
            logger.debug((Object)"Static initalizer starting...");
            s_link = new ControlLink((Component)new Label(DMConstants.FOLDER_NEW_CREATE_LINK));
            s_link.setConfirmation("Create Link to this Document ?");
            logger.debug((Object)"Static initalizer finished.");
        }
    }

    private class LinkCreator
    extends TableActionAdapter {
        private LinkCreator() {
        }

        public void cellSelected(TableActionEvent e) {
            DocLink newLink;
            int col = e.getColumn();
            if (CreateDocLinkSearchTable.this.m_createColumn != CreateDocLinkSearchTable.this.getColumn(col)) {
                return;
            }
            PageState s = e.getPageState();
            BigDecimal id = new BigDecimal(e.getRowKey().toString());
            boolean valid = true;
            OID oid = new OID("com.arsdigita.cms.docmgr.Document", (Object)id.abs());
            Document doc = (Document)DomainObjectFactory.newInstance((OID)oid);
            final DocFolder parent = CreateDocLinkSearchTable.this.getSelectedFolder(s);
            s_log.debug((Object)("Document Item: " + doc + " Parent Folder: " + parent));
            if (doc.getParentResource().getID() == parent.getID()) {
                CreateDocLinkSearchTable.this.m_linkPane.getErrorLable().setLabel("Document in Same Folder", s);
                valid = false;
            }
            try {
                parent.retrieveSubResource(doc.getName());
                CreateDocLinkSearchTable.this.m_linkPane.getErrorLable().setLabel(DMConstants.RESOURCE_EXISTS_ERROR, s);
                valid = false;
            }
            catch (DataObjectNotFoundException donf) {
                // empty catch block
            }
            if (!valid) {
                ((Table)e.getSource()).clearSelection(s);
                return;
            }
            BigDecimal doclinkID = (BigDecimal)s.getValue((ParameterModel)CreateDocLinkSearchTable.this.m_linkPane.getEditDoclinkIDParam());
            if (doclinkID != null) {
                newLink = new DocLink(doclinkID);
                newLink.setExternalURL(null);
            } else {
                newLink = new DocLink();
            }
            newLink.setName(doc.getName());
            newLink.setTitle(doc.getTitle());
            newLink.setDescription(doc.getDescription());
            newLink.setRepository(DocFolder.getRepository(parent));
            newLink.setLanguage("en");
            newLink.setTarget(doc);
            Versions.tag((OID)newLink.getOID(), (String)DMConstants.FILE_UPLOAD_INITIAL_TRANSACTION_DESCRIPTION.localize(s.getRequest()).toString());
            final ContentBundle bundle = new ContentBundle((ContentItem)newLink);
            bundle.setParent((ACSObject)parent);
            bundle.setContentSection(parent.getContentSection());
            bundle.save();
            new KernelExcursion(){

                protected void excurse() {
                    Party currentParty = Kernel.getContext().getParty();
                    this.setParty(Kernel.getSystemParty());
                    PermissionService.setContext((ACSObject)bundle, (ACSObject)parent);
                }
            }.run();
            ((Table)e.getSource()).clearSelection(s);
            ((BrowsePane)CreateDocLinkSearchTable.this.m_parent).displayFolderContentPanel(s);
        }
    }
}

