/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.DimensionalNavbar;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.docmgr.DocFolder;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.web.Application;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class FileDimensionalNavbar
extends DimensionalNavbar
implements DMConstants {
    private static final Logger s_log = Logger.getLogger(FileDimensionalNavbar.class);
    private static final String BEBOP_XML_NS = "http://www.arsdigita.com/bebop/1.0";
    private final RequestLocal m_file;

    public FileDimensionalNavbar(RequestLocal file) {
        this.m_file = file;
    }

    public void generateXML(PageState state, Element parent) {
        Element navbar = parent.newChildElement("bebop:dimensionalNavbar", BEBOP_XML_NS);
        navbar.addAttribute("startTag", "");
        navbar.addAttribute("endTag", "");
        navbar.addAttribute("delimiter", "");
        navbar.addAttribute("align", "right");
        this.exportAttributes(navbar);
        try {
            DocFolder df;
            Application rootApp;
            ArrayList<Link> list = new ArrayList<Link>();
            for (Application app = rootApp = Web.getContext().getApplication(); app != null; app = app.getParentApplication()) {
                list.add(new Link(app.getTitle(), app.getPath()));
                if (app.getClass().getName().equals("com.arsdigita.portalserver.PortalSite") || app.getClass().getName().equals("com.arsdigita.london.portal.Workspace")) break;
            }
            for (int i = list.size() - 1; i >= 0; --i) {
                ((Component)list.get(i)).generateXML(state, navbar);
            }
            list.clear();
            Document doc = (Document)this.m_file.get(state);
            ACSObject parentObj = ((ContentBundle)doc.getParent()).getParent();
            while (parentObj != null && parentObj instanceof DocFolder && !(df = (DocFolder)parentObj).isRoot()) {
                df = (DocFolder)parentObj;
                Link link = new Link(df.getTitle(), rootApp.getPath());
                link.setVar("of_id", df.getID().toString());
                list.add(link);
                parentObj = df.getParent();
            }
            for (int i = list.size() - 1; i >= 0; --i) {
                ((Component)list.get(i)).generateXML(state, navbar);
            }
            new Label(doc.getTitle()).generateXML(state, navbar);
        }
        catch (Exception e) {
            s_log.error((Object)"generateXML", (Throwable)e);
        }
    }
}

