/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.FileUpload;
import com.arsdigita.bebop.form.MultipleSelect;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.parameters.TrimmedStringParameter;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentSectionCollection;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.docmgr.DocFolder;
import com.arsdigita.cms.docmgr.DocMgr;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.docmgr.ui.BrowseFileInfoPropertiesPane;
import com.arsdigita.cms.docmgr.ui.BrowsePane;
import com.arsdigita.cms.docmgr.ui.CategoriesPrintListener;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.cms.docmgr.ui.DMUtils;
import com.arsdigita.cms.docmgr.ui.FileInfoPropertiesPane;
import com.arsdigita.dispatcher.MultipartHttpServletRequest;
import com.arsdigita.dispatcher.ObjectNotFoundException;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.permissions.ObjectPermissionCollection;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.versioning.Versions;
import com.arsdigita.web.Web;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.TooManyListenersException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

class FileEditForm
extends Form
implements FormValidationListener,
FormProcessListener,
FormInitListener,
DMConstants {
    private static final Logger s_log = Logger.getLogger(FileEditForm.class);
    private static final String FILE_EDIT = "file-edit";
    private static final String FILE_EDIT_CATS = "file-edit-cats";
    private static final String FILE_EDIT_FNAME = "file-edit-name";
    private static final String FILE_EDIT_AUDIENCE = "file-edit-audience";
    private static final String FILE_EDIT_AUTHOR = "file-edit-author";
    private static final String FILE_EDIT_DESCRIPTION = "file-edit-description";
    private static final String FILE_EDIT_TITLE = "file-edit-title";
    private StringParameter m_FileAudience;
    private StringParameter m_FileName;
    private TrimmedStringParameter m_FileAuthor;
    private StringParameter m_FileDesc;
    private ArrayParameter m_FileCats;
    private StringParameter m_FileTitle;
    private Component m_parent;
    boolean m_creation = false;
    private FileUpload m_fileUpload;
    private Tree m_tree;
    private static final String FILE_UPLOAD = "file-upload";
    private static final String FILE_UPLOAD_FORM = "file-upload-form";
    private Submit m_submit;

    public FileEditForm(Component parent) {
        this(parent, false, null);
    }

    public FileEditForm(Component parent, boolean creation, Tree tree) {
        super(FILE_EDIT, (Container)new ColumnPanel(2));
        this.m_parent = parent;
        this.m_creation = creation;
        this.m_tree = tree;
        this.m_FileAudience = new StringParameter(FILE_EDIT_AUDIENCE);
        this.m_FileAuthor = new TrimmedStringParameter(FILE_EDIT_AUTHOR);
        this.m_FileDesc = new StringParameter(FILE_EDIT_DESCRIPTION);
        this.m_FileCats = new ArrayParameter(FILE_EDIT_CATS);
        if (this.m_creation) {
            this.setMethod("post");
            this.setEncType("multipart/form-data");
            this.add((Component)new Label(FILE_UPLOAD_ADD_FILE));
            this.m_fileUpload = new FileUpload(FILE_UPLOAD);
            this.add((Component)this.m_fileUpload);
        } else {
            this.add((Component)new Label(FILE_NAME_REQUIRED));
            this.m_FileName = new StringParameter(FILE_EDIT_FNAME);
            TextField fnameEntry = new TextField((ParameterModel)this.m_FileName);
            this.add((Component)fnameEntry);
        }
        this.add((Component)new Label("Title"));
        this.m_FileTitle = new StringParameter(FILE_EDIT_TITLE);
        TextField fTitleEntry = new TextField((ParameterModel)this.m_FileTitle);
        this.add((Component)fTitleEntry);
        this.add((Component)new Label(FILE_INTENDED_AUDIENCE));
        SingleSelect audienceEntry = new SingleSelect((ParameterModel)this.m_FileAudience);
        try {
            audienceEntry.addPrintListener((PrintListener)new IntendedAudienceSelectPrinter());
        }
        catch (TooManyListenersException tmlex) {
            s_log.error((Object)tmlex.getMessage());
            tmlex.printStackTrace();
        }
        this.add((Component)audienceEntry);
        this.add((Component)new Label((PrintListener)new AuthorLabelPrinter()));
        TextField authorEntry = new TextField((ParameterModel)this.m_FileAuthor);
        this.add((Component)authorEntry);
        this.add((Component)new Label(FILE_CATEGORIES));
        MultipleSelect catSelect = new MultipleSelect(FILE_EDIT_CATS);
        catSelect.setSize(20);
        try {
            BigDecimalParameter fileIDParam = null;
            if (!this.m_creation) {
                fileIDParam = this.getFileIDParam();
            }
            catSelect.addPrintListener((PrintListener)new CategoriesPrintListener(this.getContentSection(), fileIDParam));
        }
        catch (TooManyListenersException tmex) {
            throw new UncheckedWrapperException(tmex.getMessage());
        }
        this.add((Component)catSelect);
        this.add((Component)new Label(FILE_DESCRIPTION));
        TextArea descArea = new TextArea((ParameterModel)this.m_FileDesc);
        descArea.setRows(10);
        descArea.setCols(40);
        this.add((Component)descArea);
        this.m_submit = new Submit("file-edit-save");
        this.m_submit.setButtonLabel(FILE_SAVE);
        this.add((Component)new Label());
        SimpleContainer sc = new SimpleContainer();
        sc.add((Component)this.m_submit);
        sc.add((Component)new Submit(CANCEL));
        this.add((Component)sc);
        this.addInitListener(this);
        this.addProcessListener(this);
        this.addValidationListener(this);
    }

    public void init(FormSectionEvent e) throws FormProcessException {
        if (this.m_creation) {
            this.initCreate(e);
        } else {
            this.initEdit(e);
        }
    }

    public void initEdit(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        BigDecimal id = this.getSelectedDocID(state);
        Document doc = DMUtils.getFile(id);
        ArrayList<String> assignedCats = new ArrayList<String>();
        CategoryCollection cats = doc.getCategoryCollection();
        if (cats.next()) {
            Category cat = cats.getCategory();
            String catID = cat.getID().toString();
            assignedCats.add(catID);
            s_log.debug((Object)("init: " + catID));
        }
        data.put((Object)FILE_EDIT_FNAME, (Object)URLDecoder.decode(doc.getName()));
        data.put((Object)FILE_EDIT_TITLE, (Object)doc.getTitle());
        data.put((Object)FILE_EDIT_AUTHOR, (Object)doc.getAuthor());
        data.put((Object)FILE_EDIT_DESCRIPTION, (Object)doc.getDescription());
        data.put((Object)FILE_EDIT_CATS, (Object)assignedCats.toArray());
        this.initAudienceFormData(data, doc);
    }

    private void initCreate(FormSectionEvent e) throws FormProcessException {
        if (this.m_parent instanceof BrowsePane) {
            PageState state = e.getPageState();
            FormData data = e.getFormData();
            ArrayParameter catIDParam = new ArrayParameter("catID");
            HttpServletRequest request = state.getRequest();
            String[] catIDs = (String[])catIDParam.transformValue(request);
            if (catIDs != null) {
                data.put((Object)FILE_EDIT_CATS, (Object)catIDs);
            }
        }
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        Document doc = null;
        if (this.m_submit.isSelected(e.getPageState())) {
            doc = this.m_creation ? this.processCreate(e) : this.processEdit(e);
        }
        this.backCancel(e.getPageState(), doc != null ? doc.getID() : null);
    }

    private Document processEdit(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        Document doc = DMUtils.getFile(this.getSelectedDocID(state));
        this.setDocumentAttributes(data, doc);
        doc.setCategories((String[])data.get((Object)FILE_EDIT_CATS));
        doc.setLastModifiedLocal(new Date());
        doc.save();
        this.setDocumentPermission(data, doc);
        return doc;
    }

    private Document processCreate(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        HttpServletRequest req = state.getRequest();
        final String fname = this.getUploadFileName(e);
        String titleTmp = (String)data.get((Object)FILE_EDIT_TITLE);
        if (titleTmp == null || titleTmp.trim().length() == 0) {
            int index;
            titleTmp = fname;
            MimeType mime = MimeType.guessMimeTypeFromFile((String)fname);
            titleTmp = mime != null && (index = fname.lastIndexOf(46)) > -1 ? fname.substring(0, index) : fname;
        }
        String title = titleTmp;
        String fpath = (String)data.get((Object)FILE_UPLOAD);
        File src = null;
        if (fpath != null && fpath.length() > 0) {
            HttpServletRequest mreq = e.getPageState().getRequest();
            Assert.isTrue((boolean)(mreq instanceof MultipartHttpServletRequest), (String)("I got a " + mreq + " when I was " + "expecting a MultipartHttpServletRequest"));
            src = ((MultipartHttpServletRequest)mreq).getFile(FILE_UPLOAD);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("file == '" + src + "'"));
        }
        DocFolder p = null;
        String selKey = (String)this.m_tree.getSelectedKey(state);
        if (selKey == null) {
            p = DMUtils.getRootFolder(state);
        } else {
            BigDecimal folderID = new BigDecimal(selKey);
            try {
                p = new DocFolder(folderID);
            }
            catch (DataObjectNotFoundException nf) {
                throw new ObjectNotFoundException((String)FOLDER_PARENTNOTFOUND_ERROR.localize(req));
            }
        }
        final DocFolder parent = p;
        final Document f1 = new Document();
        f1.setTitle(title);
        f1.setName(URLEncoder.encode(fname));
        f1.setLanguage("en");
        final ContentBundle bundle = new ContentBundle((ContentItem)f1);
        final FileAsset fa = new FileAsset();
        new KernelExcursion(){

            protected void excurse() {
                this.setParty(Kernel.getSystemParty());
                fa.setName("temp");
                f1.setFile(fa);
                bundle.setDefaultLanguage(f1.getLanguage());
                bundle.setName(fname);
                bundle.setParent((ACSObject)parent);
                bundle.setContentSection(parent.getContentSection());
                PermissionService.setContext((ACSObject)bundle, (ACSObject)parent);
                PermissionService.setContext((ACSObject)f1, (ACSObject)bundle);
                PermissionService.setContext((ACSObject)fa, (ACSObject)f1);
                bundle.save();
                f1.save();
            }
        }.run();
        try {
            fa.loadFromFile(fname, src, "txt");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new FormProcessException(ex.getMessage());
        }
        Versions.tag((OID)f1.getOID(), (String)FILE_UPLOAD_INITIAL_TRANSACTION_DESCRIPTION.localize(req).toString());
        this.setDocumentAttributes(data, f1);
        f1.setTitle(title);
        f1.setName(URLEncoder.encode(fname));
        f1.setRepository(DocFolder.getRepository(p));
        f1.setLastModifiedLocal(f1.getLastModifiedDate());
        this.setDocumentPermission(data, f1);
        f1.setCategories((String[])data.get((Object)FILE_EDIT_CATS));
        bundle.save();
        return f1;
    }

    private void setDocumentAttributes(FormData data, Document doc) {
        if (!this.m_creation) {
            String ftitle = (String)data.get((Object)FILE_EDIT_TITLE);
            String fname = (String)data.get((Object)FILE_EDIT_FNAME);
            doc.setTitle(ftitle != null && ftitle.length() > 0 ? ftitle : fname);
            doc.setName(URLEncoder.encode(fname));
        }
        String fauthor = (String)data.get((Object)FILE_EDIT_AUTHOR);
        String fdesc = (String)data.get((Object)FILE_EDIT_DESCRIPTION);
        if (fauthor != null) {
            doc.setAuthor(fauthor);
        }
        doc.setDescription(fdesc);
    }

    protected String getUploadFileName(FormSectionEvent e) {
        FormData data = e.getFormData();
        String filename = (String)data.get((Object)FILE_UPLOAD);
        return DMUtils.extractFileName(filename, e.getPageState());
    }

    public void validate(FormSectionEvent event) throws FormProcessException {
        if (this.m_submit.isSelected(event.getPageState())) {
            String desc;
            FormData data = event.getFormData();
            String author = (String)data.get((Object)FILE_EDIT_AUTHOR);
            if (author != null && author.length() > 200) {
                data.addError(FILE_EDIT_AUTHOR, "This parameter is too long. It must be fewer than 200 characters.");
            }
            if ((desc = (String)data.get((Object)FILE_EDIT_DESCRIPTION)) != null && desc.length() > 4000) {
                data.addError(FILE_EDIT_DESCRIPTION, "This parameter is too long. It must be fewer than 4000 characters.");
            }
            if (this.m_creation) {
                this.validateCreate(event);
            } else {
                this.validateEdit(event);
            }
        }
    }

    private void validateCreate(FormSectionEvent e) throws FormProcessException {
        String title;
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        HttpServletRequest req = state.getRequest();
        String fname = (String)data.get((Object)FILE_UPLOAD);
        if (fname == null || fname.length() == 0) {
            data.addError(FILE_UPLOAD, "This parameter is required.");
        }
        if ((fname = DMUtils.extractFileName(this.getUploadFileName(e), state)).length() > 200) {
            data.addError(FILE_UPLOAD, "This filename is too long. It must be fewer than 200 characters.");
        }
        if ((title = (String)data.get((Object)FILE_EDIT_TITLE)) != null && title.length() > 200) {
            data.addError(FILE_EDIT_TITLE, "This title is too long. It must be fewer than 200 characters.");
        }
        DocFolder parent = null;
        String selKey = (String)this.m_tree.getSelectedKey(state);
        if (selKey == null) {
            parent = DMUtils.getRootFolder(state);
        } else {
            BigDecimal folderID = new BigDecimal(selKey);
            try {
                parent = new DocFolder(folderID);
            }
            catch (DataObjectNotFoundException nf) {
                throw new ObjectNotFoundException(FOLDER_PARENTNOTFOUND_ERROR.localize(req).toString());
            }
        }
        parent.assertPrivilege(PrivilegeDescriptor.CREATE);
        try {
            parent.retrieveSubResource(fname);
            data.addError(FILE_UPLOAD, RESOURCE_EXISTS_ERROR.localize(req).toString());
        }
        catch (DataObjectNotFoundException nf) {
            // empty catch block
        }
    }

    private void validateEdit(FormSectionEvent event) throws FormProcessException {
        String title;
        FormData data = event.getFormData();
        String fname = (String)data.get((Object)FILE_EDIT_FNAME);
        if (fname == null || fname.trim().length() == 0) {
            data.addError(FILE_EDIT_FNAME, "This parameter is required");
        }
        if ((title = (String)data.get((Object)FILE_EDIT_TITLE)) == null || title.length() == 0) {
            data.addError(FILE_EDIT_TITLE, "This parameter is required.");
        } else if (title.length() > 200) {
            data.addError(FILE_EDIT_TITLE, "This title is too long. It must be fewer than 200 characters.");
        }
    }

    private void initAudienceFormData(FormData data, Document doc) {
        ObjectPermissionCollection opc = PermissionService.getDirectGrantedPermissions((OID)doc.getOID());
        long numPermissions = opc.size();
        if (numPermissions > 1L) {
            s_log.error((Object)"there should only be 1 direct permission for a document");
        }
        if (numPermissions == 0L) {
            data.put((Object)FILE_EDIT_AUDIENCE, (Object)"workspace");
            opc.close();
            return;
        }
        boolean isPublic = false;
        while (opc.next()) {
            if (opc.getGranteeID().intValue() != -200) continue;
            isPublic = true;
        }
        opc.close();
        if (isPublic) {
            data.put((Object)FILE_EDIT_AUDIENCE, (Object)"public");
        } else {
            data.put((Object)FILE_EDIT_AUDIENCE, (Object)"internal");
        }
    }

    private void setDocumentPermission(FormData data, Document doc) throws FormProcessException {
        final String intendedAudience = (String)data.get((Object)FILE_EDIT_AUDIENCE);
        if (intendedAudience == null) {
            throw new FormProcessException("Intended Audience cannot be null");
        }
        final PermissionDescriptor publicDescriptor = new PermissionDescriptor(PrivilegeDescriptor.READ, doc.getOID(), new OID("com.arsdigita.kernel.User", -200));
        final PermissionDescriptor internalDescriptor = new PermissionDescriptor(PrivilegeDescriptor.READ, doc.getOID(), new OID("com.arsdigita.kernel.Group", DocMgr.getConfig().getInternalGroupID()));
        new KernelExcursion(){

            protected void excurse() {
                this.setParty(Kernel.getSystemParty());
                if ("public".equals(intendedAudience)) {
                    PermissionService.grantPermission((PermissionDescriptor)publicDescriptor);
                    PermissionService.revokePermission((PermissionDescriptor)internalDescriptor);
                } else if ("internal".equals(intendedAudience)) {
                    PermissionService.revokePermission((PermissionDescriptor)publicDescriptor);
                    PermissionService.grantPermission((PermissionDescriptor)internalDescriptor);
                } else {
                    PermissionService.revokePermission((PermissionDescriptor)publicDescriptor);
                    PermissionService.revokePermission((PermissionDescriptor)internalDescriptor);
                }
            }
        }.run();
    }

    private ContentSection getContentSection() {
        ContentSectionCollection csl = ContentSection.getAllSections();
        csl.addEqualsFilter("label", (Object)DocMgr.getConfig().getContentSection());
        if (!csl.next()) {
            csl.close();
            return null;
        }
        ContentSection docsContentSection = csl.getContentSection();
        csl.close();
        return docsContentSection;
    }

    private BigDecimal getSelectedDocID(PageState state) {
        if (this.m_creation) {
            s_log.warn((Object)"doc create step shouldn't need selected id");
            return null;
        }
        return (BigDecimal)state.getValue((ParameterModel)this.getFileIDParam());
    }

    private BigDecimalParameter getFileIDParam() {
        if (this.m_parent instanceof FileInfoPropertiesPane) {
            return ((FileInfoPropertiesPane)this.m_parent).getFileIDParam();
        }
        if (this.m_parent instanceof BrowseFileInfoPropertiesPane) {
            ((BrowseFileInfoPropertiesPane)this.m_parent).getFileIDParam();
        }
        return null;
    }

    private void backCancel(PageState state, BigDecimal docID) {
        if (this.m_parent instanceof BrowsePane) {
            if (docID != null) {
                ((BrowsePane)this.m_parent).displayFilePropPanel(state, docID);
            } else {
                ((BrowsePane)this.m_parent).displayFolderContentPanel(state);
            }
        } else if (this.m_parent instanceof FileInfoPropertiesPane) {
            ((FileInfoPropertiesPane)this.m_parent).displayPropertiesAndActions(state);
        } else if (this.m_parent instanceof BrowseFileInfoPropertiesPane) {
            ((BrowseFileInfoPropertiesPane)this.m_parent).displayPropertiesPane(state);
        }
    }

    protected class IntendedAudienceSelectPrinter
    implements PrintListener {
        public void prepare(PrintEvent e) {
            SingleSelect select = (SingleSelect)e.getTarget();
            select.addOption(new Option("workspace", Web.getContext().getApplication().getParentApplication() == null ? Web.getContext().getApplication().getDisplayName() : Web.getContext().getApplication().getParentApplication().getDisplayName() + " members"));
            select.addOption(new Option("internal", (Component)new Label(DMConstants.FILE_INTENDED_AUDIENCE_INTERNAL)));
            select.addOption(new Option("public", (Component)new Label(DMConstants.FILE_INTENDED_AUDIENCE_PUBLIC)));
        }
    }

    protected class AuthorLabelPrinter
    implements PrintListener {
        public void prepare(PrintEvent e) {
            Label label = (Label)e.getTarget();
            PageState pageState = e.getPageState();
            String name = Web.getContext().getUser().getName();
            label.setLabel("Author: (if not " + name + ")");
        }
    }
}

