/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentSectionCollection;
import com.arsdigita.cms.docmgr.DocMgr;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.cms.docmgr.ui.DocmgrBasePage;
import com.arsdigita.cms.docmgr.ui.FileActionPane;
import com.arsdigita.cms.docmgr.ui.FileEditForm;
import com.arsdigita.cms.docmgr.ui.FilePropertiesPanel;
import com.arsdigita.cms.docmgr.ui.FileSendColleaguePane;
import com.arsdigita.cms.docmgr.ui.VersionUploadForm;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import java.util.ArrayList;

class FileInfoPropertiesPane
extends SimpleContainer
implements DMConstants,
RequestListener {
    private ArrayList m_componentList;
    private RequestLocal m_fileData;
    private Component m_properties;
    private Component m_upload;
    private Component m_sendColleague;
    private Component m_edit;
    private Component m_action;
    private FileSendColleaguePane m_sendColleaguePane;
    private FileActionPane m_fileActionPane;
    private ActionLink m_editLink;
    private DocmgrBasePage m_page;
    private ContentSection m_docsContentSection;

    public FileInfoPropertiesPane(DocmgrBasePage p) {
        this.m_page = p;
        ContentSectionCollection csl = ContentSection.getAllSections();
        csl.addEqualsFilter("label", (Object)DocMgr.getConfig().getContentSection());
        if (!csl.next()) {
            csl.close();
            return;
        }
        this.m_docsContentSection = csl.getContentSection();
        csl.close();
        this.m_fileData = new RequestLocal(){

            protected Object initialValue(PageState state) {
                BigDecimal id = (BigDecimal)state.getValue((ParameterModel)FileInfoPropertiesPane.this.getFileIDParam());
                Document doc = null;
                try {
                    doc = new Document(id);
                }
                catch (DataObjectNotFoundException nfe) {
                    throw new UncheckedWrapperException((Throwable)nfe);
                }
                return doc;
            }
        };
        SegmentedPanel main = new SegmentedPanel();
        main.setClassAttr("main");
        this.m_componentList = new ArrayList();
        this.m_properties = this.makePropertiesPane(main);
        this.m_componentList.add(this.m_properties);
        this.m_edit = this.makeEditPane(main);
        this.m_componentList.add(this.m_edit);
        this.m_action = this.makeActionPane(main);
        this.m_componentList.add(this.m_action);
        this.m_upload = this.makeUploadPane(main);
        this.m_componentList.add(this.m_upload);
        this.m_sendColleague = this.makeSendColleaguePane(main);
        this.m_componentList.add(this.m_sendColleague);
        this.add((Component)main);
    }

    private Component makePropertiesPane(SegmentedPanel main) {
        SimpleContainer container = new SimpleContainer();
        container.add((Component)new FilePropertiesPanel(this));
        this.m_editLink = new ActionLink((Component)new Label(FILE_EDIT_LINK));
        this.m_editLink.setClassAttr("actionLink");
        this.m_editLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                FileInfoPropertiesPane.this.displayEditForm(state);
            }
        });
        container.add((Component)this.m_editLink);
        return main.addSegment((Component)FILE_PROPERTIES_HEADER, (Component)container);
    }

    private Component makeEditPane(SegmentedPanel main) {
        return main.addSegment((Component)FILE_EDIT_HEADER, (Component)new FileEditForm((Component)this));
    }

    private Component makeActionPane(SegmentedPanel main) {
        this.m_fileActionPane = new FileActionPane(this);
        return main.addSegment((Component)FILE_ACTION_HEADER, (Component)this.m_fileActionPane);
    }

    private Component makeUploadPane(SegmentedPanel main) {
        return main.addSegment((Component)FILE_UPLOAD_HEADER, (Component)new VersionUploadForm(this));
    }

    private Component makeSendColleaguePane(SegmentedPanel main) {
        this.m_sendColleaguePane = new FileSendColleaguePane(this);
        return main.addSegment((Component)FILE_SEND_COLLEAGUE_HEADER, (Component)this.m_sendColleaguePane);
    }

    public void register(Page p) {
        for (int i = 0; i < this.m_componentList.size(); ++i) {
            p.setVisibleDefault((Component)this.m_componentList.get(i), false);
        }
        p.setVisibleDefault(this.m_properties, true);
        p.setVisibleDefault(this.m_action, true);
        p.addRequestListener((RequestListener)this.m_fileActionPane);
        p.addRequestListener((RequestListener)this);
        super.register(p);
    }

    private void hideAll(PageState state) {
        for (int i = 0; i < this.m_componentList.size(); ++i) {
            ((Component)this.m_componentList.get(i)).setVisible(state, false);
        }
    }

    public void displayPropertiesAndActions(PageState state) {
        this.m_page.goUnmodal(state);
        this.hideAll(state);
        this.m_properties.setVisible(state, true);
        this.m_action.setVisible(state, true);
    }

    public void displayEditForm(PageState state) {
        this.m_page.goModal(state, this.m_edit);
    }

    public void displayUploadForm(PageState state) {
        this.m_page.goModal(state, this.m_upload);
    }

    public void displaySendColleagueForm(PageState state) {
        this.m_page.goModal(state, this.m_sendColleague);
        this.m_sendColleaguePane.initState(state);
    }

    public BigDecimalParameter getFileIDParam() {
        return this.m_page.getFileIDParam();
    }

    public ContentSection getContentSection() {
        return this.m_docsContentSection;
    }

    public Document getDocument(PageState s) {
        return (Document)this.m_fileData.get(s);
    }

    public void pageRequested(RequestEvent event) {
        User user;
        PageState state = event.getPageState();
        Document doc = this.getDocument(state);
        if (!PermissionService.checkPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.WRITE, (ACSObject)doc, (Party)(user = Web.getContext().getUser())))) {
            this.m_editLink.setVisible(state, false);
        }
        doc.assertPrivilege(PrivilegeDescriptor.READ);
    }
}

