/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.cms.docmgr.ui.DMUtils;
import com.arsdigita.cms.docmgr.ui.FileInfoPropertiesPane;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.OID;
import com.arsdigita.versioning.TransactionCollection;
import com.arsdigita.versioning.Versions;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

class FilePropertiesPanel
extends SimpleComponent
implements DMConstants {
    private static final Logger s_log = Logger.getLogger(FilePropertiesPanel.class);
    private FileInfoPropertiesPane m_parent;

    public FilePropertiesPanel(FileInfoPropertiesPane parent) {
        this.m_parent = parent;
    }

    public void generateXML(PageState state, Element parent) {
        BigDecimal id = (BigDecimal)state.getValue((ParameterModel)this.m_parent.getFileIDParam());
        Element element = parent.newChildElement("docs:file-info", "http://www.redhat.com/docs/1.0");
        try {
            Document doc = new Document(id);
            s_log.debug((Object)("doc raw content: " + doc.getSearchRawContent()));
            Element titleElement = element.newChildElement("docs:title", "http://www.redhat.com/docs/1.0");
            titleElement.setText(doc.getTitle());
            Element nameElement = element.newChildElement("docs:name", "http://www.redhat.com/docs/1.0");
            nameElement.setText(doc.getName());
            Element descriptionElement = element.newChildElement("docs:description", "http://www.redhat.com/docs/1.0");
            String description = doc.getDescription();
            if (description != null) {
                descriptionElement.setText(description);
            }
            Element sizeElement = element.newChildElement("docs:size", "http://www.redhat.com/docs/1.0");
            sizeElement.setText(DMUtils.FileSize.formatFileSize(doc.getSize()));
            Element typeElement = element.newChildElement("docs:type", "http://www.redhat.com/docs/1.0");
            typeElement.setText(doc.getPrettyMimeType());
            Element lastModifiedElement = element.newChildElement("docs:last-modified", "http://www.redhat.com/docs/1.0");
            lastModifiedElement.setText(null != doc.getLastModifiedLocal() ? DMUtils.DateFormat.format(doc.getLastModifiedLocal()) : "");
            Element revisionElement = element.newChildElement("docs:revision", "http://www.redhat.com/docs/1.0");
            TransactionCollection tc = Versions.getTaggedTransactions((OID)doc.getOID());
            long numRevs = tc.size();
            revisionElement.setText(numRevs + "");
            Element authorElement = element.newChildElement("docs:author", "http://www.redhat.com/docs/1.0");
            authorElement.setText(doc.getImpliedAuthor());
            Element uriElement = element.newChildElement("docs:uri", "http://www.redhat.com/docs/1.0");
            uriElement.setText(FilePropertiesPanel.makeFileURL(doc, state));
            Element catsElement = element.newChildElement("docs:categories", "http://www.redhat.com/docs/1.0");
            CategoryCollection cats = doc.getCategoryCollection();
            while (cats.next()) {
                Category cat = cats.getCategory();
                Element catElement = catsElement.newChildElement("docs:category", "http://www.redhat.com/docs/1.0");
                catElement.addAttribute("id", cat.getID().toString());
                catElement.addAttribute("name", cat.getName());
            }
        }
        catch (DataObjectNotFoundException exc) {
            Element notfoundElement = element.newChildElement("docs:notfound", "http://www.redhat.com/docs/1.0");
        }
    }

    private static String makeFileURL(Document doc, PageState state) {
        HttpServletRequest req = state.getRequest();
        ParameterMap params = new ParameterMap();
        params.setParameter("d_id", (Object)doc.getID());
        return URL.here((HttpServletRequest)req, (String)("/download/" + doc.getName()), (ParameterMap)params).toString();
    }
}

