/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.cms.docmgr.ui.FileInfoHistoryPane;
import com.arsdigita.cms.docmgr.ui.FileRevisionsTableModelBuilder;
import org.apache.log4j.Logger;

class FileRevisionsTable
extends Table
implements TableActionListener,
DMConstants {
    private static Logger s_log = Logger.getLogger(FileRevisionsTable.class);
    private FileInfoHistoryPane m_parent;
    static String[] s_tableHeaders = new String[]{"", "Author", "Date", "Comments", ""};

    public FileRevisionsTable(FileInfoHistoryPane parent) {
        super((TableModelBuilder)new FileRevisionsTableModelBuilder(parent), (Object[])s_tableHeaders);
        this.m_parent = parent;
        this.setClassAttr("AlternateTable");
        this.setWidth("100%");
        this.setCellRenderers();
        this.addTableActionListener(this);
    }

    public void cellSelected(TableActionEvent e) {
    }

    public void headSelected(TableActionEvent e) {
        throw new UnsupportedOperationException();
    }

    private void setCellRenderers() {
        this.getColumn(4).setCellRenderer((TableCellRenderer)new LinkRenderer());
    }

    private final class LinkRenderer
    implements TableCellRenderer {
        private LinkRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            if (value != null) {
                Document doc = FileRevisionsTable.this.m_parent.getDocument(state);
                Link link = new Link("Download", "download/" + doc.getName() + "?" + "d_id" + "=" + doc.getID() + "&transID=" + key);
                link.setClassAttr("downloadLink");
                return link;
            }
            return new Label();
        }
    }
}

