/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.cms.docmgr.ui.DMUtils;
import com.arsdigita.cms.docmgr.ui.FileInfoHistoryPane;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.OID;
import com.arsdigita.versioning.Tag;
import com.arsdigita.versioning.TagCollection;
import com.arsdigita.versioning.Transaction;
import com.arsdigita.versioning.TransactionCollection;
import com.arsdigita.versioning.Versions;
import java.math.BigDecimal;

class FileRevisionsTableModel
implements TableModel,
DMConstants {
    private FileInfoHistoryPane m_parent;
    private Document m_document;
    private PageState m_state;
    private TransactionCollection m_tc;
    private Transaction m_transaction;
    private Transaction m_lastContentChange;
    private int m_row;
    private int m_last = 2;

    FileRevisionsTableModel(Document doc, PageState state) {
        this.m_document = doc;
        this.m_state = state;
        this.m_tc = Versions.getTaggedTransactions((OID)this.m_document.getOID());
        this.m_last = this.m_row = (int)this.m_tc.size() + 1;
    }

    public int getColumnCount() {
        return 5;
    }

    public Object getElementAt(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return new BigDecimal(this.m_row);
            }
            case 1: {
                User user = this.m_document.getLastModifiedUser();
                if (null == user) {
                    return "Unknown";
                }
                return user.getPersonName().toString();
            }
            case 2: {
                if (this.m_row == 0) {
                    return DMUtils.DateFormat.format(this.m_document.getCreationDate());
                }
                return DMUtils.DateFormat.format(this.m_transaction.getTimestamp());
            }
            case 3: {
                StringBuffer sb = new StringBuffer();
                TagCollection tc = this.m_transaction.getTags();
                int counter = 0;
                while (tc.next()) {
                    Tag t = tc.getTag();
                    sb.append(++counter + ") " + t.getDescription() + "  ");
                }
                return sb.toString();
            }
            case 4: {
                return "download";
            }
        }
        return null;
    }

    public Object getKeyAt(int columnIndex) {
        if (columnIndex == 4) {
            return this.m_transaction.getID();
        }
        return this.m_document.getID() + "." + this.m_row;
    }

    public boolean nextRow() {
        --this.m_row;
        if (this.m_tc.next()) {
            this.m_transaction = this.m_tc.getTransaction();
            return true;
        }
        this.m_tc.close();
        return false;
    }
}

