/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.FileUpload;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.docmgr.DocFolder;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.docmgr.Util;
import com.arsdigita.cms.docmgr.ui.BrowsePane;
import com.arsdigita.cms.docmgr.ui.CancelButton;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.cms.docmgr.ui.DMUtils;
import com.arsdigita.dispatcher.MultipartHttpServletRequest;
import com.arsdigita.dispatcher.ObjectNotFoundException;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import com.arsdigita.versioning.Versions;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class FileUploadForm
extends Form
implements FormInitListener,
FormValidationListener,
FormProcessListener,
DMConstants {
    private static final Logger s_log = Logger.getLogger(FileUploadForm.class);
    private static final String FILE_UPLOAD = "file-upload";
    private static final String FILE_UPLOAD_FORM = "file-upload-form";
    private static final String FILE_UPLOAD_INPUT_DESCRIPTION = "file-description";
    private FileUpload m_fileUpload;
    private StringParameter m_FileDesc;
    private Tree m_tree;
    private BrowsePane m_parent;

    public FileUploadForm(BrowsePane parent, Tree tree) {
        this(parent, tree, true);
    }

    public FileUploadForm(BrowsePane parent, Tree tree, boolean initListeners) {
        super(FILE_UPLOAD_FORM, (Container)new ColumnPanel(2));
        this.m_parent = parent;
        this.setMethod("post");
        this.setEncType("multipart/form-data");
        this.m_tree = tree;
        this.m_fileUpload = new FileUpload(FILE_UPLOAD);
        this.m_FileDesc = new StringParameter(FILE_UPLOAD_INPUT_DESCRIPTION);
        this.m_FileDesc.addParameterListener((ParameterListener)new StringLengthValidationListener(4000));
        this.add((Component)new Label(FILE_UPLOAD_ADD_FILE));
        this.add((Component)this.m_fileUpload);
        this.add((Component)new Label(FILE_DESCRIPTION));
        TextArea textArea = new TextArea((ParameterModel)this.m_FileDesc);
        textArea.setRows(10);
        textArea.setCols(40);
        this.add((Component)textArea);
        SimpleContainer sc = new SimpleContainer();
        Submit submit = new Submit("submit");
        submit.setButtonLabel(FILE_SUBMIT);
        sc.add((Component)submit);
        CancelButton cancel = new CancelButton(CANCEL);
        sc.add((Component)cancel);
        this.add((Component)new Label());
        this.add((Component)sc, 1);
        if (initListeners) {
            this.addInitListener(this);
            this.addProcessListener(this);
            this.addValidationListener(this);
        }
    }

    protected BigDecimal insertFile(FormSectionEvent e) throws FormProcessException {
        s_log.debug((Object)"Inserting a file");
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        HttpServletRequest req = state.getRequest();
        String fname = this.getFileName(e);
        String fdesc = (String)data.get((Object)FILE_UPLOAD_INPUT_DESCRIPTION);
        String fpath = (String)data.get((Object)FILE_UPLOAD);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("getFileName() -> '" + fname + "'"));
            s_log.debug((Object)("description == '" + fdesc + "'"));
            s_log.debug((Object)("path == '" + fpath + "'"));
        }
        File src = null;
        if (fpath != null && fpath.length() > 0) {
            HttpServletRequest mreq = e.getPageState().getRequest();
            Assert.isTrue((boolean)(mreq instanceof MultipartHttpServletRequest), (String)("I got a " + mreq + " when I was " + "expecting a MultipartHttpServletRequest"));
            src = ((MultipartHttpServletRequest)mreq).getFile(FILE_UPLOAD);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("file == '" + src + "'"));
        }
        DocFolder p = null;
        String selKey = (String)this.m_tree.getSelectedKey(state);
        if (selKey == null) {
            p = DMUtils.getRootFolder(state);
        } else {
            BigDecimal folderID = new BigDecimal(selKey);
            try {
                p = new DocFolder(folderID);
            }
            catch (DataObjectNotFoundException nf) {
                throw new ObjectNotFoundException((String)FOLDER_PARENTNOTFOUND_ERROR.localize(req));
            }
        }
        final DocFolder parent = p;
        Document f1 = new Document();
        try {
            f1.setName(fname);
            f1.setTitle(fname);
            f1.setDescription(fdesc);
            f1.setRepository(DocFolder.getRepository(p));
            f1.setLanguage("en");
            FileAsset fa = new FileAsset();
            fa.loadFromFile(fname, src, "txt");
            f1.setFile(fa);
            Versions.tag((OID)f1.getOID(), (String)FILE_UPLOAD_INITIAL_TRANSACTION_DESCRIPTION.localize(req).toString());
            f1.setLastModifiedLocal(f1.getLastModifiedDate());
            final ContentBundle bundle = new ContentBundle((ContentItem)f1);
            bundle.setParent((ACSObject)parent);
            bundle.setContentSection(parent.getContentSection());
            bundle.save();
            new KernelExcursion(){

                protected void excurse() {
                    Party currentParty = Kernel.getContext().getParty();
                    this.setParty(Kernel.getSystemParty());
                    PermissionService.setContext((ACSObject)bundle, (ACSObject)parent);
                }
            }.run();
            return f1.getID();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new FormProcessException(ex.getMessage());
        }
    }

    public void init(FormSectionEvent e) {
        PageState state = e.getPageState();
        if (Kernel.getContext().getParty() == null) {
            Util.redirectToLoginPage(state);
        }
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        s_log.debug((Object)"Processing form submission");
        this.insertFile(e);
        if (this.m_parent != null) {
            this.m_parent.displayFolderContentPanel(e.getPageState());
        }
    }

    protected String getFileName(FormSectionEvent e) {
        FormData data = e.getFormData();
        String filename = (String)data.get((Object)FILE_UPLOAD);
        return DMUtils.extractFileName(filename, e.getPageState());
    }

    public void validate(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        HttpServletRequest req = state.getRequest();
        String fname = DMUtils.extractFileName(this.getFileName(e), state);
        if (fname.length() > 200) {
            data.addError(FILE_UPLOAD, "This filename is too long.  It must be fewer than 200 characters.");
        }
        DocFolder parent = null;
        String selKey = (String)this.m_tree.getSelectedKey(state);
        if (selKey == null) {
            parent = DMUtils.getRootFolder(state);
        } else {
            BigDecimal folderID = new BigDecimal(selKey);
            try {
                parent = new DocFolder(folderID);
            }
            catch (DataObjectNotFoundException nf) {
                throw new ObjectNotFoundException(FOLDER_PARENTNOTFOUND_ERROR.localize(req).toString());
            }
        }
        try {
            parent.retrieveSubResource(fname);
            data.addError(FILE_UPLOAD, RESOURCE_EXISTS_ERROR.localize(req).toString());
        }
        catch (DataObjectNotFoundException nf) {
            // empty catch block
        }
    }
}

