/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.docmgr.DocMgr;
import com.arsdigita.cms.docmgr.Resource;
import com.arsdigita.cms.docmgr.ui.BrowsePane;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.cms.docmgr.ui.DMUtils;
import com.arsdigita.cms.docmgr.ui.DeleteSubmit;
import com.arsdigita.cms.docmgr.ui.FolderTable;
import com.arsdigita.cms.docmgr.ui.PagingControlContainer;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;
import java.util.ArrayList;

class FolderContentsTableForm
extends Form
implements FormProcessListener,
FormValidationListener,
DMConstants {
    private Tree m_tree;
    private FolderTable m_folder;
    private SingleSelect m_actionSelect;
    private StringParameter m_action = new StringParameter("folder-action");
    private Submit m_deleteSubmit;
    private Submit m_copySubmit;
    private Submit m_moveSubmit;
    private SimpleContainer m_actionBar;
    private Label m_emptyFolderLabel;
    private BrowsePane m_parent;
    private IntegerParameter m_pageNo = new IntegerParameter("page_to_display");
    private RequestLocal m_maxPages;

    public FolderContentsTableForm(BrowsePane parent, Tree tree) {
        super("FolderContentAction", (Container)new ColumnPanel(1));
        this.m_tree = tree;
        this.m_parent = parent;
        this.m_maxPages = new RequestLocal(){

            protected Object initialValue(PageState ps) {
                BigDecimal fid = DMUtils.getSelectedFolderID(ps, FolderContentsTableForm.this.m_tree);
                Folder parentFolder = new Folder(fid);
                DataQuery m_collection = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.docmgr.ui.ItemsInFolder");
                m_collection.setParameter("parent", (Object)fid);
                m_collection.setParameter("version", (Object)parentFolder.getVersion());
                long size = m_collection.size();
                m_collection.close();
                int rowsPerPage = DocMgr.getConfig().getRowsPerPage();
                int maxPages = (int)(size / (long)rowsPerPage + (long)(size % (long)rowsPerPage > 0L ? 1 : 0));
                return new Integer(maxPages);
            }
        };
        this.add((Component)new PagingControlContainer(this.m_pageNo, this.m_maxPages));
        this.m_folder = new FolderTable(this.m_tree, this);
        this.add((Component)this.m_folder);
        this.m_actionBar = new SimpleContainer();
        this.m_copySubmit = new Submit(ACTION_COPY_SUBMIT);
        this.m_actionBar.add((Component)this.m_copySubmit);
        this.m_moveSubmit = new Submit(ACTION_MOVE_SUBMIT);
        this.m_actionBar.add((Component)this.m_moveSubmit);
        this.m_deleteSubmit = new DeleteSubmit(ACTION_DELETE_SUBMIT);
        this.m_actionBar.add((Component)this.m_deleteSubmit);
        this.add((Component)this.m_actionBar);
        this.m_emptyFolderLabel = FOLDER_EMPTY_LABEL;
        this.add((Component)this.m_emptyFolderLabel);
        this.addProcessListener(this);
        this.addValidationListener(this);
    }

    protected IntegerParameter getPageNoParameter() {
        return this.m_pageNo;
    }

    protected BrowsePane getParent() {
        return this.m_parent;
    }

    public void register(Page p) {
        p.addGlobalStateParam((ParameterModel)this.m_pageNo);
        p.setVisibleDefault((Component)this.m_actionBar, true);
        p.setVisibleDefault((Component)this.m_emptyFolderLabel, false);
        super.register(p);
    }

    public void validate(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        String[] selectedItems = (String[])this.m_folder.getCheckboxGroup().getValue(state);
        if (selectedItems == null) {
            return;
        }
        if (!this.m_deleteSubmit.isSelected(state)) {
            return;
        }
        for (int i = 0; i < selectedItems.length; ++i) {
            ContentItem ci = new ContentItem(new OID("com.arsdigita.cms.ContentItem", (Object)new BigDecimal(selectedItems[i])));
            OID oid = ci.getSpecificOID();
            Resource resource = null;
            try {
                resource = (Resource)DomainObjectFactory.newInstance((OID)oid);
                if (!resource.isFolder() || ((Folder)resource).isEmpty()) continue;
                throw new FormProcessException("Folders must be empty before they can be deleted. Attempted to delete non-empty folder " + resource.getTitle());
            }
            catch (PersistenceException exc) {
                exc.printStackTrace();
                throw new FormProcessException("An unexpected error occurred");
            }
            catch (DataObjectNotFoundException exc) {
                exc.printStackTrace();
                throw new FormProcessException("An unexpected error occurred");
            }
        }
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        int i;
        PageState state = e.getPageState();
        ArrayList<String> msgList = new ArrayList<String>();
        boolean isError = false;
        String[] selectedItems = (String[])this.m_folder.getCheckboxGroup().getValue(state);
        if (selectedItems == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (i = 0; i < selectedItems.length; ++i) {
            list.add(selectedItems[i]);
        }
        if (this.m_deleteSubmit.isSelected(state)) {
            for (i = 0; i < selectedItems.length; ++i) {
                ContentItem ci = new ContentItem(new OID("com.arsdigita.cms.ContentItem", (Object)new BigDecimal(selectedItems[i])));
                OID oid = ci.getSpecificOID();
                Resource resource = null;
                try {
                    resource = (Resource)DomainObjectFactory.newInstance((OID)oid);
                    resource.delete();
                    continue;
                }
                catch (PersistenceException exc) {
                    isError = true;
                    if (resource == null) continue;
                    msgList.add(resource.getTitle());
                    continue;
                }
                catch (DataObjectNotFoundException exc) {
                    isError = true;
                    if (resource == null) continue;
                    msgList.add(resource.getTitle());
                }
            }
        } else if (this.m_copySubmit.isSelected(state)) {
            this.m_parent.displayDestinationFolderPanel(state, list.toArray(), false);
        } else if (this.m_moveSubmit.isSelected(state)) {
            this.m_parent.displayDestinationFolderPanel(state, list.toArray(), true);
        }
        this.m_folder.getCheckboxGroup().setValue(state, null);
        if (isError) {
            this.m_parent.displayErrorMsgPanel(state, "delete", msgList);
        }
    }

    public void hideActionLinks(PageState state) {
        this.m_actionBar.setVisible(state, false);
        this.m_emptyFolderLabel.setVisible(state, true);
    }

    public void hideEmptyLabel(PageState state) {
        this.m_emptyFolderLabel.setVisible(state, false);
        this.m_actionBar.setVisible(state, true);
    }
}

