/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.cms.docmgr.ui.FolderContentsTableForm;
import com.arsdigita.cms.docmgr.ui.FolderTableModelBuilder;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

class FolderTable
extends Table
implements TableActionListener,
DMConstants {
    private static final Logger s_log = Logger.getLogger(FolderTable.class);
    private static final String FOLDER_LIST_CONTENT_IDS = "folder-listing-ids";
    static String[] s_tableHeaders = new String[]{"", "Name", "Size", "Type", "Modified", "Download", "Send", "Edit", "Version history"};
    private CheckboxGroup m_checkboxGroup;
    private ArrayParameter m_sources;
    private FolderContentsTableForm m_parent;
    private Tree m_tree;

    public FolderTable(Tree tree, FolderContentsTableForm parent) {
        super((TableModelBuilder)new FolderTableModelBuilder(tree, parent), (Object[])s_tableHeaders);
        this.m_parent = parent;
        this.m_tree = tree;
        this.m_sources = new ArrayParameter((ParameterModel)new BigDecimalParameter(FOLDER_LIST_CONTENT_IDS));
        this.m_checkboxGroup = new CheckboxGroup(FOLDER_LIST_CONTENT_IDS);
        this.m_parent.add((Component)this.m_checkboxGroup);
        this.setWidth("100%");
        this.setCellRenderers();
        this.addTableActionListener(this);
    }

    public void generateXML(PageState s, Element p) {
        long start = System.currentTimeMillis();
        super.generateXML(s, p);
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("generateXML:" + (System.currentTimeMillis() - start) + "ms"));
        }
    }

    public void register(Page p) {
        super.register(p);
        p.addComponentStateParam((Component)this, (ParameterModel)this.m_sources);
    }

    public CheckboxGroup getCheckboxGroup() {
        return this.m_checkboxGroup;
    }

    public void cellSelected(TableActionEvent e) {
        PageState state = e.getPageState();
        int col = e.getColumn();
        String rowkey = (String)e.getRowKey();
        int j = rowkey.indexOf(".");
        String id = rowkey.substring(0, j);
        char type = rowkey.charAt(j + 1);
        if (type == 'f') {
            switch (col) {
                case 7: {
                    BigDecimal folderID = new BigDecimal(id);
                    this.m_parent.getParent().displayFolderEditForm(state, folderID);
                    break;
                }
                default: {
                    String oldKey = (String)this.m_tree.getSelectedKey(state);
                    this.m_tree.setSelectedKey(state, (Object)id);
                    this.m_tree.expand(oldKey, state);
                    state.setValue((ParameterModel)this.m_parent.getPageNoParameter(), (Object)new Integer(0));
                    break;
                }
            }
        } else {
            BigDecimal docID = new BigDecimal(id);
            switch (col) {
                case 6: {
                    this.m_parent.getParent().displayFilePropSendColleagueForm(state, docID);
                    break;
                }
                case 7: {
                    if (type == 'l') {
                        this.m_parent.getParent().displayDocLinkEditForm(state, docID);
                        break;
                    }
                    this.m_parent.getParent().displayFilePropEditForm(state, docID);
                    break;
                }
                case 8: {
                    this.m_parent.getParent().displayFileVersions(state, docID);
                    break;
                }
                default: {
                    this.m_parent.getParent().displayFilePropPanel(state, docID);
                }
            }
        }
    }

    public void headSelected(TableActionEvent e) {
        throw new UnsupportedOperationException();
    }

    private void setCellRenderers() {
        this.getColumn(0).setCellRenderer((TableCellRenderer)new CheckBoxRenderer());
    }

    private final class CheckBoxRenderer
    implements TableCellRenderer {
        private CheckBoxRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            String encodedKey = (String)key;
            int j = encodedKey.indexOf(".");
            BigDecimal id = new BigDecimal(encodedKey.substring(0, j));
            Option result = new Option(FolderTable.this.m_sources.marshalElement((Object)id.abs()), "");
            result.setGroup((OptionGroup)FolderTable.this.m_checkboxGroup);
            return result;
        }
    }
}

