/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.ExternalLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.docmgr.DocMgr;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.docmgr.Repository;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.cms.docmgr.ui.DMUtils;
import com.arsdigita.cms.docmgr.ui.FolderContentsTableForm;
import com.arsdigita.cms.docmgr.ui.FolderTable;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.web.Application;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

class FolderTableModelBuilder
extends LockableImpl
implements TableModelBuilder {
    private static final Logger s_log = Logger.getLogger(FolderTableModelBuilder.class);
    public static final SimpleDateFormat dateFormatter = new SimpleDateFormat("MMMMMMMMMMM d, yyyy");
    private Tree m_tree;
    private FolderContentsTableForm m_parent;

    FolderTableModelBuilder(Tree tree, FolderContentsTableForm parent) {
        this.m_tree = tree;
        this.m_parent = parent;
    }

    public TableModel makeModel(Table t, PageState state) {
        BigDecimal fid = DMUtils.getSelectedFolderID(state, this.m_tree);
        return new FolderTableModel(fid, state);
    }

    class FolderTableModel
    implements TableModel,
    DMConstants {
        private final BigDecimal m_typeIdDocument;
        private final BigDecimal m_typeIdDocLink;
        private final BigDecimal m_typeIdDocFolder;
        private BigDecimal m_parentFolderID;
        private PageState m_state;
        private boolean m_more;
        private DataQuery m_collection;
        private boolean m_isDocument;
        private boolean m_isDocLink;
        private boolean m_isDocFolder;
        private boolean m_isFolder;
        private ContentItem m_item;
        private BigDecimal m_primaryInstID;
        private BigDecimal m_targetDocId;
        private String m_url;
        private int m_rowsPerPage = DocMgr.getConfig().getRowsPerPage();
        private User m_user;
        private boolean m_isOwner;
        private boolean m_isManager;

        FolderTableModel(BigDecimal folderID, PageState state) {
            this.m_parentFolderID = folderID;
            this.m_state = state;
            Folder parentFolder = new Folder(folderID);
            this.m_collection = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.docmgr.ui.ItemsInFolder");
            this.m_collection.setParameter("parent", (Object)folderID);
            this.m_collection.setParameter("version", (Object)parentFolder.getVersion());
            this.m_collection.addOrder("isFolder desc");
            this.m_collection.addOrder("title");
            long size = this.m_collection.size();
            if (size == 0L) {
                FolderTableModelBuilder.this.m_parent.hideActionLinks(state);
            } else {
                FolderTableModelBuilder.this.m_parent.hideEmptyLabel(state);
            }
            int maxPages = (int)(size / (long)this.m_rowsPerPage) + (size % (long)this.m_rowsPerPage > 0L ? 1 : 0);
            Integer pn = (Integer)state.getValue((ParameterModel)FolderTableModelBuilder.this.m_parent.getPageNoParameter());
            int pageNo = pn == null ? 0 : pn;
            int firstRowNo = pageNo * this.m_rowsPerPage + 1;
            int lastRowNo = firstRowNo + this.m_rowsPerPage;
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("items count:" + size + "; items per page:" + this.m_rowsPerPage + "; max pages:" + maxPages + "; pageNo:" + pageNo + "; first row no:" + firstRowNo + "; last row no:" + lastRowNo));
            }
            this.m_collection.setRange(new Integer(firstRowNo), new Integer(lastRowNo));
            this.m_typeIdDocument = ContentType.findByAssociatedObjectType((String)"com.arsdigita.cms.docmgr.Document").getID();
            this.m_typeIdDocLink = ContentType.findByAssociatedObjectType((String)"com.arsdigita.cms.docmgr.DocLink").getID();
            this.m_typeIdDocFolder = ContentType.findByAssociatedObjectType((String)"com.arsdigita.cms.docmgr.DocFolder").getID();
            this.m_user = Web.getContext().getUser();
            Application app = Web.getContext().getApplication();
            this.m_isManager = PermissionService.checkPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)app, (Party)this.m_user));
        }

        public int getColumnCount() {
            return FolderTable.s_tableHeaders.length;
        }

        public Object getElementAt(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.FALSE;
                }
                case 1: {
                    String classAttr;
                    Document resource = null;
                    boolean isLink = false;
                    boolean isExternalLink = false;
                    if (this.m_isFolder) {
                        classAttr = "isFolder";
                    } else if (this.m_isDocLink) {
                        classAttr = "isLink";
                        isLink = true;
                        isExternalLink = this.m_url != null && this.m_url.length() > 0;
                    } else {
                        classAttr = "isFile";
                    }
                    if (isLink && !isExternalLink) {
                        resource = new Document(this.m_targetDocId);
                    }
                    Label iconLabel = new Label();
                    if (classAttr != null) {
                        iconLabel.setClassAttr(classAttr);
                    }
                    SimpleContainer link = new SimpleContainer();
                    link.add((Component)iconLabel);
                    if (isExternalLink) {
                        link.add((Component)new ExternalLink((String)this.m_collection.get("title"), this.m_url));
                    } else if (isLink) {
                        Repository rep = resource.getRepository();
                        String path = Web.getConfig().getDispatcherContextPath() + rep.getPath() + "/file?" + "d_id" + "=" + resource.getID();
                        Link l = new Link(resource.getTitle(), path);
                        link.add((Component)l);
                    } else {
                        link.add((Component)new ControlLink((String)this.m_collection.get("title")));
                    }
                    String descrip = (String)this.m_collection.get("description");
                    if (descrip != null && descrip.length() > 0) {
                        link.add((Component)new Label("<br />", false));
                        link.add((Component)new Label(descrip));
                    }
                    return link;
                }
                case 2: {
                    if (this.m_isDocument) {
                        Long s = (Long)this.m_collection.get("length");
                        long size = s == null ? 0L : s;
                        return DMUtils.FileSize.formatFileSize(size);
                    }
                    if (this.m_isFolder) {
                        int foldersCount = (Integer)this.m_collection.get("foldersCount");
                        int itemsCount = (Integer)this.m_collection.get("itemsCount");
                        return new GlobalizedMessage("ui.folderTableModelBuilder.folderItemCounts", "com.arsdigita.cms.docmgr.ui.DMResources", new Object[]{String.valueOf(foldersCount), String.valueOf(itemsCount)}).localize();
                    }
                    return null;
                }
                case 3: {
                    if (this.m_isFolder) {
                        return "Folder";
                    }
                    if (this.m_isDocument) {
                        return this.m_collection.get("mimeType");
                    }
                    return "Doc Link";
                }
                case 4: {
                    Date d;
                    if (this.m_isDocument && (d = (Date)this.m_collection.get("modified")) != null) {
                        return dateFormatter.format(d);
                    }
                    return null;
                }
                case 5: {
                    if (this.m_isDocument || this.m_isDocLink && this.m_targetDocId != null) {
                        Link link = new Link("Download", "download/?d_id=" + (this.m_isDocument ? this.m_primaryInstID : this.m_targetDocId));
                        link.setClassAttr("downloadLink");
                        return link;
                    }
                    if (!this.m_isDocLink) break;
                    ExternalLink link = new ExternalLink("Download", this.m_url);
                    link.setClassAttr("downloadLink");
                    return link;
                }
                case 6: {
                    if (!this.m_isDocument) break;
                    return new ControlLink(this.m_item.getDisplayName());
                }
                case 8: {
                    if (!this.m_isOwner && !this.m_isManager || !this.m_isDocument) break;
                    return new ControlLink(this.m_item.getDisplayName());
                }
                case 7: {
                    if (!this.m_isOwner && !this.m_isManager) break;
                    return new ControlLink(this.m_item.getDisplayName());
                }
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            if (columnIndex == 5 && !this.m_isFolder) {
                if (this.m_isDocLink) {
                    if (this.m_targetDocId != null) {
                        return this.m_targetDocId.toString();
                    }
                    return this.m_url;
                }
                if (this.m_isDocument) {
                    return this.m_primaryInstID.toString();
                }
            }
            if (!(columnIndex != 1 && columnIndex != 4 || this.m_isFolder)) {
                BigDecimal retID = this.m_targetDocId;
                if (retID == null) {
                    retID = this.m_primaryInstID;
                }
                return String.valueOf(retID) + '.' + this.getType();
            }
            return String.valueOf(this.m_isFolder ? this.m_item.getID() : this.m_primaryInstID) + '.' + this.getType();
        }

        private char getType() {
            if (this.m_isFolder) {
                return 'f';
            }
            if (this.m_isDocLink) {
                return 'l';
            }
            if (this.m_isDocument) {
                return 'd';
            }
            return 'u';
        }

        public boolean nextRow() {
            boolean hasNext = this.m_collection.next();
            if (hasNext) {
                BigDecimal typeId = (BigDecimal)this.m_collection.get("typeId");
                this.m_isDocument = this.m_typeIdDocument.equals(typeId);
                this.m_isDocLink = this.m_typeIdDocLink.equals(typeId);
                this.m_isDocFolder = this.m_typeIdDocFolder.equals(typeId);
                this.m_isFolder = (Boolean)this.m_collection.get("isFolder");
                this.m_item = (ContentItem)DomainObjectFactory.newInstance((DataObject)((DataObject)this.m_collection.get("item")));
                this.m_primaryInstID = (BigDecimal)this.m_collection.get("primaryInstID");
                this.m_targetDocId = (BigDecimal)this.m_collection.get("targetDocId");
                this.m_url = (String)this.m_collection.get("url");
                this.m_isOwner = false;
            } else {
                this.m_collection.close();
            }
            return hasNext;
        }
    }
}

