/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.TabbedPane;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.docmgr.ui.BrowsePane;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.cms.docmgr.ui.DMUtils;
import com.arsdigita.cms.docmgr.ui.DocmgrBasePage;
import com.arsdigita.cms.docmgr.ui.FileDimensionalNavbar;
import com.arsdigita.cms.docmgr.ui.FileInfoHistoryPane;
import com.arsdigita.cms.docmgr.ui.FileInfoPropertiesPane;
import com.arsdigita.cms.docmgr.ui.SearchPane;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.AbstractTransactionListener;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.persistence.TransactionListener;
import com.arsdigita.templating.PresentationManager;
import com.arsdigita.templating.Templating;
import com.arsdigita.util.Assert;
import com.arsdigita.versioning.Versions;
import com.arsdigita.web.Application;
import com.arsdigita.web.BaseApplicationServlet;
import com.arsdigita.web.Web;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class RepositoryServlet
extends BaseApplicationServlet
implements DMConstants {
    private static final Logger s_log = Logger.getLogger(RepositoryServlet.class);
    private final Map m_pages = new HashMap();

    public void doInit() {
        this.addPage("/", this.buildRepositoryIndexPage());
        this.addPage("/file", this.buildFileInfoPage());
    }

    protected void doService(HttpServletRequest sreq, HttpServletResponse sresp, Application app) throws ServletException, IOException {
        String url;
        int index;
        if (s_log.isDebugEnabled()) {
            s_log.info((Object)"starting doService method");
        }
        if ((index = (url = sreq.getRequestURI()).lastIndexOf("/download/")) > 0) {
            String str = sreq.getParameter("d_id");
            s_log.debug((Object)"Downloading");
            if (str != null) {
                FileAsset file;
                BigDecimal id = new BigDecimal(str);
                s_log.debug((Object)("requesting file for id: " + str));
                Document doc = new Document(id);
                sresp.setHeader("Content-Disposition", "attachment; filename=" + URLDecoder.decode(doc.getName()));
                doc.assertPrivilege(PrivilegeDescriptor.READ);
                String param = sreq.getParameter("transID");
                if (param != null) {
                    Session ssn = SessionManager.getSession();
                    TransactionContext txn = ssn.getTransactionContext();
                    txn.addTransactionListener((TransactionListener)new AbstractTransactionListener(){

                        public void beforeCommit(TransactionContext txn) {
                            Assert.fail((String)"uncommittable transaction");
                        }
                    });
                    Kernel.getContext().getTransaction().setCommitRequested(false);
                    BigInteger transID = new BigInteger(param);
                    Versions.rollback((OID)doc.getOID(), (BigInteger)transID);
                }
                sresp.setContentType(null != (file = doc.getFile()).getMimeType() ? file.getMimeType().getMimeType() : "text/plain");
                ServletOutputStream os = null;
                try {
                    os = sresp.getOutputStream();
                    file.writeBytes((OutputStream)os);
                }
                catch (IOException iox) {
                    iox.printStackTrace();
                    throw new RuntimeException(iox.getMessage());
                }
                finally {
                    try {
                        os.close();
                    }
                    catch (IOException iox2) {}
                }
            }
        } else {
            Page page;
            s_log.debug((Object)"show repository page");
            String pathInfo = sreq.getPathInfo();
            Assert.exists((Object)pathInfo, (String)"String pathInfo");
            if (pathInfo.length() > 1 && pathInfo.endsWith("/")) {
                pathInfo = pathInfo.substring(0, pathInfo.length() - 1);
            }
            if ((page = (Page)this.m_pages.get(pathInfo)) != null) {
                com.arsdigita.xml.Document doc = page.buildDocument(sreq, sresp);
                PresentationManager pm = Templating.getPresentationManager();
                pm.servePage(doc, sreq, sresp);
            } else {
                sresp.sendError(404, "No such page for path " + pathInfo);
            }
        }
        if (s_log.isDebugEnabled()) {
            s_log.info((Object)"completed doService method");
        }
    }

    protected void addPage(String pathInfo, Page page) {
        Assert.exists((Object)pathInfo, String.class);
        Assert.exists((Object)page, Page.class);
        Assert.isTrue((boolean)pathInfo.startsWith("/"), (String)"path starts not with '/'");
        this.m_pages.put(pathInfo, page);
    }

    private Page buildRepositoryIndexPage() {
        DocmgrBasePage p = new DocmgrBasePage();
        TabbedPane tb = new TabbedPane();
        tb.setIdAttr("page-body");
        p.add((Component)new BrowsePane());
        p.lock();
        return p;
    }

    protected Page buildFileInfoPage() {
        final BigDecimalParameter fileIDParam = new BigDecimalParameter("d_id");
        DocmgrBasePage p = new DocmgrBasePage(fileIDParam){

            @Override
            protected void buildTitle() {
                Label title = new Label();
                title.addPrintListener(new PrintListener(){

                    public void prepare(PrintEvent e) {
                        PageState state = e.getPageState();
                        Label t = (Label)e.getTarget();
                        BigDecimal fid = (BigDecimal)state.getValue((ParameterModel)fileIDParam);
                        if (fid != null) {
                            t.setLabel(DMUtils.getFile(fid).getTitle());
                        }
                    }
                });
                this.setTitle(title);
            }

            @Override
            protected void buildContextBar() {
                FileDimensionalNavbar navbar = new FileDimensionalNavbar(new RequestLocal(){

                    protected Object initialValue(PageState state) {
                        BigDecimal id = (BigDecimal)state.getValue((ParameterModel)fileIDParam);
                        return new Document(id);
                    }
                });
                navbar.setClassAttr("portalNavbar");
                this.getHeader().add((Component)navbar);
            }
        };
        Label backLinkLabel = new Label(new GlobalizedMessage("ui.fileinfo.goback.label", "com.arsdigita.cms.docmgr.ui.DMResources"));
        backLinkLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState state = e.getPageState();
                Label t = (Label)e.getTarget();
                String fixed = t.getLabel(e.getPageState());
                String url = Web.getContext().getApplication().getTitle();
                t.setLabel(fixed + " " + url);
            }
        });
        ActionLink backLink = new ActionLink((Component)backLinkLabel);
        backLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                String url = Web.getContext().getApplication().getPath();
                BigDecimal fid = (BigDecimal)state.getValue((ParameterModel)fileIDParam);
                if (fid != null) {
                    url = url + "?d_id=" + fid;
                }
                try {
                    DispatcherHelper.sendRedirect((HttpServletRequest)state.getRequest(), (HttpServletResponse)state.getResponse(), (String)url);
                }
                catch (IOException iox) {
                    throw new RuntimeException("Redirect to Application failed" + iox);
                }
            }
        });
        backLink.setClassAttr("actionLink");
        p.add((Component)backLink);
        TabbedPane tb = new TabbedPane();
        tb.setIdAttr("page-body");
        tb.addTab((Component)FILE_INFO_PROPERTIES_TITLE, (Component)new FileInfoPropertiesPane(p));
        tb.addTab((Component)FILE_INFO_HISTORY_TITLE, (Component)new FileInfoHistoryPane(p));
        p.add((Component)tb);
        p.lock();
        return p;
    }

    protected Page buildSearchPage() {
        DocmgrBasePage p = new DocmgrBasePage();
        TabbedPane tb = new TabbedPane();
        tb.setIdAttr("page-body");
        p.add((Component)new SearchPane());
        p.lock();
        return p;
    }
}

