/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PaginationModelBuilder;
import com.arsdigita.bebop.Paginator;
import com.arsdigita.bebop.list.AbstractListModelBuilder;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.cms.docmgr.search.SearchResult;
import com.arsdigita.cms.docmgr.search.SearchResults;
import com.arsdigita.cms.docmgr.ui.SearchForm;
import java.math.BigDecimal;
import java.util.Iterator;
import org.apache.log4j.Category;

public class SearchListModelBuilder
extends AbstractListModelBuilder
implements PaginationModelBuilder {
    private static final Category s_log = Category.getInstance(SearchListModelBuilder.class);
    private SearchForm m_form;

    public SearchListModelBuilder(SearchForm form) {
        this.m_form = form;
    }

    public int getTotalSize(Paginator p, PageState ps) {
        SearchResults results = this.m_form.getSearchHits(ps);
        if (results == null) {
            return 0;
        }
        int totalSize = (int)results.getTotalSize();
        s_log.debug((Object)("Setting paginator: size = " + new Integer((int)results.getTotalSize()).toString() + "first = " + new Integer(p.getFirst(ps)).toString() + "last = " + new Integer(p.getLast(ps)).toString()));
        results.setRange(new Integer(p.getFirst(ps)), new Integer(p.getLast(ps) + 1));
        p.setPageSize(ps, 10);
        s_log.debug((Object)("totoalsize is " + new BigDecimal(totalSize).toString()));
        return totalSize;
    }

    public boolean isVisible(PageState state) {
        return this.m_form.isVisible(state);
    }

    public ListModel makeModel(List list, PageState state) {
        SearchResults results = this.m_form.getSearchHits(state);
        if (results == null) {
            return List.EMPTY_MODEL;
        }
        return new SearchListModel(results);
    }

    private class SearchListModel
    implements ListModel {
        private Iterator m_results;
        private Object m_result;

        public SearchListModel(SearchResults results) {
            if (results != null) {
                this.m_results = results.getResults();
                s_log.debug((Object)("In SearchListModelBuilder - Iterator ID: " + this.m_results.toString()));
            }
        }

        public boolean next() {
            if (this.m_results != null && this.m_results.hasNext()) {
                this.m_result = this.m_results.next();
                return true;
            }
            return false;
        }

        public Object getElement() {
            if (this.m_result != null) {
                return this.m_result;
            }
            return null;
        }

        public String getKey() {
            SearchResult result = (SearchResult)this.getElement();
            return result.getID().toString();
        }

        public void setRange(Integer start, Integer end) {
        }
    }
}

