/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui.authoring;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.docmgr.DocLink;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import java.math.BigDecimal;

public class DocLinkPropertyForm
extends BasicPageForm
implements FormProcessListener,
FormValidationListener,
FormInitListener {
    public static final String TARGET_DOC_ID = "targetLinkID";
    public static final String EXTERNAL_URL = "externalURL";
    public static final String DESCRIPTION = "description";

    public DocLinkPropertyForm(ItemSelectionModel itemModel) {
        super("id", itemModel);
    }

    protected void addWidgets() {
        super.addWidgets();
        this.add((Component)new Label("Target Document Link ID:"));
        BigDecimalParameter targetDocParam = new BigDecimalParameter(TARGET_DOC_ID);
        TextField targetDoc = new TextField((ParameterModel)targetDocParam);
        this.add((Component)targetDoc);
        this.add((Component)new Label("External URL"));
        StringParameter externalUrlParam = new StringParameter(EXTERNAL_URL);
        TextField externalURL = new TextField((ParameterModel)externalUrlParam);
        this.add((Component)externalURL);
        this.add((Component)new Label("Description:"));
        StringParameter descriptionParam = new StringParameter(DESCRIPTION);
        TextArea description = new TextArea((ParameterModel)descriptionParam);
        description.setCols(40);
        description.setRows(5);
        this.add((Component)description);
    }

    public void init(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        DocLink docLink = (DocLink)super.initBasicWidgets(fse);
        if (docLink.getTarget() != null) {
            data.put((Object)TARGET_DOC_ID, (Object)docLink.getTarget().getID());
        }
        data.put((Object)EXTERNAL_URL, (Object)docLink.getExternalURL());
        data.put((Object)DESCRIPTION, (Object)docLink.getDescription());
    }

    public void validate(FormSectionEvent fse) throws FormProcessException {
        if (this.getSaveCancelSection().getSaveButton().isSelected(fse.getPageState())) {
            String desc;
            FormData data = fse.getFormData();
            String url = data.getString((Object)EXTERNAL_URL);
            if (url != null && url.length() > 4000) {
                data.addError(EXTERNAL_URL, "This parameter is longer than 4000 characters.");
            }
            if ((desc = data.getString((Object)DESCRIPTION)) != null && desc.length() > 4000) {
                data.addError(DESCRIPTION, "This parameter is longer than 4000 characters.");
            }
        }
    }

    public void process(FormSectionEvent fse) throws FormProcessException {
        FormData data = fse.getFormData();
        DocLink docLink = (DocLink)super.processBasicWidgets(fse);
        if (docLink != null && this.getSaveCancelSection().getSaveButton().isSelected(fse.getPageState())) {
            if (data.get((Object)TARGET_DOC_ID) != null) {
                docLink.setTarget(new Document((BigDecimal)data.get((Object)TARGET_DOC_ID)));
            }
            docLink.setExternalURL(data.getString((Object)EXTERNAL_URL));
            docLink.setDescription(data.getString((Object)DESCRIPTION));
            docLink.save();
        }
    }
}

