/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui.authoring;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.cms.BinaryAsset;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.xml.Element;

public class FileDisplay
extends SimpleComponent {
    private FileAsset m_asset;

    public void setFileAsset(FileAsset asset) {
        this.m_asset = asset;
    }

    public void generateXML(PageState state, Element parent) {
        if (this.isVisible(state) && this.m_asset != null) {
            Element element = new Element("cms:FileDisplay", "http://www.arsdigita.com/cms/1.0");
            this.generateFilePropertiesXML(this.m_asset, state, element);
            this.exportAttributes(element);
            parent.addContent(element);
        }
    }

    protected void generateFilePropertiesXML(FileAsset asset, PageState state, Element element) {
        String alt_text;
        element.addAttribute("src", Utilities.getAssetURL((BinaryAsset)asset));
        MimeType mimeType = asset.getMimeType();
        if (mimeType != null) {
            element.addAttribute("mime_type", mimeType.getLabel());
        }
        if ((alt_text = asset.getDescription()) != null && !alt_text.equals("")) {
            element.addAttribute("alt_text", alt_text);
        }
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }
}

