/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui.authoring;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.form.FileUpload;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.docmgr.ui.authoring.FileDisplay;
import com.arsdigita.dispatcher.MultipartHttpServletRequest;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Category;

class FileFormSection
extends FormSection
implements FormValidationListener {
    public static final Category s_log = Category.getInstance(FileFormSection.class);
    public static final String FILE_OPTIONS = "_fileOptions";
    public static final String DESCRIPTION = "_description";
    public static final String UPLOAD_OPTION = "upload";
    public static final String DELETE_OPTION = "delete";
    public static final String IGNORE_OPTION = "ignore";
    public FileDisplay m_fileDisplay;
    public String m_file;
    public FileUpload m_upload;

    public FileFormSection(String file, String formLabel) {
        this.m_file = file;
        this.m_fileDisplay = new FileDisplay();
        StringParameter fileOptions = new StringParameter(file + FILE_OPTIONS);
        RadioGroup fileGroup = new RadioGroup((ParameterModel)fileOptions);
        fileGroup.addOption(new Option(UPLOAD_OPTION, UPLOAD_OPTION));
        fileGroup.addOption(new Option(DELETE_OPTION, DELETE_OPTION));
        fileGroup.addOption(new Option(IGNORE_OPTION, IGNORE_OPTION));
        fileGroup.setDefaultValue((Object)IGNORE_OPTION);
        this.m_fileDisplay.setName(file);
        Label currentLabel = new Label("Existing " + formLabel);
        this.add((Component)currentLabel);
        this.add((Component)this.m_fileDisplay);
        this.add((Component)new Label(formLabel + "(uploading will replace existing file)"));
        this.m_upload = new FileUpload(file);
        this.add((Component)this.m_upload);
        this.add((Component)new Label(""));
        this.add((Component)fileGroup);
        this.addValidationListener(this);
    }

    public void initialize(FormSectionEvent e, FileAsset asset) {
        if (asset != null) {
            s_log.debug((Object)"asset exists");
        } else {
            this.m_fileDisplay.setName("");
            s_log.debug((Object)"asset is null");
        }
        this.m_fileDisplay.setFileAsset(asset);
    }

    public FileAsset process(FormSectionEvent e, FileAsset asset) throws FormProcessException {
        FormData data = e.getFormData();
        String fileOption = (String)data.get((Object)(this.m_file + FILE_OPTIONS));
        if (fileOption.equals(UPLOAD_OPTION)) {
            s_log.debug((Object)"uploading file");
            String fileName = (String)data.get((Object)this.m_file);
            if (fileName != null && fileName.length() > 0) {
                File fileFile = ((MultipartHttpServletRequest)e.getPageState().getRequest()).getFile(this.m_file);
                s_log.debug((Object)("file: " + fileFile));
                FileAsset a = new FileAsset();
                a.setName("file" + a.getID());
                try {
                    s_log.debug((Object)("fileName: " + fileName));
                    a.loadFromFile(fileName, fileFile, "file/pdf");
                    s_log.debug((Object)"saving");
                    a.setDescription(fileName);
                    a.save();
                    return a;
                }
                catch (IOException ex) {
                    throw new FormProcessException((Throwable)ex);
                }
            }
            throw new FormProcessException("File Option was null");
        }
        if (fileOption != null && fileOption.equals(DELETE_OPTION)) {
            s_log.debug((Object)"deleting file");
            return null;
        }
        s_log.debug((Object)"ignoring image");
        return asset;
    }

    public void validate(FormSectionEvent e) {
        FormData data = e.getFormData();
        String fileOption = (String)data.get((Object)(this.m_file + FILE_OPTIONS));
        String fileName = (String)e.getFormData().get((Object)this.m_file);
        s_log.debug((Object)("validate option: " + fileOption));
        s_log.debug((Object)("validate filename: " + fileName));
        if (fileOption.equals(IGNORE_OPTION)) {
            if (fileName != null && !fileName.equals("")) {
                data.addError("You specified an file when choosing to ignore");
            }
        } else if (fileOption.equals(DELETE_OPTION)) {
            if (fileName != null && !fileName.equals("")) {
                data.addError("You specified an file when choosing to delete");
            }
        } else if (fileName == null || fileName.equals("")) {
            data.addError("You did not specify an file when choosing to upload");
        }
    }
}

