/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui.content;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.list.AbstractListModelBuilder;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemCollection;
import com.arsdigita.cms.dispatcher.CMSPage;
import com.arsdigita.cms.docmgr.DocFolder;
import com.arsdigita.cms.docmgr.Repository;
import com.arsdigita.cms.docmgr.ui.content.DocFolderNavbar;
import com.arsdigita.cms.docmgr.ui.tree.DocFolderContentTreeRenderer;
import com.arsdigita.cms.docmgr.ui.tree.DocFoldersContentTree;
import com.arsdigita.cms.docmgr.ui.tree.DocFoldersContentTreeModel;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.SessionManager;
import org.apache.log4j.Logger;

public class DocIndexPage
extends CMSPage
implements RequestListener {
    private static final Logger s_log = Logger.getLogger(DocIndexPage.class);
    private DocFoldersContentTree m_foldersTree;

    public DocIndexPage() {
        super(new Label((PrintListener)new TitlePrinter()), (Container)new SimpleContainer());
        this.add((Component)new DocFolderNavbar());
        BoxPanel m_mainContainer = new BoxPanel(1);
        this.m_foldersTree = new DocFoldersContentTree(new DocFoldersContentTreeModel());
        this.m_foldersTree.setCellRenderer(new DocFolderContentTreeRenderer());
        BoxPanel leftSide = new BoxPanel();
        leftSide.add((Component)this.m_foldersTree);
        m_mainContainer.add((Component)leftSide);
        BoxPanel rightSide = new BoxPanel();
        rightSide.setClassAttr("main");
        rightSide.add((Component)new BundleList());
        m_mainContainer.add((Component)rightSide);
        this.add((Component)m_mainContainer);
        this.addRequestListener(this);
    }

    public void pageRequested(RequestEvent e) {
        s_log.debug((Object)"PAGE IS REQUESTED");
        PageState state = e.getPageState();
        this.m_foldersTree.expandPath(state);
    }

    protected static final GlobalizedMessage gz(String key) {
        return GlobalizationUtil.globalize((String)key);
    }

    private class CellRenderer
    implements ListCellRenderer {
        private CellRenderer() {
        }

        public final Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
            Link l = new Link((String)value, key);
            l.setTargetFrame("docview");
            return l;
        }
    }

    private static class BundleListModelBuilder
    extends AbstractListModelBuilder {
        private BundleListModelBuilder() {
        }

        public final ListModel makeModel(List list, PageState state) {
            Folder parent = (Folder)CMS.getContext().getContentItem();
            DataCollection bundles = SessionManager.getSession().retrieve("com.arsdigita.cms.ContentBundle");
            bundles.addEqualsFilter("parent", (Object)parent.getID());
            bundles.addOrder("lower(displayName)");
            return new Model(new ItemCollection(bundles));
        }

        private class Model
        implements ListModel {
            private final ItemCollection m_items;

            Model(ItemCollection items) {
                this.m_items = items;
            }

            public final boolean next() {
                if (this.m_items.next()) {
                    return true;
                }
                this.m_items.close();
                return false;
            }

            public final Object getElement() {
                return this.m_items.getDisplayName();
            }

            public final String getKey() {
                return this.m_items.getName();
            }
        }
    }

    private class BundleList
    extends List {
        BundleList() {
            super((ListModelBuilder)new BundleListModelBuilder());
            this.setCellRenderer(new CellRenderer());
        }

        public final boolean isVisible(PageState state) {
            return CMS.getContext().hasContentItem() && super.isVisible(state);
        }
    }

    private static class TitlePrinter
    implements PrintListener {
        private TitlePrinter() {
        }

        public final void prepare(PrintEvent e) {
            Label label = (Label)e.getTarget();
            if (CMS.getContext().hasContentItem()) {
                DocFolder df = (DocFolder)CMS.getContext().getContentItem();
                if (df.isRoot()) {
                    Repository rep = DocFolder.getRepository(df = (DocFolder)df.getWorkingVersion());
                    if (rep == null) {
                        s_log.error((Object)"repository is null");
                    } else {
                        label.setLabel(rep.getDisplayName());
                    }
                } else {
                    label.setLabel(df.getTitle());
                }
            }
        }
    }
}

