/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.bebop.Page;
import com.arsdigita.forum.ForumPageBuilder;
import com.arsdigita.forum.PageBuilder;
import com.arsdigita.forum.ThreadPageBuilder;
import com.arsdigita.util.Assert;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class ForumPageFactory {
    private static final Logger logger = Logger.getLogger(ForumPageFactory.class);
    public static final String THREAD_PAGE = "thread";
    public static final String FORUM_PAGE = "forum";
    private static Map pageBuilders = new HashMap();

    public ForumPageFactory() {
        logger.debug((Object)"Constructor starting...");
        pageBuilders.put(THREAD_PAGE, new ThreadPageBuilder());
        pageBuilders.put(FORUM_PAGE, new ForumPageBuilder());
        logger.debug((Object)"Constructor finished.");
    }

    public static Page getPage(String pageType) {
        Assert.isTrue((boolean)pageBuilders.containsKey(pageType), (String)("Requested page type (" + pageType + ") does not have a builder registered"));
        PageBuilder builder = (PageBuilder)pageBuilders.get(pageType);
        Page page = builder.buildPage();
        page.lock();
        return page;
    }

    public static Iterator getPages() {
        return pageBuilders.keySet().iterator();
    }

    public static void registerPageBuilder(String pageType, PageBuilder builder) {
        pageBuilders.put(pageType, builder);
    }
}

