/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.Subscription;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.mail.Mail;
import com.arsdigita.messaging.ThreadedMessage;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class ForumSubscription
extends Subscription {
    private static final Logger s_log = Logger.getLogger(ForumSubscription.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.forum.ForumSubscription";
    public static final String IS_MODERATION_ALERT = "isModerationAlert";
    public static final String FORUM = "forum";
    private Forum m_forum;

    public ForumSubscription(Forum forum) {
        this(BASE_DATA_OBJECT_TYPE, forum);
        this.setIsModerationAlert(false);
    }

    public ForumSubscription(String typeName, Forum forum) {
        super(typeName);
        Assert.exists((Object)typeName, String.class);
        Assert.exists((Object)((Object)forum), Forum.class);
        this.setForum(forum);
    }

    protected ForumSubscription(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    protected ForumSubscription(BigDecimal id) throws DataObjectNotFoundException {
        super(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    protected ForumSubscription(DataObject data) {
        super(data);
    }

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public String getSubscriptionGroupName() {
        return "Instant Alert Subscription Group";
    }

    public Forum getForum() {
        DataObject forumData;
        if (this.m_forum == null && (forumData = (DataObject)this.get(FORUM)) != null) {
            this.m_forum = (Forum)DomainObjectFactory.newInstance((DataObject)forumData);
        }
        return this.m_forum;
    }

    public void doWriteCheck() {
        this.getForum().assertPrivilege(PrivilegeDescriptor.READ);
    }

    private void setForum(Forum forum) {
        this.m_forum = forum;
        this.setAssociation(FORUM, (DomainObject)this.m_forum);
        if (this.getGroup() != null) {
            this.getGroup().setName(this.getGroupName(forum));
            forum.getGroup().addSubgroup(this.getGroup());
        }
    }

    public String getGroupName(Forum forum) {
        return forum.getTitle() + " " + this.getSubscriptionGroupName();
    }

    protected void afterSave() {
        PermissionService.setContext((ACSObject)this, (ACSObject)this.getForum());
        super.afterSave();
    }

    @Override
    public String getSignature(ThreadedMessage post) {
        StringBuffer sb = new StringBuffer();
        if (Mail.getConfig().sendHTMLMessageAsHTMLEmail()) {
            sb.append("<br><br>\n<hr>\n<br><br>\n");
            sb.append(ForumSubscription.getReturnURLMessage((Post)post));
            sb.append("<br><br>\n<hr>\n<br><br>\n");
            sb.append("This is an automated alert from the Discussion Forum system. ");
            sb.append("You are receiving this email because you subscribed to ");
            sb.append("alerts on this forum. To unsubscribe, follow the link above, return to the thread list and change the settings under the alerts tab.\n");
            sb.append("</font>");
        } else {
            sb.append(ForumSubscription.getReturnURLMessage((Post)post));
        }
        return sb.toString();
    }

    public static ForumSubscription getFromForum(Forum forum) {
        DataCollection subs = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        subs.addEqualsFilter("forum.id", (Object)forum.getID());
        subs.addEqualsFilter("digest.id", null);
        if (subs.next()) {
            ForumSubscription sub = new ForumSubscription(subs.getDataObject());
            subs.close();
            return sub;
        }
        return null;
    }

    public void setIsModerationAlert(boolean isModerationAlert) {
        this.set(IS_MODERATION_ALERT, new Boolean(isModerationAlert));
    }

    public void setIsModerationAlert(Boolean isModerationAlert) {
        this.set(IS_MODERATION_ALERT, isModerationAlert);
    }
}

